/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import java.lang.reflect.Field;
import java.util.List;
import java.util.function.BiConsumer;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SCCreativeModeTabs;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.AbstractKeypadFurnaceBlockEntity;
import net.geforcemods.securitycraft.blockentities.BlockPocketManagerBlockEntity;
import net.geforcemods.securitycraft.blockentities.ClaymoreBlockEntity;
import net.geforcemods.securitycraft.blockentities.InventoryScannerBlockEntity;
import net.geforcemods.securitycraft.blockentities.KeypadBarrelBlockEntity;
import net.geforcemods.securitycraft.blockentities.KeypadChestBlockEntity;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.geforcemods.securitycraft.blockentities.ReinforcedChiseledBookshelfBlockEntity;
import net.geforcemods.securitycraft.blockentities.ReinforcedDispenserBlockEntity;
import net.geforcemods.securitycraft.blockentities.ReinforcedHopperBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blockentities.TrophySystemBlockEntity;
import net.geforcemods.securitycraft.entity.SecuritySeaBoat;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.client.BlockPocketManagerFailedActivation;
import net.geforcemods.securitycraft.network.client.InteractWithFrame;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.network.client.PlayAlarmSound;
import net.geforcemods.securitycraft.network.client.RefreshDisguisableModel;
import net.geforcemods.securitycraft.network.client.SetCameraView;
import net.geforcemods.securitycraft.network.client.SetTrophySystemTarget;
import net.geforcemods.securitycraft.network.client.UpdateLaserColors;
import net.geforcemods.securitycraft.network.client.UpdateLogger;
import net.geforcemods.securitycraft.network.server.AssembleBlockPocket;
import net.geforcemods.securitycraft.network.server.CheckBriefcasePasscode;
import net.geforcemods.securitycraft.network.server.CheckPasscode;
import net.geforcemods.securitycraft.network.server.ClearChangeDetectorServer;
import net.geforcemods.securitycraft.network.server.ClearLoggerServer;
import net.geforcemods.securitycraft.network.server.DismountCamera;
import net.geforcemods.securitycraft.network.server.MountCamera;
import net.geforcemods.securitycraft.network.server.RemoteControlMine;
import net.geforcemods.securitycraft.network.server.RemoveCameraTag;
import net.geforcemods.securitycraft.network.server.RemoveMineFromMRAT;
import net.geforcemods.securitycraft.network.server.RemovePositionFromSSS;
import net.geforcemods.securitycraft.network.server.RemoveSentryFromSRAT;
import net.geforcemods.securitycraft.network.server.SetBriefcasePasscodeAndOwner;
import net.geforcemods.securitycraft.network.server.SetCameraPowered;
import net.geforcemods.securitycraft.network.server.SetDefaultCameraViewingDirection;
import net.geforcemods.securitycraft.network.server.SetGhostSlot;
import net.geforcemods.securitycraft.network.server.SetKeycardUses;
import net.geforcemods.securitycraft.network.server.SetListModuleData;
import net.geforcemods.securitycraft.network.server.SetPasscode;
import net.geforcemods.securitycraft.network.server.SetSentryMode;
import net.geforcemods.securitycraft.network.server.SetStateOnDisguiseModule;
import net.geforcemods.securitycraft.network.server.SyncAlarmSettings;
import net.geforcemods.securitycraft.network.server.SyncBlockChangeDetector;
import net.geforcemods.securitycraft.network.server.SyncBlockPocketManager;
import net.geforcemods.securitycraft.network.server.SyncBlockReinforcer;
import net.geforcemods.securitycraft.network.server.SyncFrame;
import net.geforcemods.securitycraft.network.server.SyncKeycardSettings;
import net.geforcemods.securitycraft.network.server.SyncLaserSideConfig;
import net.geforcemods.securitycraft.network.server.SyncProjector;
import net.geforcemods.securitycraft.network.server.SyncRiftStabilizer;
import net.geforcemods.securitycraft.network.server.SyncSSSSettingsOnServer;
import net.geforcemods.securitycraft.network.server.SyncSecureRedstoneInterface;
import net.geforcemods.securitycraft.network.server.SyncTrophySystem;
import net.geforcemods.securitycraft.network.server.ToggleBlockPocketManager;
import net.geforcemods.securitycraft.network.server.ToggleModule;
import net.geforcemods.securitycraft.network.server.ToggleNightVision;
import net.geforcemods.securitycraft.network.server.ToggleOption;
import net.geforcemods.securitycraft.network.server.UpdateSliderValue;
import net.geforcemods.securitycraft.util.RegisterItemBlock;
import net.geforcemods.securitycraft.util.Reinforced;
import net.geforcemods.securitycraft.util.SCItemGroup;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.brewing.BrewingRecipeRegistry;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.common.crafting.NBTIngredient;
import net.neoforged.neoforge.common.util.MutableHashedLinkedMap;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(modid="securitycraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistrationHandler {
    private RegistrationHandler() {
    }

    @SubscribeEvent
    public static void onRegister(RegisterEvent event) {
        event.register(Registries.ITEM, helper -> {
            for (Field field : SCContent.class.getFields()) {
                try {
                    BlockItem blockItem;
                    Block block;
                    SCItemGroup group;
                    if (field.isAnnotationPresent(Reinforced.class) && field.getAnnotation(Reinforced.class).registerBlockItem()) {
                        group = field.getAnnotation(Reinforced.class).itemGroup();
                        block = (Block)((DeferredBlock)field.get(null)).get();
                        blockItem = new BlockItem(block, new Item.Properties().fireResistant());
                        helper.register(Utils.getRegistryName(block), (Object)blockItem);
                        if (group == SCItemGroup.MANUAL) continue;
                        SCCreativeModeTabs.STACKS_FOR_ITEM_GROUPS.get((Object)group).add(new ItemStack((ItemLike)blockItem));
                        continue;
                    }
                    if (!field.isAnnotationPresent(RegisterItemBlock.class)) continue;
                    group = field.getAnnotation(RegisterItemBlock.class).value();
                    block = (Block)((DeferredBlock)field.get(null)).get();
                    blockItem = new BlockItem(block, new Item.Properties());
                    helper.register(Utils.getRegistryName(block), (Object)blockItem);
                    if (group == SCItemGroup.MANUAL) continue;
                    SCCreativeModeTabs.STACKS_FOR_ITEM_GROUPS.get((Object)group).add(new ItemStack((ItemLike)blockItem));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        });
        event.register(Registries.SOUND_EVENT, helper -> {
            for (int i = 0; i < SCSounds.values().length; ++i) {
                SCSounds sound = SCSounds.values()[i];
                helper.register(sound.location, (Object)sound.event);
            }
        });
    }

    @SubscribeEvent
    public static void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)SCContent.SENTRY_ENTITY.get(), Mob.createMobAttributes().build());
    }

    @SubscribeEvent
    public static void registerPackets(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar("securitycraft").versioned(SecurityCraft.getVersion());
        RegistrationHandler.clientPacket(registrar, BlockPocketManagerFailedActivation.ID, BlockPocketManagerFailedActivation::new, BlockPocketManagerFailedActivation::handle);
        RegistrationHandler.clientPacket(registrar, InteractWithFrame.ID, InteractWithFrame::new, InteractWithFrame::handle);
        RegistrationHandler.clientPacket(registrar, OpenScreen.ID, OpenScreen::new, OpenScreen::handle);
        RegistrationHandler.clientPacket(registrar, PlayAlarmSound.ID, PlayAlarmSound::new, PlayAlarmSound::handle);
        RegistrationHandler.clientPacket(registrar, RefreshDisguisableModel.ID, RefreshDisguisableModel::new, RefreshDisguisableModel::handle);
        RegistrationHandler.clientPacket(registrar, SetCameraView.ID, SetCameraView::new, SetCameraView::handle);
        RegistrationHandler.clientPacket(registrar, SetTrophySystemTarget.ID, SetTrophySystemTarget::new, SetTrophySystemTarget::handle);
        RegistrationHandler.clientPacket(registrar, UpdateLaserColors.ID, UpdateLaserColors::new, UpdateLaserColors::handle);
        RegistrationHandler.clientPacket(registrar, UpdateLogger.ID, UpdateLogger::new, UpdateLogger::handle);
        RegistrationHandler.serverPacket(registrar, AssembleBlockPocket.ID, AssembleBlockPocket::new, AssembleBlockPocket::handle);
        RegistrationHandler.serverPacket(registrar, CheckBriefcasePasscode.ID, CheckBriefcasePasscode::new, CheckBriefcasePasscode::handle);
        RegistrationHandler.serverPacket(registrar, CheckPasscode.ID, CheckPasscode::new, CheckPasscode::handle);
        RegistrationHandler.serverPacket(registrar, ClearChangeDetectorServer.ID, ClearChangeDetectorServer::new, ClearChangeDetectorServer::handle);
        RegistrationHandler.serverPacket(registrar, ClearLoggerServer.ID, ClearLoggerServer::new, ClearLoggerServer::handle);
        RegistrationHandler.serverPacket(registrar, DismountCamera.ID, DismountCamera::new, DismountCamera::handle);
        RegistrationHandler.serverPacket(registrar, MountCamera.ID, MountCamera::new, MountCamera::handle);
        RegistrationHandler.serverPacket(registrar, RemoteControlMine.ID, RemoteControlMine::new, RemoteControlMine::handle);
        RegistrationHandler.serverPacket(registrar, RemoveCameraTag.ID, RemoveCameraTag::new, RemoveCameraTag::handle);
        RegistrationHandler.serverPacket(registrar, RemoveMineFromMRAT.ID, RemoveMineFromMRAT::new, RemoveMineFromMRAT::handle);
        RegistrationHandler.serverPacket(registrar, RemovePositionFromSSS.ID, RemovePositionFromSSS::new, RemovePositionFromSSS::handle);
        RegistrationHandler.serverPacket(registrar, RemoveSentryFromSRAT.ID, RemoveSentryFromSRAT::new, RemoveSentryFromSRAT::handle);
        RegistrationHandler.serverPacket(registrar, SetBriefcasePasscodeAndOwner.ID, SetBriefcasePasscodeAndOwner::new, SetBriefcasePasscodeAndOwner::handle);
        RegistrationHandler.serverPacket(registrar, SetCameraPowered.ID, SetCameraPowered::new, SetCameraPowered::handle);
        RegistrationHandler.serverPacket(registrar, SetDefaultCameraViewingDirection.ID, SetDefaultCameraViewingDirection::new, SetDefaultCameraViewingDirection::handle);
        RegistrationHandler.serverPacket(registrar, SetGhostSlot.ID, SetGhostSlot::new, SetGhostSlot::handle);
        RegistrationHandler.serverPacket(registrar, SetKeycardUses.ID, SetKeycardUses::new, SetKeycardUses::handle);
        RegistrationHandler.serverPacket(registrar, SetListModuleData.ID, SetListModuleData::new, SetListModuleData::handle);
        RegistrationHandler.serverPacket(registrar, SetPasscode.ID, SetPasscode::new, SetPasscode::handle);
        RegistrationHandler.serverPacket(registrar, SetSentryMode.ID, SetSentryMode::new, SetSentryMode::handle);
        RegistrationHandler.serverPacket(registrar, SetStateOnDisguiseModule.ID, SetStateOnDisguiseModule::new, SetStateOnDisguiseModule::handle);
        RegistrationHandler.serverPacket(registrar, SyncAlarmSettings.ID, SyncAlarmSettings::new, SyncAlarmSettings::handle);
        RegistrationHandler.serverPacket(registrar, SyncBlockChangeDetector.ID, SyncBlockChangeDetector::new, SyncBlockChangeDetector::handle);
        RegistrationHandler.serverPacket(registrar, SyncBlockPocketManager.ID, SyncBlockPocketManager::new, SyncBlockPocketManager::handle);
        RegistrationHandler.serverPacket(registrar, SyncBlockReinforcer.ID, SyncBlockReinforcer::new, SyncBlockReinforcer::handle);
        RegistrationHandler.serverPacket(registrar, SyncFrame.ID, SyncFrame::new, SyncFrame::handle);
        RegistrationHandler.serverPacket(registrar, SyncKeycardSettings.ID, SyncKeycardSettings::new, SyncKeycardSettings::handle);
        RegistrationHandler.serverPacket(registrar, SyncLaserSideConfig.ID, SyncLaserSideConfig::new, SyncLaserSideConfig::handle);
        RegistrationHandler.serverPacket(registrar, SyncProjector.ID, SyncProjector::new, SyncProjector::handle);
        RegistrationHandler.serverPacket(registrar, SyncRiftStabilizer.ID, SyncRiftStabilizer::new, SyncRiftStabilizer::handle);
        RegistrationHandler.serverPacket(registrar, SyncSSSSettingsOnServer.ID, SyncSSSSettingsOnServer::new, SyncSSSSettingsOnServer::handle);
        RegistrationHandler.serverPacket(registrar, SyncSecureRedstoneInterface.ID, SyncSecureRedstoneInterface::new, SyncSecureRedstoneInterface::handle);
        RegistrationHandler.serverPacket(registrar, SyncTrophySystem.ID, SyncTrophySystem::new, SyncTrophySystem::handle);
        RegistrationHandler.serverPacket(registrar, ToggleBlockPocketManager.ID, ToggleBlockPocketManager::new, ToggleBlockPocketManager::handle);
        RegistrationHandler.serverPacket(registrar, ToggleModule.ID, ToggleModule::new, ToggleModule::handle);
        RegistrationHandler.serverPacket(registrar, ToggleNightVision.ID, ToggleNightVision::new, ToggleNightVision::handle);
        RegistrationHandler.serverPacket(registrar, ToggleOption.ID, ToggleOption::new, ToggleOption::handle);
        RegistrationHandler.serverPacket(registrar, UpdateSliderValue.ID, UpdateSliderValue::new, UpdateSliderValue::handle);
    }

    private static final <T extends CustomPacketPayload> void clientPacket(IPayloadRegistrar registrar, ResourceLocation id, FriendlyByteBuf.Reader<T> reader, BiConsumer<T, PlayPayloadContext> handler) {
        registrar.play(id, reader, play -> play.client((packet, ctx) -> ctx.workHandler().submitAsync(() -> handler.accept(packet, ctx))));
    }

    private static final <T extends CustomPacketPayload> void serverPacket(IPayloadRegistrar registrar, ResourceLocation id, FriendlyByteBuf.Reader<T> reader, BiConsumer<T, PlayPayloadContext> handler) {
        registrar.play(id, reader, play -> play.server((packet, ctx) -> ctx.workHandler().submitAsync(() -> handler.accept(packet, ctx))));
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)SCContent.KEYPAD_BLAST_FURNACE_BLOCK_ENTITY.get(), AbstractKeypadFurnaceBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)SCContent.KEYPAD_FURNACE_BLOCK_ENTITY.get(), AbstractKeypadFurnaceBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)SCContent.KEYPAD_SMOKER_BLOCK_ENTITY.get(), AbstractKeypadFurnaceBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)SCContent.BLOCK_POCKET_MANAGER_BLOCK_ENTITY.get(), BlockPocketManagerBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)SCContent.CLAYMORE_BLOCK_ENTITY.get(), ClaymoreBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)SCContent.INVENTORY_SCANNER_BLOCK_ENTITY.get(), InventoryScannerBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)SCContent.KEYPAD_BARREL_BLOCK_ENTITY.get(), KeypadBarrelBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)SCContent.KEYPAD_CHEST_BLOCK_ENTITY.get(), (chest, dir) -> KeypadChestBlockEntity.getCapability((KeypadChestBlockEntity)chest, dir));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)SCContent.LASER_BLOCK_BLOCK_ENTITY.get(), LaserBlockBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)SCContent.REINFORCED_HOPPER_BLOCK_ENTITY.get(), ReinforcedHopperBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)SCContent.TROPHY_SYSTEM_BLOCK_ENTITY.get(), TrophySystemBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)SCContent.REINFORCED_CHISELED_BOOKSHELF_BLOCK_ENTITY.get(), ReinforcedChiseledBookshelfBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)SCContent.REINFORCED_DISPENSER_BLOCK_ENTITY.get(), ReinforcedDispenserBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)SCContent.REINFORCED_DROPPER_BLOCK_ENTITY.get(), ReinforcedDispenserBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)SCContent.SECURITY_CAMERA_BLOCK_ENTITY.get(), SecurityCameraBlockEntity::getCapability);
        event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)SCContent.SECURITY_SEA_BOAT_ENTITY.get(), (boat, ctx) -> SecuritySeaBoat.getCapability(boat, null));
        event.registerEntity(Capabilities.ItemHandler.ENTITY_AUTOMATION, (EntityType)SCContent.SECURITY_SEA_BOAT_ENTITY.get(), SecuritySeaBoat::getCapability);
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, ctx) -> new FluidBucketWrapper(stack), new ItemLike[]{SCContent.FAKE_WATER_BUCKET});
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, ctx) -> new FluidBucketWrapper(stack), new ItemLike[]{SCContent.FAKE_LAVA_BUCKET});
    }

    @SubscribeEvent
    public static void onCreativeModeTabRegister(BuildCreativeModeTabContentsEvent event) {
        MutableHashedLinkedMap entries = event.getEntries();
        ResourceKey tabKey = event.getTabKey();
        if (tabKey.equals(CreativeModeTabs.REDSTONE_BLOCKS)) {
            entries.putAfter((Object)new ItemStack((ItemLike)Items.LEVER), (Object)new ItemStack((ItemLike)SCContent.REINFORCED_LEVER.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.STONE_BUTTON), (Object)new ItemStack((ItemLike)SCContent.REINFORCED_OAK_BUTTON.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.REINFORCED_OAK_BUTTON.get()), (Object)new ItemStack((ItemLike)SCContent.REINFORCED_STONE_BUTTON.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.REINFORCED_STONE_BUTTON.get()), (Object)new ItemStack((ItemLike)SCContent.PANIC_BUTTON.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.STONE_PRESSURE_PLATE), (Object)new ItemStack((ItemLike)SCContent.REINFORCED_OAK_PRESSURE_PLATE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.REINFORCED_OAK_PRESSURE_PLATE.get()), (Object)new ItemStack((ItemLike)SCContent.REINFORCED_STONE_PRESSURE_PLATE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.STICKY_PISTON), (Object)new ItemStack((ItemLike)SCContent.REINFORCED_PISTON.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.REINFORCED_PISTON.get()), (Object)new ItemStack((ItemLike)SCContent.REINFORCED_STICKY_PISTON.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.DROPPER), (Object)new ItemStack((ItemLike)SCContent.REINFORCED_DISPENSER.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.REINFORCED_DISPENSER.get()), (Object)new ItemStack((ItemLike)SCContent.REINFORCED_DROPPER.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.HOPPER), (Object)new ItemStack((ItemLike)SCContent.REINFORCED_HOPPER.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.LECTERN), (Object)new ItemStack((ItemLike)SCContent.REINFORCED_LECTERN.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        } else if (tabKey.equals(CreativeModeTabs.COLORED_BLOCKS)) {
            event.acceptAll(List.of(new ItemStack((ItemLike)SCContent.REINFORCED_WHITE_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_GRAY_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GRAY_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLACK_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BROWN_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_RED_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_ORANGE_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_YELLOW_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIME_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GREEN_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CYAN_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_BLUE_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLUE_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PURPLE_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_MAGENTA_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PINK_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_WHITE_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_GRAY_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GRAY_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLACK_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BROWN_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_RED_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_ORANGE_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_YELLOW_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIME_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GREEN_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CYAN_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_BLUE_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLUE_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PURPLE_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_MAGENTA_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PINK_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_WHITE_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_GRAY_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GRAY_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLACK_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BROWN_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_RED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_ORANGE_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_YELLOW_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIME_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GREEN_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CYAN_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_BLUE_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLUE_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PURPLE_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_MAGENTA_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PINK_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_WHITE_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_GRAY_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GRAY_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLACK_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BROWN_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_RED_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_ORANGE_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_YELLOW_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIME_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GREEN_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CYAN_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_BLUE_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLUE_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PURPLE_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_MAGENTA_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PINK_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_WHITE_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_GRAY_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GRAY_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLACK_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BROWN_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_RED_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_ORANGE_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_YELLOW_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIME_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GREEN_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CYAN_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_BLUE_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLUE_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PURPLE_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_MAGENTA_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PINK_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_TINTED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_WHITE_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_GRAY_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GRAY_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLACK_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BROWN_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_RED_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_ORANGE_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_YELLOW_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIME_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GREEN_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CYAN_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_BLUE_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLUE_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PURPLE_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_MAGENTA_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PINK_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_WHITE_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_GRAY_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GRAY_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLACK_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BROWN_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_RED_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_ORANGE_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_YELLOW_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIME_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GREEN_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CYAN_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_BLUE_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLUE_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PURPLE_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_MAGENTA_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PINK_STAINED_GLASS_PANE.get())));
        } else if (tabKey.equals(SCCreativeModeTabs.DECORATION_TAB.getKey())) {
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.REINFORCED_LADDER.get()), (Object)new ItemStack((ItemLike)SCContent.REINFORCED_SCAFFOLDING_ITEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.REINFORCED_LECTERN.get()), (Object)new ItemStack((ItemLike)SCContent.SECRET_OAK_SIGN_ITEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.SECRET_OAK_SIGN_ITEM.get()), (Object)new ItemStack((ItemLike)SCContent.SECRET_OAK_HANGING_SIGN_ITEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.SECRET_OAK_HANGING_SIGN_ITEM.get()), (Object)new ItemStack((ItemLike)SCContent.SECRET_SPRUCE_SIGN_ITEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.SECRET_SPRUCE_SIGN_ITEM.get()), (Object)new ItemStack((ItemLike)SCContent.SECRET_SPRUCE_HANGING_SIGN_ITEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.SECRET_SPRUCE_HANGING_SIGN_ITEM.get()), (Object)new ItemStack((ItemLike)SCContent.SECRET_BIRCH_SIGN_ITEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.SECRET_BIRCH_SIGN_ITEM.get()), (Object)new ItemStack((ItemLike)SCContent.SECRET_BIRCH_HANGING_SIGN_ITEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.SECRET_BIRCH_HANGING_SIGN_ITEM.get()), (Object)new ItemStack((ItemLike)SCContent.SECRET_JUNGLE_SIGN_ITEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.SECRET_JUNGLE_SIGN_ITEM.get()), (Object)new ItemStack((ItemLike)SCContent.SECRET_JUNGLE_HANGING_SIGN_ITEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.SECRET_JUNGLE_HANGING_SIGN_ITEM.get()), (Object)new ItemStack((ItemLike)SCContent.SECRET_ACACIA_SIGN_ITEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.SECRET_ACACIA_SIGN_ITEM.get()), (Object)new ItemStack((ItemLike)SCContent.SECRET_ACACIA_HANGING_SIGN_ITEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.SECRET_ACACIA_HANGING_SIGN_ITEM.get()), (Object)new ItemStack((ItemLike)SCContent.SECRET_DARK_OAK_SIGN_ITEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.SECRET_DARK_OAK_SIGN_ITEM.get()), (Object)new ItemStack((ItemLike)SCContent.SECRET_DARK_OAK_HANGING_SIGN_ITEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.SECRET_DARK_OAK_HANGING_SIGN_ITEM.get()), (Object)new ItemStack((ItemLike)SCContent.SECRET_MANGROVE_SIGN_ITEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.SECRET_MANGROVE_SIGN_ITEM.get()), (Object)new ItemStack((ItemLike)SCContent.SECRET_MANGROVE_HANGING_SIGN_ITEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.SECRET_MANGROVE_HANGING_SIGN_ITEM.get()), (Object)new ItemStack((ItemLike)SCContent.SECRET_CHERRY_SIGN_ITEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.SECRET_CHERRY_SIGN_ITEM.get()), (Object)new ItemStack((ItemLike)SCContent.SECRET_CHERRY_HANGING_SIGN_ITEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.SECRET_CHERRY_HANGING_SIGN_ITEM.get()), (Object)new ItemStack((ItemLike)SCContent.SECRET_BAMBOO_SIGN_ITEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.SECRET_BAMBOO_SIGN_ITEM.get()), (Object)new ItemStack((ItemLike)SCContent.SECRET_BAMBOO_HANGING_SIGN_ITEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.SECRET_BAMBOO_HANGING_SIGN_ITEM.get()), (Object)new ItemStack((ItemLike)SCContent.SECRET_CRIMSON_SIGN_ITEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.SECRET_CRIMSON_SIGN_ITEM.get()), (Object)new ItemStack((ItemLike)SCContent.SECRET_CRIMSON_HANGING_SIGN_ITEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.SECRET_CRIMSON_HANGING_SIGN_ITEM.get()), (Object)new ItemStack((ItemLike)SCContent.SECRET_WARPED_SIGN_ITEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SCContent.SECRET_WARPED_SIGN_ITEM.get()), (Object)new ItemStack((ItemLike)SCContent.SECRET_WARPED_HANGING_SIGN_ITEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        } else if (tabKey.equals(CreativeModeTabs.OP_BLOCKS)) {
            if (event.getParameters().hasPermissions()) {
                entries.put((Object)new ItemStack((ItemLike)SCContent.ADMIN_TOOL.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                entries.put((Object)new ItemStack((ItemLike)SCContent.CODEBREAKER.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        } else if (tabKey.equals(CreativeModeTabs.TOOLS_AND_UTILITIES)) {
            entries.putAfter((Object)new ItemStack((ItemLike)Items.OAK_CHEST_BOAT), (Object)new ItemStack((ItemLike)SCContent.OAK_SECURITY_SEA_BOAT.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.SPRUCE_CHEST_BOAT), (Object)new ItemStack((ItemLike)SCContent.SPRUCE_SECURITY_SEA_BOAT.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.BIRCH_CHEST_BOAT), (Object)new ItemStack((ItemLike)SCContent.BIRCH_SECURITY_SEA_BOAT.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.JUNGLE_CHEST_BOAT), (Object)new ItemStack((ItemLike)SCContent.JUNGLE_SECURITY_SEA_BOAT.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.ACACIA_CHEST_BOAT), (Object)new ItemStack((ItemLike)SCContent.ACACIA_SECURITY_SEA_BOAT.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.DARK_OAK_CHEST_BOAT), (Object)new ItemStack((ItemLike)SCContent.DARK_OAK_SECURITY_SEA_BOAT.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.MANGROVE_CHEST_BOAT), (Object)new ItemStack((ItemLike)SCContent.MANGROVE_SECURITY_SEA_BOAT.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.CHERRY_CHEST_BOAT), (Object)new ItemStack((ItemLike)SCContent.CHERRY_SECURITY_SEA_BOAT.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.BAMBOO_CHEST_RAFT), (Object)new ItemStack((ItemLike)SCContent.BAMBOO_SECURITY_SEA_RAFT.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    public static void registerFakeLiquidRecipes() {
        BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.WATER_BUCKET}), (Ingredient)RegistrationHandler.getPotionIngredient(Potions.HARMING, Potions.STRONG_HARMING), (ItemStack)new ItemStack((ItemLike)SCContent.FAKE_WATER_BUCKET.get()));
        BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.LAVA_BUCKET}), (Ingredient)RegistrationHandler.getPotionIngredient(Potions.HEALING, Potions.STRONG_HEALING), (ItemStack)new ItemStack((ItemLike)SCContent.FAKE_LAVA_BUCKET.get()));
    }

    private static Ingredient getPotionIngredient(Potion normalPotion, Potion strongPotion) {
        CompoundTag normalNBT = new CompoundTag();
        CompoundTag strongNBT = new CompoundTag();
        normalNBT.putString("Potion", Utils.getRegistryName(normalPotion).toString());
        strongNBT.putString("Potion", Utils.getRegistryName(strongPotion).toString());
        NBTIngredient normalPotions = NBTIngredient.of((boolean)false, (CompoundTag)normalNBT, (ItemLike[])new ItemLike[]{Items.POTION, Items.SPLASH_POTION, Items.LINGERING_POTION});
        NBTIngredient strongPotions = NBTIngredient.of((boolean)false, (CompoundTag)strongNBT, (ItemLike[])new ItemLike[]{Items.POTION, Items.SPLASH_POTION, Items.LINGERING_POTION});
        return CompoundIngredient.of((Ingredient[])new Ingredient[]{normalPotions, strongPotions});
    }
}

