/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.items.CodebreakerItem;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface ICodebreakable {
    public boolean shouldAttemptCodebreak(Player var1);

    public void useCodebreaker(Player var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean handleCodebreaking(Player player, InteractionHand hand) {
        double chance = (Double)ConfigHandler.SERVER.codebreakerChance.get();
        if (chance < 0.0) {
            PlayerUtils.sendMessageToPlayer(player, Utils.localize(((CodebreakerItem)((Object)SCContent.CODEBREAKER.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:codebreakerDisabled", new Object[0]), ChatFormatting.RED);
            return true;
        } else {
            IOwnable ownable;
            if (!this.shouldAttemptCodebreak(player)) {
                return false;
            }
            ItemStack codebreaker = player.getItemInHand(hand);
            if (!codebreaker.is((Item)SCContent.CODEBREAKER.get())) return false;
            boolean canBypass = player.isCreative() || player.isSpectator();
            ICodebreakable iCodebreakable = this;
            if (iCodebreakable instanceof IOwnable && (ownable = (IOwnable)((Object)iCodebreakable)).isOwnedBy((Entity)player) && !canBypass) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((CodebreakerItem)((Object)SCContent.CODEBREAKER.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:codebreaker.owned", new Object[0]), ChatFormatting.RED);
                return false;
            }
            if (!canBypass && CodebreakerItem.wasRecentlyUsed(codebreaker)) {
                return false;
            }
            boolean isSuccessful = canBypass || SecurityCraft.RANDOM.nextDouble() < chance;
            CompoundTag tag = codebreaker.getOrCreateTag();
            if (!canBypass) {
                codebreaker.hurtAndBreak(1, (LivingEntity)player, p -> p.broadcastBreakEvent(hand));
            }
            tag.putLong("last_used_time", System.currentTimeMillis());
            tag.putBoolean("was_successful", isSuccessful);
            if (isSuccessful) {
                this.useCodebreaker(player);
                return true;
            } else {
                PlayerUtils.sendMessageToPlayer(player, Component.translatable((String)((CodebreakerItem)((Object)SCContent.CODEBREAKER.get())).getDescriptionId()), Utils.localize("messages.securitycraft:codebreaker.failed", new Object[0]), ChatFormatting.RED);
                return false;
            }
        }
    }
}

