/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.Optional;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public interface IDisguisable {
    default public ItemStack getDisguisedStack(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity;
        if (level != null && (blockEntity = level.getBlockEntity(pos)) instanceof IModuleInventory) {
            Block block;
            ItemStack stack;
            IModuleInventory be = (IModuleInventory)blockEntity;
            ItemStack itemStack = stack = be.isModuleEnabled(ModuleType.DISGUISE) ? be.getModule(ModuleType.DISGUISE) : ItemStack.EMPTY;
            if (!stack.isEmpty() && (block = ModuleItem.getBlockAddon(stack)) != null) {
                return new ItemStack((ItemLike)block);
            }
        }
        return this.getDefaultStack();
    }

    default public ItemStack getDefaultStack() {
        return new ItemStack((ItemLike)((Block)this));
    }

    public static boolean shouldPickBlockDisguise(BlockGetter level, BlockPos pos, Player player) {
        IOwnable ownable;
        BlockEntity blockEntity;
        return !player.isCreative() && (level == null || !((blockEntity = level.getBlockEntity(pos)) instanceof IOwnable) || !(ownable = (IOwnable)blockEntity).isOwnedBy((Entity)player));
    }

    public static BlockState getDisguisedStateOrDefault(BlockState state, BlockGetter level, BlockPos pos) {
        return IDisguisable.getDisguisedStateOrDefault(level.getBlockEntity(pos), state, level, pos);
    }

    public static BlockState getDisguisedStateOrDefault(BlockEntity be, BlockState state, BlockGetter level, BlockPos pos) {
        if (level instanceof LevelReader) {
            LevelReader reader = (LevelReader)level;
            return IDisguisable.getDisguisedBlockState(be, reader).orElse(state);
        }
        return state;
    }

    public static Optional<BlockState> getDisguisedBlockState(BlockEntity be) {
        return be.hasLevel() ? IDisguisable.getDisguisedBlockState(be, (LevelReader)be.getLevel()) : Optional.empty();
    }

    public static Optional<BlockState> getDisguisedBlockState(BlockEntity be, LevelReader level) {
        IModuleInventory moduleInv;
        if (be instanceof IModuleInventory && (moduleInv = (IModuleInventory)be).isModuleEnabled(ModuleType.DISGUISE)) {
            return IDisguisable.getDisguisedBlockStateFromStack((HolderGetter<Block>)level.holderLookup(Registries.BLOCK), moduleInv.getModule(ModuleType.DISGUISE));
        }
        return Optional.empty();
    }

    public static Optional<BlockState> getDisguisedBlockStateFromStack(Level level, ItemStack module) {
        return IDisguisable.getDisguisedBlockStateFromStack((HolderGetter<Block>)level.holderLookup(Registries.BLOCK), module);
    }

    public static Optional<BlockState> getDisguisedBlockStateFromStack(HolderGetter<Block> holderGetter, ItemStack module) {
        if (!module.isEmpty()) {
            BlockState disguisedState = NbtUtils.readBlockState(holderGetter, (CompoundTag)module.getOrCreateTag().getCompound("SavedState"));
            if (disguisedState != null && disguisedState.getBlock() != Blocks.AIR) {
                return Optional.of(disguisedState);
            }
            Block block = ModuleItem.getBlockAddon(module);
            if (block != null) {
                return Optional.of(block.defaultBlockState());
            }
        }
        return Optional.empty();
    }
}

