/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public interface IModuleInventory
extends IItemHandlerModifiable {
    public NonNullList<ItemStack> getInventory();

    public ModuleType[] acceptedModules();

    public boolean isModuleEnabled(ModuleType var1);

    public void toggleModuleState(ModuleType var1, boolean var2);

    public Level myLevel();

    public BlockPos myPos();

    default public int getMaxNumberOfModules() {
        return this.acceptedModules().length;
    }

    default public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        this.toggleModuleState(module, true);
        IModuleInventory iModuleInventory = this;
        if (iModuleInventory instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)iModuleInventory;
            if (!be.getLevel().isClientSide) {
                be.setChanged();
                be.getLevel().sendBlockUpdated(be.getBlockPos(), be.getBlockState(), be.getBlockState(), 3);
            }
        }
    }

    default public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        this.toggleModuleState(module, false);
        IModuleInventory iModuleInventory = this;
        if (iModuleInventory instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)iModuleInventory;
            if (!be.getLevel().isClientSide) {
                be.setChanged();
                be.getLevel().sendBlockUpdated(be.getBlockPos(), be.getBlockState(), be.getBlockState(), 3);
            }
        }
    }

    default public boolean enableHack() {
        return false;
    }

    default public int fixSlotId(int id) {
        return id >= 100 ? id - 100 : id;
    }

    default public void dropAllModules() {
        for (ItemStack module : this.getInventory()) {
            if (!(module.getItem() instanceof ModuleItem)) continue;
            IModuleInventory iModuleInventory = this;
            if (iModuleInventory instanceof LinkableBlockEntity) {
                LinkableBlockEntity be = (LinkableBlockEntity)iModuleInventory;
                be.propagate((ILinkedAction)new ILinkedAction.ModuleRemoved(((ModuleItem)module.getItem()).getModuleType(), false), be);
            }
            Block.popResource((Level)this.myLevel(), (BlockPos)this.myPos(), (ItemStack)module);
        }
        this.getInventory().clear();
    }

    default public int getSlots() {
        return this.acceptedModules().length;
    }

    default public ItemStack getStackInSlot(int slot) {
        return this.getModuleInSlot(slot);
    }

    default public ItemStack getModuleInSlot(int slot) {
        return (slot = this.fixSlotId(slot)) < 0 || slot >= this.getSlots() ? ItemStack.EMPTY : (ItemStack)this.getInventory().get(slot);
    }

    default public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack = this.getModuleInSlot(slot = this.fixSlotId(slot)).copy();
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!simulate) {
            this.getInventory().set(slot, (Object)ItemStack.EMPTY);
            Item item = stack.getItem();
            if (item instanceof ModuleItem) {
                ModuleItem module = (ModuleItem)item;
                this.onModuleRemoved(stack, module.getModuleType(), false);
                IModuleInventory iModuleInventory = this;
                if (iModuleInventory instanceof LinkableBlockEntity) {
                    LinkableBlockEntity be = (LinkableBlockEntity)iModuleInventory;
                    be.propagate((ILinkedAction)new ILinkedAction.ModuleRemoved(((ModuleItem)stack.getItem()).getModuleType(), false), be);
                }
            }
            return stack;
        }
        return stack.copy();
    }

    default public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.getModuleInSlot(slot = this.fixSlotId(slot)).isEmpty()) {
            return stack;
        }
        int returnSize = 0;
        if (stack.getCount() > 1) {
            returnSize = stack.getCount() - 1;
        }
        if (!simulate) {
            ItemStack copy = stack.copy();
            copy.setCount(1);
            this.getInventory().set(slot, (Object)copy);
            Item item = stack.getItem();
            if (item instanceof ModuleItem) {
                ModuleItem module = (ModuleItem)item;
                this.onModuleInserted(stack, module.getModuleType(), false);
                IModuleInventory iModuleInventory = this;
                if (iModuleInventory instanceof LinkableBlockEntity) {
                    LinkableBlockEntity be = (LinkableBlockEntity)iModuleInventory;
                    be.propagate((ILinkedAction)new ILinkedAction.ModuleInserted(copy, (ModuleItem)copy.getItem(), false), be);
                }
            }
        }
        if (returnSize != 0) {
            ItemStack toReturn = stack.copy();
            toReturn.setCount(returnSize);
            return toReturn;
        }
        return ItemStack.EMPTY;
    }

    default public void setStackInSlot(int slot, ItemStack stack) {
        Object object;
        ItemStack previous = this.getModuleInSlot(slot = this.fixSlotId(slot));
        if (ItemStack.matches((ItemStack)previous, (ItemStack)stack)) {
            return;
        }
        if (!previous.isEmpty()) {
            this.onModuleRemoved(previous, ((ModuleItem)previous.getItem()).getModuleType(), false);
            object = this;
            if (object instanceof LinkableBlockEntity) {
                LinkableBlockEntity be = (LinkableBlockEntity)object;
                be.propagate((ILinkedAction)new ILinkedAction.ModuleRemoved(((ModuleItem)previous.getItem()).getModuleType(), false), be);
            }
        }
        this.getInventory().set(slot, (Object)stack);
        object = stack.getItem();
        if (object instanceof ModuleItem) {
            ModuleItem module = (ModuleItem)((Object)object);
            this.onModuleInserted(stack, module.getModuleType(), false);
            IModuleInventory iModuleInventory = this;
            if (iModuleInventory instanceof LinkableBlockEntity) {
                LinkableBlockEntity be = (LinkableBlockEntity)iModuleInventory;
                be.propagate((ILinkedAction)new ILinkedAction.ModuleInserted(stack, (ModuleItem)stack.getItem(), false), be);
            }
        }
    }

    default public int getSlotLimit(int slot) {
        return 1;
    }

    default public boolean isItemValid(int slot, ItemStack stack) {
        ModuleItem module;
        Item item;
        return this.getModuleInSlot(slot = this.fixSlotId(slot)).isEmpty() && !stack.isEmpty() && (item = stack.getItem()) instanceof ModuleItem && this.acceptsModule((module = (ModuleItem)item).getModuleType()) && !this.hasModule(module.getModuleType());
    }

    default public boolean acceptsModule(ModuleType type) {
        for (ModuleType module : this.acceptedModules()) {
            if (module != type) continue;
            return true;
        }
        return false;
    }

    default public List<ModuleType> getInsertedModules() {
        ArrayList<ModuleType> modules = new ArrayList<ModuleType>();
        for (ItemStack stack : this.getInventory()) {
            Item item;
            if (stack.isEmpty() || !((item = stack.getItem()) instanceof ModuleItem)) continue;
            ModuleItem module = (ModuleItem)item;
            modules.add(module.getModuleType());
        }
        return modules;
    }

    default public ItemStack getModule(ModuleType module) {
        NonNullList<ItemStack> modules = this.getInventory();
        for (int i = 0; i < modules.size(); ++i) {
            ModuleItem moduleItem;
            Item item;
            if (((ItemStack)modules.get(i)).isEmpty() || !((item = ((ItemStack)modules.get(i)).getItem()) instanceof ModuleItem) || (moduleItem = (ModuleItem)item).getModuleType() != module) continue;
            return (ItemStack)modules.get(i);
        }
        return ItemStack.EMPTY;
    }

    default public void insertModule(ItemStack module, boolean toggled) {
        Item item;
        if (module.isEmpty() || !((item = module.getItem()) instanceof ModuleItem)) {
            return;
        }
        ModuleItem moduleItem = (ModuleItem)item;
        NonNullList<ItemStack> modules = this.getInventory();
        if (!toggled) {
            for (int i = 0; i < modules.size(); ++i) {
                if (((ItemStack)modules.get(i)).isEmpty() || ((ItemStack)modules.get(i)).getItem() != moduleItem) continue;
                return;
            }
        }
        Predicate<ItemStack> predicate = toggled ? stack -> stack.getItem() == moduleItem : ItemStack::isEmpty;
        for (int i = 0; i < modules.size(); ++i) {
            if (!predicate.test((ItemStack)modules.get(i))) continue;
            ItemStack toInsert = module.copy();
            if (!toggled) {
                modules.set(i, (Object)toInsert);
            }
            this.onModuleInserted(toInsert, moduleItem.getModuleType(), toggled);
            break;
        }
    }

    default public void removeModule(ModuleType module, boolean toggled) {
        NonNullList<ItemStack> modules = this.getInventory();
        for (int i = 0; i < modules.size(); ++i) {
            ModuleItem moduleItem;
            Item item;
            ItemStack moduleStack = (ItemStack)modules.get(i);
            if (moduleStack.isEmpty() || !((item = moduleStack.getItem()) instanceof ModuleItem) || (moduleItem = (ModuleItem)item).getModuleType() != module) continue;
            if (!toggled) {
                modules.set(i, (Object)ItemStack.EMPTY);
            }
            this.onModuleRemoved(moduleStack, module, toggled);
        }
    }

    @Deprecated
    default public boolean hasModule(ModuleType module) {
        NonNullList<ItemStack> modules = this.getInventory();
        if (module == null) {
            for (int i = 0; i < modules.size(); ++i) {
                if (!((ItemStack)modules.get(i)).isEmpty()) continue;
                return true;
            }
        } else {
            for (int i = 0; i < modules.size(); ++i) {
                ModuleItem moduleItem;
                Item item;
                if (((ItemStack)modules.get(i)).isEmpty() || !((item = ((ItemStack)modules.get(i)).getItem()) instanceof ModuleItem) || (moduleItem = (ModuleItem)item).getModuleType() != module) continue;
                return true;
            }
        }
        return false;
    }

    default public NonNullList<ItemStack> readModuleInventory(CompoundTag tag) {
        ListTag list = tag.getList("Modules", 10);
        NonNullList modules = NonNullList.withSize((int)this.getMaxNumberOfModules(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag stackTag = list.getCompound(i);
            byte slot = stackTag.getByte("ModuleSlot");
            if (slot < 0 || slot >= modules.size()) continue;
            modules.set((int)slot, (Object)ItemStack.of((CompoundTag)stackTag));
        }
        return modules;
    }

    default public Map<ModuleType, Boolean> readModuleStates(CompoundTag tag) {
        EnumMap<ModuleType, Boolean> moduleStates = new EnumMap<ModuleType, Boolean>(ModuleType.class);
        List<ModuleType> acceptedModules = Arrays.asList(this.acceptedModules());
        for (ModuleType module : ModuleType.values()) {
            if (acceptedModules.contains((Object)module)) {
                String key = module.name().toLowerCase() + "Enabled";
                if (tag.contains(key)) {
                    moduleStates.put(module, tag.getBoolean(key));
                    continue;
                }
                moduleStates.put(module, this.hasModule(module));
                continue;
            }
            moduleStates.put(module, false);
        }
        return moduleStates;
    }

    default public CompoundTag writeModuleInventory(CompoundTag tag) {
        ListTag list = new ListTag();
        NonNullList<ItemStack> modules = this.getInventory();
        for (int i = 0; i < modules.size(); ++i) {
            if (((ItemStack)modules.get(i)).isEmpty()) continue;
            CompoundTag stackTag = new CompoundTag();
            stackTag.putByte("ModuleSlot", (byte)i);
            ((ItemStack)modules.get(i)).save(stackTag);
            list.add((Object)stackTag);
        }
        tag.put("Modules", (Tag)list);
        return tag;
    }

    default public CompoundTag writeModuleStates(CompoundTag tag) {
        for (ModuleType module : this.acceptedModules()) {
            tag.putBoolean(module.name().toLowerCase() + "Enabled", this.isModuleEnabled(module));
        }
        return tag;
    }

    /*
     * Enabled aggressive block sorting
     */
    default public boolean isAllowed(Entity entity) {
        String name;
        IModuleInventory iModuleInventory = this;
        if (iModuleInventory instanceof IOwnable) {
            Player player;
            IOwnable ownable = (IOwnable)((Object)iModuleInventory);
            if (entity instanceof Player && ownable.isOwnedBy(player = (Player)entity, true)) {
                name = PlayerUtils.getNameFromPlayerOrMask(player);
                return this.isAllowed(name);
            }
        }
        name = entity.getName().getString();
        return this.isAllowed(name);
    }

    default public boolean isAllowed(String name) {
        if (!this.isModuleEnabled(ModuleType.ALLOWLIST)) {
            return false;
        }
        ItemStack stack = this.getModule(ModuleType.ALLOWLIST);
        if (stack.hasTag() && stack.getTag().getBoolean("affectEveryone")) {
            return true;
        }
        return ModuleItem.doesModuleHaveTeamOf(stack, name, this.myLevel()) || ModuleItem.getPlayersFromModule(stack).contains(name.toLowerCase());
    }

    /*
     * Unable to fully structure code
     */
    default public boolean isDenied(Entity entity) {
        if (!this.isModuleEnabled(ModuleType.DENYLIST)) {
            return false;
        }
        stack = this.getModule(ModuleType.DENYLIST);
        if (stack.hasTag() && stack.getTag().getBoolean("affectEveryone") && (var5_3 = this) instanceof IOwnable) {
            ownable = (IOwnable)var5_3;
            if (entity instanceof Player) {
                player = (Player)entity;
                if (!ownable.isOwnedBy((Entity)player)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        if (!((var6_5 = this) instanceof IOwnable)) ** GOTO lbl-1000
        ownable = (IOwnable)var6_5;
        if (entity instanceof Player && ownable.isOwnedBy(player = (Player)entity, true)) {
            name = PlayerUtils.getNameFromPlayerOrMask(player);
        } else lbl-1000:
        // 2 sources

        {
            name = entity.getName().getString();
        }
        return ModuleItem.doesModuleHaveTeamOf(stack, name, this.myLevel()) != false || ModuleItem.getPlayersFromModule(stack).contains(name.toLowerCase()) != false;
    }

    default public boolean shouldDropModules() {
        return true;
    }

    default public String getModuleDescriptionId(String denotation, ModuleType module) {
        if (module == ModuleType.DISGUISE) {
            return "module.generic.disguise_module.description";
        }
        return IModuleInventory.getBaseModuleDescriptionId(denotation, module);
    }

    public static String getBaseModuleDescriptionId(String denotation, ModuleType module) {
        return "module." + denotation + "." + module.getTranslationKey().substring(5).replace("securitycraft.", "") + ".description";
    }
}

