/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.INameSetter;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class NamedBlockEntity
extends OwnableBlockEntity
implements INameSetter {
    private Component customName;

    public NamedBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)SCContent.ABSTRACT_BLOCK_ENTITY.get(), pos, state);
    }

    public NamedBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        if (this.customName != null) {
            tag.putString("customName", this.customName.getString());
        }
    }

    @Override
    public void load(CompoundTag tag) {
        String name;
        super.load(tag);
        if (tag.contains("customName") && !(name = tag.getString("customName")).isEmpty() && !name.equals("name")) {
            this.customName = Component.literal((String)name);
        }
    }

    public Component getName() {
        return this.hasCustomName() ? this.getCustomName() : this.getDefaultName();
    }

    public boolean hasCustomName() {
        Component name = this.getCustomName();
        return name != null && !Component.empty().equals((Object)name) && !this.getDefaultName().equals(name);
    }

    public Component getCustomName() {
        return this.customName;
    }

    @Override
    public void setCustomName(Component customName) {
        this.customName = customName;
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    public Component getDefaultName() {
        return Utils.localize(this.getBlockState().getBlock().getDescriptionId(), new Object[0]);
    }
}

