/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.FrameBlock;
import net.geforcemods.securitycraft.entity.camera.FrameFeedHandler;
import net.geforcemods.securitycraft.items.CameraMonitorItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.SyncFrame;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;

public class FrameBlockEntity
extends CustomizableBlockEntity
implements ITickingBlockEntity {
    private final Option.DisabledOption disabled = new Option.DisabledOption(false);
    private final Option.IntOption chunkLoadingDistance = new Option.IntOption("chunkLoadingDistance", 16, 2, 32, 1);
    private List<Pair<GlobalPos, String>> cameraPositions = new ArrayList<Pair<GlobalPos, String>>();
    private GlobalPos currentCameraPosition;
    private GlobalPos newCameraPosition;
    private boolean activatedByRedstone = false;
    private boolean clientInteracted;
    private boolean switchCamera;

    public FrameBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.FRAME_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (this.activatedByRedstone) {
            boolean wasPowered = (Boolean)state.getValue((Property)FrameBlock.POWERED);
            if (level.isClientSide && !wasPowered && this.clientInteracted) {
                this.switchCameraOnClient(this.currentCameraPosition, true);
            } else if (!level.isClientSide) {
                boolean hasNeighborSignal = level.hasNeighborSignal(pos);
                if (wasPowered && !hasNeighborSignal) {
                    this.disableCameraFeedOnServer(this.currentCameraPosition);
                }
                if (wasPowered != hasNeighborSignal) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)FrameBlock.POWERED, (Comparable)Boolean.valueOf(hasNeighborSignal)));
                }
            }
        }
        if (this.switchCamera) {
            this.switchCamera = false;
            if (!level.isClientSide) {
                this.disableCameraFeedOnServer(this.newCameraPosition);
            } else {
                this.switchCameraOnClient(this.newCameraPosition, true);
            }
        }
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.currentCameraPosition != null) {
            if (!this.level.isClientSide) {
                if (this.level.isLoaded(this.worldPosition)) {
                    this.disableCameraFeedOnServer(this.currentCameraPosition);
                }
            } else if (this.clientInteracted) {
                this.switchCameraOnClient(this.currentCameraPosition, true);
                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new SyncFrame(this.getBlockPos(), FrameFeedHandler.getFrameFeedViewDistance(this), Optional.empty(), Optional.ofNullable(this.currentCameraPosition), true)});
            }
        }
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        if (tag.contains("cameras")) {
            ListTag cameras = tag.getList("cameras", 10);
            this.cameraPositions.clear();
            for (int i = 0; i < cameras.size(); ++i) {
                Pair cameraEntry;
                CompoundTag cameraTag = cameras.getCompound(i);
                if (cameraTag.isEmpty()) {
                    cameraEntry = Pair.of(null, null);
                } else {
                    GlobalPos cameraPos = (GlobalPos)GlobalPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)cameraTag.get("global_pos")).getOrThrow(false, error -> {});
                    String name = cameraTag.contains("name") ? cameraTag.getString("name") : null;
                    cameraEntry = Pair.of((Object)cameraPos, (Object)name);
                }
                this.cameraPositions.add((Pair<GlobalPos, String>)cameraEntry);
            }
        }
        GlobalPos newCameraPos = tag.contains("current_camera") ? (GlobalPos)GlobalPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("current_camera")).getOrThrow(false, error -> {}) : null;
        if (this.currentCameraPosition == null && newCameraPos != null || this.currentCameraPosition != null && !this.currentCameraPosition.equals((Object)newCameraPos)) {
            this.switchCamera = true;
            this.newCameraPosition = newCameraPos;
        }
        this.activatedByRedstone = this.isModuleEnabled(ModuleType.REDSTONE);
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        ListTag camerasTag = new ListTag();
        for (Pair<GlobalPos, String> camera : this.cameraPositions) {
            CompoundTag cameraTag = new CompoundTag();
            if (camera != null) {
                GlobalPos pos = (GlobalPos)camera.getLeft();
                String name = (String)camera.getRight();
                if (pos != null) {
                    cameraTag.put("global_pos", (Tag)GlobalPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)pos).getOrThrow(false, error -> {}));
                }
                if (name != null && !name.isEmpty()) {
                    cameraTag.putString("name", (String)camera.getRight());
                }
            }
            camerasTag.add((Object)cameraTag);
        }
        tag.put("cameras", (Tag)camerasTag);
        if (this.currentCameraPosition != null) {
            tag.put("current_camera", (Tag)GlobalPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.currentCameraPosition).getOrThrow(false, error -> {}));
        }
    }

    public boolean applyCameraPositions(ItemStack cameraMonitor) {
        List<Pair<GlobalPos, String>> newCameraPositions = CameraMonitorItem.getCameraPositions(cameraMonitor.getOrCreateTag());
        if (!this.cameraPositions.equals(newCameraPositions)) {
            this.cameraPositions = new ArrayList<Pair<GlobalPos, String>>(newCameraPositions);
            this.setChanged();
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            return true;
        }
        return false;
    }

    public List<Pair<GlobalPos, String>> getCameraPositions() {
        return this.cameraPositions;
    }

    public void removeCameraOnClient(int camID) {
        GlobalPos cameraPos;
        Pair<GlobalPos, String> cameraEntry = this.cameraPositions.get(camID - 1);
        if (cameraEntry != null && (cameraPos = (GlobalPos)cameraEntry.getLeft()) != null) {
            this.removeCamera(cameraPos);
            if (cameraPos == this.currentCameraPosition) {
                FrameFeedHandler.removeFrameLink(this.currentCameraPosition, this);
                this.currentCameraPosition = null;
            }
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new SyncFrame(this.getBlockPos(), FrameFeedHandler.getFrameFeedViewDistance(this), Optional.of(cameraPos), Optional.ofNullable(this.currentCameraPosition), false)});
        }
    }

    public void removeCamera(GlobalPos cameraPos) {
        for (int i = 0; i < this.cameraPositions.size(); ++i) {
            Pair<GlobalPos, String> entry = this.cameraPositions.get(i);
            GlobalPos cameraListPos = (GlobalPos)entry.getLeft();
            if (cameraListPos == null || !cameraListPos.equals((Object)cameraPos)) continue;
            this.cameraPositions.set(i, null);
            break;
        }
        if (this.cameraPositions.stream().allMatch(pair -> pair == null || pair.getLeft() == null)) {
            this.cameraPositions = new ArrayList<Pair<GlobalPos, String>>();
        }
        this.setChanged();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public void setCameraOnClientAndUpdate(GlobalPos camera) {
        this.switchCameraOnClient(camera, false);
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new SyncFrame(this.getBlockPos(), FrameFeedHandler.getFrameFeedViewDistance(this), Optional.empty(), Optional.ofNullable(this.currentCameraPosition), false)});
    }

    public void disableCameraFeedOnServer(GlobalPos newCameraPos) {
        this.switchCameraOnServer(newCameraPos, null, 0, true);
    }

    public void unsetCurrentCameraOnServer() {
        this.switchCameraOnServer(null, null, 0, false);
    }

    public void switchCameraOnServer(GlobalPos newCameraPos, Player player, int requestedRenderDistance, boolean disableNewCamera) {
        if (!this.level.isClientSide) {
            BlockEntity blockEntity;
            GlobalPos previousCameraPos = this.getCurrentCamera();
            this.setCurrentCamera(newCameraPos);
            if (previousCameraPos != null && (blockEntity = this.level.getBlockEntity(previousCameraPos.pos())) instanceof SecurityCameraBlockEntity) {
                SecurityCameraBlockEntity previousCamera = (SecurityCameraBlockEntity)blockEntity;
                if (!previousCameraPos.equals((Object)newCameraPos) || player == null && disableNewCamera) {
                    previousCamera.unlinkFrameForAllPlayers(this.worldPosition);
                } else if (disableNewCamera) {
                    previousCamera.unlinkFrameForPlayer(player.getUUID(), this.worldPosition);
                }
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!disableNewCamera && newCameraPos != null) {
                    BlockEntity blockEntity2;
                    if (this.level.dimension() != newCameraPos.dimension() || !((blockEntity2 = this.level.getBlockEntity(newCameraPos.pos())) instanceof SecurityCameraBlockEntity)) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(((FrameBlock)((Object)SCContent.FRAME.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:cameraMonitor.cameraNotAvailable", newCameraPos.pos()), ChatFormatting.RED);
                    } else {
                        SecurityCameraBlockEntity newCamera = (SecurityCameraBlockEntity)blockEntity2;
                        if (!newCameraPos.equals((Object)previousCameraPos) || !newCamera.isFrameLinked(player, this.worldPosition)) {
                            if (this.redstoneSignalDisabled()) {
                                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((FrameBlock)((Object)SCContent.FRAME.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:frame.noRedstoneSignal", newCameraPos.pos()), ChatFormatting.RED);
                            } else {
                                newCamera.linkFrameForPlayer(serverPlayer, this.worldPosition, Mth.clamp((int)requestedRenderDistance, (int)2, (int)Math.min(this.getChunkLoadingDistanceOption(), Math.min((Integer)ConfigHandler.SERVER.frameFeedViewDistance.get(), serverPlayer.server.getPlayerList().getViewDistance()))));
                            }
                        }
                    }
                }
            }
            this.setChanged();
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void switchCameraOnClient(GlobalPos newCameraPos, boolean disableNewCamera) {
        if (this.level.isClientSide) {
            GlobalPos previousCameraPos = this.getCurrentCamera();
            this.setCurrentCamera(newCameraPos);
            if (previousCameraPos != null) {
                FrameFeedHandler.removeFrameLink(previousCameraPos, this);
            }
            if (newCameraPos != null && !disableNewCamera) {
                FrameFeedHandler.addFrameLink(this, newCameraPos);
                this.clientInteracted = true;
            } else if (disableNewCamera) {
                this.clientInteracted = false;
            }
        }
    }

    public boolean hasClientInteracted() {
        return this.clientInteracted;
    }

    public void setCurrentCamera(GlobalPos camera) {
        this.currentCameraPosition = camera;
        this.setChanged();
    }

    public GlobalPos getCurrentCamera() {
        return this.currentCameraPosition;
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public int getChunkLoadingDistanceOption() {
        return (Integer)this.chunkLoadingDistance.get();
    }

    public boolean redstoneSignalDisabled() {
        return this.activatedByRedstone && (Boolean)this.getBlockState().getValue((Property)FrameBlock.POWERED) == false;
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.disabled, this.chunkLoadingDistance};
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (!this.level.isClientSide && (option.getName().equals(this.disabled.getName()) && ((Boolean)this.disabled.get()).booleanValue() || option.getName().equals(this.chunkLoadingDistance.getName()))) {
            this.unsetCurrentCameraOnServer();
        }
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.REDSTONE) {
            this.activatedByRedstone = true;
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)FrameBlock.POWERED, (Comparable)Boolean.valueOf(true)));
            this.setChanged();
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.ALLOWLIST && !this.level.isClientSide) {
            this.unsetCurrentCameraOnServer();
        } else if (module == ModuleType.REDSTONE) {
            this.activatedByRedstone = false;
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)FrameBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            this.setChanged();
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.REDSTONE};
    }
}

