/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.mines.BouncingBettyBlock;
import net.geforcemods.securitycraft.blocks.mines.IMSBlock;
import net.geforcemods.securitycraft.entity.IMSBomb;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.TargetingMode;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class IMSBlockEntity
extends CustomizableBlockEntity
implements ITickingBlockEntity {
    private Option.IntOption range = new Option.IntOption("range", 15, 1, 30, 1);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private Option.TargetingModeOption targetingMode = new Option.TargetingModeOption(TargetingMode.PLAYERS_AND_MOBS);
    private Option.RespectInvisibilityOption respectInvisibility = new Option.RespectInvisibilityOption();
    private int bombsRemaining = 4;
    private boolean updateBombCount = false;
    private int attackTime = this.getAttackInterval();

    public IMSBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.IMS_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide && this.updateBombCount) {
            int mineCount = (Integer)state.getValue((Property)IMSBlock.MINES);
            if (mineCount != this.bombsRemaining) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)IMSBlock.MINES, (Comparable)Integer.valueOf(this.bombsRemaining)));
            }
            if (this.bombsRemaining < 4) {
                IItemHandler handler;
                BlockEntity be = level.getBlockEntity(pos.below());
                if (be != null && (handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, be.getBlockState(), be, (Object)Direction.UP)) != null) {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        if (handler.getStackInSlot(i).getItem() != ((BouncingBettyBlock)SCContent.BOUNCING_BETTY.get()).asItem()) continue;
                        handler.extractItem(i, 1, false);
                        ++this.bombsRemaining;
                        return;
                    }
                }
            } else {
                this.updateBombCount = false;
            }
        }
        if (!this.isDisabled() && this.attackTime-- == 0) {
            this.attackTime = this.getAttackInterval();
            this.launchMine(level, pos);
        }
    }

    private void launchMine(Level level, BlockPos pos) {
        if (this.bombsRemaining > 0) {
            AABB area = new AABB(pos).inflate((double)((Integer)this.range.get()).intValue());
            TargetingMode mode = this.getTargetingMode();
            level.getEntitiesOfClass(LivingEntity.class, area, e -> {
                if (!(e instanceof Player)) {
                    if (!(e instanceof Monster)) return false;
                }
                if (!mode.canAttackEntity((LivingEntity)e, this, this.respectInvisibility::isConsideredInvisible)) return false;
                return true;
            }).stream().findFirst().ifPresent(e -> {
                double addToX = this.bombsRemaining == 4 || this.bombsRemaining == 3 ? 0.84375 : 0.0;
                double addToZ = this.bombsRemaining == 4 || this.bombsRemaining == 2 ? 0.84375 : 0.0;
                int launchHeight = this.getLaunchHeight();
                double accelerationX = e.getX() - (double)pos.getX();
                double accelerationY = e.getBoundingBox().minY + (double)(e.getBbHeight() / 2.0f) - (double)pos.getY() - (double)launchHeight;
                double accelerationZ = e.getZ() - (double)pos.getZ();
                if (!level.isClientSide) {
                    level.addFreshEntity((Entity)new IMSBomb(level, (double)pos.getX() + addToX, pos.getY(), (double)pos.getZ() + addToZ, accelerationX, accelerationY, accelerationZ, launchHeight, this));
                    level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                --this.bombsRemaining;
                this.updateBombCount = true;
                this.setChanged();
            });
        }
    }

    private int getLaunchHeight() {
        BlockState state;
        int height;
        for (height = 1; height <= 9 && ((state = this.getLevel().getBlockState(this.getBlockPos().above(height))) == null || state.isAir()); ++height) {
        }
        return height;
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.putInt("bombsRemaining", this.bombsRemaining);
        tag.putBoolean("updateBombCount", this.updateBombCount);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.bombsRemaining = tag.getInt("bombsRemaining");
        this.updateBombCount = tag.getBoolean("updateBombCount");
        if (tag.contains("targetingOption")) {
            this.targetingMode.setValue(TargetingMode.values()[tag.getInt("targetingOption")]);
        }
    }

    public void setBombsRemaining(int bombsRemaining) {
        this.bombsRemaining = bombsRemaining;
        this.setChanged();
    }

    public TargetingMode getTargetingMode() {
        return (TargetingMode)((Object)this.targetingMode.get());
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.SPEED};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.range, this.disabled, this.ignoreOwner, this.targetingMode, this.respectInvisibility};
    }

    public int getAttackInterval() {
        return this.isModuleEnabled(ModuleType.SPEED) ? 40 : 80;
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    @Override
    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }
}

