/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.InventoryScannerBlock;
import net.geforcemods.securitycraft.blocks.InventoryScannerFieldBlock;
import net.geforcemods.securitycraft.inventory.ExtractOnlyItemStackHandler;
import net.geforcemods.securitycraft.inventory.InventoryScannerMenu;
import net.geforcemods.securitycraft.inventory.LensContainer;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.EmptyHandler;

public class InventoryScannerBlockEntity
extends DisguisableBlockEntity
implements Container,
MenuProvider,
ITickingBlockEntity,
ILockable,
ContainerListener {
    private Option.BooleanOption horizontal = new Option.BooleanOption("horizontal", false);
    private Option.BooleanOption solidifyField = new Option.BooleanOption("solidifyField", false);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private Option.IntOption signalLength = new Option.SignalLengthOption(60);
    private Option.RespectInvisibilityOption respectInvisibility = new Option.RespectInvisibilityOption();
    private NonNullList<ItemStack> inventoryContents = NonNullList.withSize((int)37, (Object)ItemStack.EMPTY);
    private boolean providePower;
    private int signalCooldown;
    private int togglePowerCooldown;
    private LensContainer lens = new LensContainer(1);

    public InventoryScannerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.INVENTORY_SCANNER_BLOCK_ENTITY.get(), pos, state);
        this.lens.addListener(this);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (this.togglePowerCooldown > 0) {
            --this.togglePowerCooldown;
        }
        if (this.signalCooldown > 0) {
            --this.signalCooldown;
        } else if (this.providePower && (Integer)this.signalLength.get() > 0) {
            this.togglePowerOutput();
        }
    }

    @Override
    public void onOwnerChanged(BlockState state, Level level, BlockPos pos, Player player, Owner oldOwner, Owner newOwner) {
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(level, pos, this.getBlockState(), be -> be.setOwner(this.getOwner().getUUID(), this.getOwner().getName()));
        if (connectedScanner != null) {
            connectedScanner.setOwner(this.getOwner().getUUID(), this.getOwner().getName());
            if (!level.isClientSide) {
                level.getServer().getPlayerList().broadcastAll((Packet)connectedScanner.getUpdatePacket());
            }
        }
        super.onOwnerChanged(state, level, pos, player, oldOwner, newOwner);
    }

    @Override
    public void load(CompoundTag tag) {
        ListTag list = tag.getList("Items", 10);
        super.load(tag);
        this.inventoryContents = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag stackTag = list.getCompound(i);
            int slot = stackTag.getByte("Slot") & 0xFF;
            if (slot >= this.inventoryContents.size()) continue;
            this.inventoryContents.set(slot, (Object)ItemStack.of((CompoundTag)stackTag));
        }
        this.signalCooldown = tag.getInt("cooldown");
        this.providePower = tag.getBoolean("is_providing_power");
        this.lens.fromTag(tag.getList("lens", 10));
        this.lens.setChanged();
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        ListTag list = new ListTag();
        for (int i = 0; i < this.inventoryContents.size(); ++i) {
            if (((ItemStack)this.inventoryContents.get(i)).isEmpty()) continue;
            CompoundTag stackTag = new CompoundTag();
            stackTag.putByte("Slot", (byte)i);
            ((ItemStack)this.inventoryContents.get(i)).save(stackTag);
            list.add((Object)stackTag);
        }
        tag.put("Items", (Tag)list);
        tag.putInt("cooldown", this.signalCooldown);
        tag.putBoolean("is_providing_power", this.providePower);
        tag.put("lens", (Tag)this.lens.createTag());
    }

    public int getContainerSize() {
        return 37;
    }

    public ItemStack removeItem(int index, int count) {
        if (!((ItemStack)this.inventoryContents.get(index)).isEmpty()) {
            if (((ItemStack)this.inventoryContents.get(index)).getCount() <= count) {
                ItemStack stack = (ItemStack)this.inventoryContents.get(index);
                this.inventoryContents.set(index, (Object)ItemStack.EMPTY);
                this.setChanged();
                return stack;
            }
            ItemStack stack = ((ItemStack)this.inventoryContents.get(index)).split(count);
            if (((ItemStack)this.inventoryContents.get(index)).getCount() == 0) {
                this.inventoryContents.set(index, (Object)ItemStack.EMPTY);
            }
            this.setChanged();
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public void writeClientSideData(AbstractContainerMenu menu, FriendlyByteBuf buffer) {
        super.writeClientSideData(menu, buffer);
        buffer.writeBlockPos(this.worldPosition);
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : (ItemStack)this.inventoryContents.get(slot);
    }

    public ItemStack getItem(int slot) {
        return this.getStackInSlot(slot);
    }

    public ItemStack getStackInSlotCopy(int index) {
        return (ItemStack)this.inventoryContents.get(index);
    }

    public List<ItemStack> getAllProhibitedItems() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < 10; ++i) {
            if (((ItemStack)this.inventoryContents.get(i)).isEmpty()) continue;
            stacks.add((ItemStack)this.inventoryContents.get(i));
        }
        return stacks;
    }

    public void setItem(int index, ItemStack stack) {
        this.inventoryContents.set(index, (Object)stack);
        if (!stack.isEmpty() && stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    public ItemStack addItemToStorage(ItemStack stack) {
        ItemStack remainder = stack;
        for (int i = 10; i < this.getContents().size() && !(remainder = this.insertItem(i, remainder)).isEmpty(); ++i) {
        }
        return remainder;
    }

    public ItemStack insertItem(int slot, ItemStack stackToInsert) {
        if (stackToInsert.isEmpty() || slot < 0 || slot >= this.getContents().size()) {
            return stackToInsert;
        }
        ItemStack slotStack = this.getStackInSlot(slot);
        int limit = stackToInsert.getItem().getMaxStackSize(stackToInsert);
        if (slotStack.isEmpty()) {
            this.setItem(slot, stackToInsert);
            this.setChanged();
            return ItemStack.EMPTY;
        }
        if (InventoryScannerFieldBlock.areItemStacksEqual(slotStack, stackToInsert) && slotStack.getCount() < limit) {
            if (limit - slotStack.getCount() >= stackToInsert.getCount()) {
                slotStack.setCount(slotStack.getCount() + stackToInsert.getCount());
                this.setChanged();
                return ItemStack.EMPTY;
            }
            ItemStack toInsert = stackToInsert.copy();
            ItemStack toReturn = toInsert.split(slotStack.getCount() + stackToInsert.getCount() - limit);
            slotStack.setCount(slotStack.getCount() + toInsert.getCount());
            this.setChanged();
            return toReturn;
        }
        return stackToInsert;
    }

    public LensContainer getLensContainer() {
        return this.lens;
    }

    public void containerChanged(Container container) {
        if (this.level == null) {
            return;
        }
        InventoryScannerBlockEntity otherScanner = InventoryScannerBlock.getConnectedInventoryScanner(this.level, this.worldPosition, this.getBlockState(), be -> {
            if (be.getLevel().isClientSide) {
                ClientHandler.updateBlockColorAroundPosition(be.getBlockPos());
            }
        });
        if (otherScanner != null) {
            otherScanner.getLensContainer().setItemExclusively(0, this.lens.getItem(0));
        }
    }

    public static IItemHandler getCapability(InventoryScannerBlockEntity be, Direction side) {
        if (BlockUtils.isAllowedToExtractFromProtectedObject(side, be)) {
            return new ExtractOnlyItemStackHandler((NonNullList)be.inventoryContents){

                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    return slot < 10 ? ItemStack.EMPTY : super.extractItem(slot, amount, simulate);
                }
            };
        }
        return EmptyHandler.INSTANCE;
    }

    public int getMaxStackSize() {
        return 64;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void startOpen(Player player) {
    }

    public void stopOpen(Player player) {
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return false;
    }

    public boolean isProvidingPower() {
        return this.isModuleEnabled(ModuleType.REDSTONE) && this.providePower;
    }

    public boolean wantsToProvidePower() {
        return this.providePower;
    }

    public void togglePowerOutput() {
        boolean shouldTurnOffAgain;
        int signalLength = (Integer)this.signalLength.get();
        boolean bl = shouldTurnOffAgain = signalLength > 0;
        if (!shouldTurnOffAgain && this.togglePowerCooldown > 0) {
            this.togglePowerCooldown = 5;
        } else {
            if (!shouldTurnOffAgain || this.signalCooldown <= 0) {
                this.togglePowerCooldown = 5;
                this.providePower = !this.providePower;
                BlockUtils.updateIndirectNeighbors(this.level, this.worldPosition, (Block)SCContent.INVENTORY_SCANNER.get());
                this.setChanged();
            }
            if (this.providePower && shouldTurnOffAgain) {
                this.signalCooldown = signalLength;
            }
        }
    }

    public NonNullList<ItemStack> getContents() {
        return this.inventoryContents;
    }

    public void setContents(NonNullList<ItemStack> contents) {
        this.inventoryContents = contents;
        this.setChanged();
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(this.level, this.worldPosition);
        if (connectedScanner != null && (toggled ? !connectedScanner.isModuleEnabled(module) : !connectedScanner.hasModule(module))) {
            connectedScanner.insertModule(stack, toggled);
        }
        if (module == ModuleType.DISGUISE) {
            this.onInsertDisguiseModule(this, stack);
            if (connectedScanner != null) {
                this.onInsertDisguiseModule(connectedScanner, stack);
            }
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(this.level, this.worldPosition);
        if (connectedScanner != null && (toggled ? connectedScanner.isModuleEnabled(module) : connectedScanner.hasModule(module))) {
            connectedScanner.removeModule(module, toggled);
        }
        if (module == ModuleType.STORAGE) {
            int i;
            for (i = 10; i < this.getContainerSize(); ++i) {
                Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (ItemStack)((ItemStack)this.getContents().get(i)));
            }
            if (connectedScanner != null) {
                for (i = 10; i < connectedScanner.getContainerSize(); ++i) {
                    connectedScanner.getContents().set(i, (Object)ItemStack.EMPTY);
                }
            }
        } else if (module == ModuleType.DISGUISE) {
            this.onRemoveDisguiseModule(this);
            if (connectedScanner != null) {
                this.onRemoveDisguiseModule(connectedScanner);
            }
        }
    }

    private void onInsertDisguiseModule(BlockEntity be, ItemStack stack) {
        if (!be.getLevel().isClientSide) {
            be.getLevel().sendBlockUpdated(be.getBlockPos(), be.getBlockState(), be.getBlockState(), 3);
        } else {
            ClientHandler.putDisguisedBeRenderer(be, stack);
        }
    }

    private void onRemoveDisguiseModule(BlockEntity be) {
        if (!be.getLevel().isClientSide) {
            be.getLevel().sendBlockUpdated(be.getBlockPos(), be.getBlockState(), be.getBlockState(), 3);
        } else {
            ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf(be);
        }
    }

    @Override
    public boolean shouldDropModules() {
        return InventoryScannerBlock.getConnectedInventoryScanner(this.level, this.worldPosition) == null;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.SMART, ModuleType.STORAGE, ModuleType.DISGUISE, ModuleType.REDSTONE};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (option instanceof Option.BooleanOption) {
            Option.BooleanOption bo = (Option.BooleanOption)option;
            if (option == this.horizontal) {
                this.modifyFields((offsetPos, state) -> this.level.setBlockAndUpdate(offsetPos, (BlockState)state.setValue((Property)InventoryScannerFieldBlock.HORIZONTAL, (Comparable)((Boolean)bo.get()))), connectedScanner -> connectedScanner.setHorizontal((Boolean)bo.get()));
                this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)InventoryScannerBlock.HORIZONTAL, (Comparable)((Boolean)bo.get())));
            } else if (option == this.solidifyField) {
                InventoryScannerBlockEntity connectedScanner2 = InventoryScannerBlock.getConnectedInventoryScanner(this.level, this.worldPosition);
                if (connectedScanner2 != null) {
                    connectedScanner2.setSolidifyField((Boolean)bo.get());
                }
            } else if (option == this.disabled) {
                if (!((Boolean)bo.get()).booleanValue()) {
                    InventoryScannerBlock.checkAndPlaceAppropriately(this.level, this.worldPosition, true);
                } else {
                    this.modifyFields((offsetPos, state) -> this.level.destroyBlock(offsetPos, false), connectedScanner -> connectedScanner.setDisabled(true));
                }
            } else {
                if (option != this.ignoreOwner) throw new UnsupportedOperationException("Unhandled option synchronization in inventory scanner! " + option.getName());
                InventoryScannerBlockEntity connectedScanner3 = InventoryScannerBlock.getConnectedInventoryScanner(this.level, this.worldPosition);
                if (connectedScanner3 != null) {
                    connectedScanner3.setIgnoresOwner((Boolean)bo.get());
                }
            }
        } else {
            if (!(option instanceof Option.IntOption)) throw new UnsupportedOperationException("Unhandled option synchronization in inventory scanner! " + option.getName());
            Option.IntOption io = (Option.IntOption)option;
            if (option != this.signalLength) throw new UnsupportedOperationException("Unhandled option synchronization in inventory scanner! " + option.getName());
            InventoryScannerBlockEntity connectedScanner4 = InventoryScannerBlock.getConnectedInventoryScanner(this.level, this.worldPosition);
            if (connectedScanner4 != null) {
                connectedScanner4.setSignalLength((Integer)io.get());
            }
        }
        super.onOptionChanged(option);
    }

    private void modifyFields(BiConsumer<BlockPos, BlockState> blockSetter, Consumer<InventoryScannerBlockEntity> connectedScannerModifier) {
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(this.level, this.worldPosition);
        if (connectedScanner != null) {
            Direction facing = (Direction)this.getBlockState().getValue((Property)InventoryScannerBlock.FACING);
            connectedScannerModifier.accept(connectedScanner);
            for (int i = 0; i <= (Integer)ConfigHandler.SERVER.inventoryScannerRange.get(); ++i) {
                BlockPos offsetPos = this.worldPosition.relative(facing, i);
                BlockState state = this.level.getBlockState(offsetPos);
                Block block = state.getBlock();
                if (block == SCContent.INVENTORY_SCANNER_FIELD.get()) {
                    blockSetter.accept(offsetPos, state);
                    continue;
                }
                if (!state.isAir() && block != SCContent.INVENTORY_SCANNER_FIELD.get() && block != SCContent.INVENTORY_SCANNER.get() || block == SCContent.INVENTORY_SCANNER.get() && state.getValue((Property)InventoryScannerBlock.FACING) == facing.getOpposite()) break;
            }
        }
    }

    public void setHorizontal(boolean isHorizontal) {
        if ((Boolean)this.horizontal.get() != isHorizontal) {
            this.horizontal.setValue(isHorizontal);
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)InventoryScannerBlock.HORIZONTAL, (Comparable)Boolean.valueOf(isHorizontal)));
            this.setChanged();
        }
    }

    public boolean isHorizontal() {
        return (Boolean)this.horizontal.get();
    }

    public boolean doesFieldSolidify() {
        return (Boolean)this.solidifyField.get();
    }

    public void setSolidifyField(boolean shouldSolidify) {
        if (this.doesFieldSolidify() != shouldSolidify) {
            this.solidifyField.setValue(shouldSolidify);
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.setChanged();
        }
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public void setDisabled(boolean disabled) {
        if (this.isDisabled() != disabled) {
            this.disabled.setValue(disabled);
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.setChanged();
        }
    }

    @Override
    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    public void setIgnoresOwner(boolean ignoresOwner) {
        if (this.ignoresOwner() != ignoresOwner) {
            this.ignoreOwner.setValue(ignoresOwner);
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.setChanged();
        }
    }

    public void setSignalLength(int signalLength) {
        this.signalLength.setValue(signalLength);
        this.togglePowerCooldown = 5;
        this.providePower = false;
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        this.setChanged();
    }

    public boolean isConsideredInvisible(LivingEntity entity) {
        return this.respectInvisibility.isConsideredInvisible(entity);
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.horizontal, this.solidifyField, this.disabled, this.ignoreOwner, this.signalLength, this.respectInvisibility};
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
        return new InventoryScannerMenu(windowId, this.level, this.worldPosition, inv);
    }

    public Component getDisplayName() {
        return super.getDisplayName();
    }

    public void clearContent() {
        this.inventoryContents.clear();
    }

    public boolean isEmpty() {
        return this.inventoryContents.isEmpty();
    }

    public ItemStack removeItemNoUpdate(int index) {
        return (ItemStack)this.inventoryContents.remove(index);
    }
}

