/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICodebreakable;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.inventory.ItemContainer;
import net.geforcemods.securitycraft.inventory.KeycardReaderMenu;
import net.geforcemods.securitycraft.items.CodebreakerItem;
import net.geforcemods.securitycraft.items.KeycardItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.TeamUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class KeycardReaderBlockEntity
extends DisguisableBlockEntity
implements MenuProvider,
ILockable,
ICodebreakable {
    protected boolean[] acceptedLevels = new boolean[]{true, false, false, false, false};
    protected int signature = 0;
    protected Option.BooleanOption sendDenylistMessage = new Option.SendDenylistMessageOption(true);
    protected Option.IntOption signalLength = new Option.SignalLengthOption(60);
    protected Option.DisabledOption disabled = new Option.DisabledOption(false);

    public KeycardReaderBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)SCContent.KEYCARD_READER_BLOCK_ENTITY.get(), pos, state);
    }

    public KeycardReaderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        CompoundTag acceptedLevelsTag = new CompoundTag();
        for (int i = 1; i <= 5; ++i) {
            acceptedLevelsTag.putBoolean("lvl" + i, this.acceptedLevels[i - 1]);
        }
        tag.put("acceptedLevels", (Tag)acceptedLevelsTag);
        tag.putInt("signature", this.signature);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        if (tag.contains("passLV")) {
            boolean oldRequiresExactKeycard = false;
            int oldPassLV = tag.getInt("passLV") - 1;
            if (tag.contains("requiresExactKeycard")) {
                oldRequiresExactKeycard = tag.getBoolean("requiresExactKeycard");
            }
            for (int i = 0; i < 5; ++i) {
                this.acceptedLevels[i] = oldRequiresExactKeycard ? i == oldPassLV : i >= oldPassLV;
            }
        }
        if (tag.contains("acceptedLevels", 10)) {
            CompoundTag acceptedLevelsTag = tag.getCompound("acceptedLevels");
            for (int i = 1; i <= 5; ++i) {
                this.acceptedLevels[i - 1] = acceptedLevelsTag.getBoolean("lvl" + i);
            }
        }
        this.signature = tag.getInt("signature");
        if (tag.contains("sendMessage")) {
            this.sendDenylistMessage.setValue(tag.getBoolean("sendMessage"));
        }
    }

    @Override
    public boolean shouldAttemptCodebreak(Player player) {
        if (this.isDisabled()) {
            player.displayClientMessage((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            return false;
        }
        return (Boolean)this.getBlockState().getValue((Property)BlockStateProperties.POWERED) == false;
    }

    @Override
    public void useCodebreaker(Player player) {
        if (!this.level.isClientSide) {
            this.activate();
        }
    }

    public InteractionResult onRightClickWithActionItem(ItemStack stack, InteractionHand hand, Player player, boolean isCodebreaker, boolean isKeycardHolder) {
        if (isCodebreaker) {
            double chance = (Double)ConfigHandler.SERVER.codebreakerChance.get();
            if (chance < 0.0) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getBlockState().getBlock().getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:codebreakerDisabled", new Object[0]), ChatFormatting.RED);
            } else {
                if (!player.isCreative() && (this.isOwnedBy((Entity)player) || CodebreakerItem.wasRecentlyUsed(stack))) {
                    return InteractionResult.PASS;
                }
                boolean isSuccessful = player.isCreative() || SecurityCraft.RANDOM.nextDouble() < chance;
                CompoundTag tag = stack.getOrCreateTag();
                stack.hurtAndBreak(1, (LivingEntity)player, p -> p.broadcastBreakEvent(hand));
                tag.putLong("last_used_time", System.currentTimeMillis());
                tag.putBoolean("was_successful", isSuccessful);
                if (isSuccessful) {
                    this.activate();
                } else {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((CodebreakerItem)((Object)SCContent.CODEBREAKER.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:codebreaker.failed", new Object[0]), ChatFormatting.RED);
                }
            }
        } else if (isKeycardHolder) {
            ItemContainer holderInventory = ItemContainer.keycardHolder(stack);
            MutableComponent feedback = null;
            for (int i = 0; i < holderInventory.getContainerSize(); ++i) {
                ItemStack keycardStack = holderInventory.getItem(i);
                if (!(keycardStack.getItem() instanceof KeycardItem) || !keycardStack.hasTag() || (feedback = this.insertCard(keycardStack, player)) != null) continue;
                holderInventory.save(stack.getOrCreateTag());
                return InteractionResult.SUCCESS;
            }
            if (feedback == null) {
                PlayerUtils.sendMessageToPlayer(player, Component.translatable((String)this.getBlockState().getBlock().getDescriptionId()), Utils.localize("messages.securitycraft:keycard_holder.no_keycards", new Object[0]), ChatFormatting.RED);
            } else {
                PlayerUtils.sendMessageToPlayer(player, Component.translatable((String)this.getBlockState().getBlock().getDescriptionId()), Utils.localize("messages.securitycraft:keycard_holder.fail", new Object[0]), ChatFormatting.RED);
            }
        } else {
            MutableComponent feedback = this.insertCard(stack, player);
            if (feedback != null) {
                PlayerUtils.sendMessageToPlayer(player, Component.translatable((String)this.getBlockState().getBlock().getDescriptionId()), feedback, ChatFormatting.RED);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public MutableComponent insertCard(ItemStack stack, Player player) {
        boolean powered;
        CompoundTag tag = stack.getTag();
        Owner keycardOwner = new Owner(tag.getString("ownerName"), tag.getString("ownerUUID"));
        String usableBy = tag.getString("usable_by");
        if (!TeamUtils.areOnSameTeam(this.getOwner(), keycardOwner) || !this.getOwner().getUUID().equals(keycardOwner.getUUID())) {
            return Component.translatable((String)"messages.securitycraft:keycardReader.differentOwner");
        }
        if (!usableBy.isBlank() && !usableBy.equals(player.getGameProfile().getName())) {
            return Component.translatable((String)"messages.securitycraft:keycardReader.cantUse");
        }
        if (this.getSignature() != tag.getInt("signature")) {
            return Component.translatable((String)"messages.securitycraft:keycardReader.wrongSignature");
        }
        int keycardLevel = ((KeycardItem)stack.getItem()).getLevel();
        if (!this.getAcceptedLevels()[keycardLevel]) {
            return Component.translatable((String)"messages.securitycraft:keycardReader.wrongLevel", (Object[])new Object[]{keycardLevel + 1});
        }
        boolean bl = powered = (Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)BlockStateProperties.POWERED) != false && this.getSignalLength() > 0;
        if (!powered) {
            if (tag.getBoolean("limited")) {
                int uses = tag.getInt("uses");
                if (uses <= 0) {
                    return Component.translatable((String)"messages.securitycraft:keycardReader.noUses");
                }
                if (!player.isCreative()) {
                    tag.putInt("uses", --uses);
                }
            }
            this.activate();
        }
        return null;
    }

    public void activate() {
        Block block = this.getBlockState().getBlock();
        int signalLength = this.getSignalLength();
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().cycle((Property)BlockStateProperties.POWERED));
        BlockUtils.updateIndirectNeighbors(this.level, this.worldPosition, block);
        if (signalLength > 0) {
            this.level.scheduleTick(this.worldPosition, block, signalLength);
        }
    }

    public void writeClientSideData(AbstractContainerMenu menu, FriendlyByteBuf buffer) {
        super.writeClientSideData(menu, buffer);
        buffer.writeBlockPos(this.worldPosition);
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (option == this.signalLength) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors(this.level, this.worldPosition, this.getBlockState().getBlock());
        }
        super.onOptionChanged(option);
    }

    public void setAcceptedLevels(boolean[] acceptedLevels) {
        this.acceptedLevels = acceptedLevels;
        this.setChanged();
    }

    public boolean[] getAcceptedLevels() {
        return this.acceptedLevels;
    }

    public void setSignature(int signature) {
        this.signature = signature;
        this.setChanged();
    }

    public int getSignature() {
        return this.signature;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.DISGUISE, ModuleType.SMART};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendDenylistMessage, this.signalLength, this.disabled};
    }

    public boolean sendsDenylistMessage() {
        return (Boolean)this.sendDenylistMessage.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
        return new KeycardReaderMenu(windowId, inv, this.level, this.worldPosition);
    }

    @Override
    public void onOwnerChanged(BlockState state, Level level, BlockPos pos, Player player, Owner oldOwner, Owner newOwner) {
        this.reset();
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
        BlockUtils.updateIndirectNeighbors(level, pos, state.getBlock());
        super.onOwnerChanged(state, level, pos, player, oldOwner, newOwner);
    }

    public void reset() {
        this.acceptedLevels = new boolean[]{true, false, false, false, false};
        this.signature = 0;
        this.setChanged();
    }

    public Component getDisplayName() {
        return super.getDisplayName();
    }
}

