/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.LaserBlock;
import net.geforcemods.securitycraft.blocks.LaserFieldBlock;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.inventory.LaserBlockMenu;
import net.geforcemods.securitycraft.inventory.LensContainer;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.UpdateLaserColors;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.network.PacketDistributor;

public class LaserBlockBlockEntity
extends LinkableBlockEntity
implements MenuProvider,
ContainerListener {
    private Option.DisabledOption disabled = new Option.DisabledOption((Boolean)false){

        @Override
        public void toggle() {
            this.setValue((Boolean)this.get() == false);
            LaserBlockBlockEntity.this.setLasersAccordingToDisabledOption();
        }
    };
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private Option.IntOption signalLength = new Option.SignalLengthOption(50);
    private Option.RespectInvisibilityOption respectInvisibility = new Option.RespectInvisibilityOption();
    private Map<Direction, Boolean> sideConfig = (Map)Util.make(() -> {
        EnumMap<Direction, Boolean> map = new EnumMap<Direction, Boolean>(Direction.class);
        for (Direction dir : Direction.values()) {
            map.put(dir, true);
        }
        return map;
    });
    private LensContainer lenses = new LensContainer(6);
    private long lastToggleTime;

    public LaserBlockBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.LASER_BLOCK_BLOCK_ENTITY.get(), pos, state);
        this.lenses.addListener(this);
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("sideConfig", (Tag)LaserBlockBlockEntity.saveSideConfig(this.sideConfig));
        for (int i = 0; i < this.lenses.getContainerSize(); ++i) {
            tag.put("lens" + i, (Tag)this.lenses.getItem(i).save(new CompoundTag()));
        }
    }

    public static CompoundTag saveSideConfig(Map<Direction, Boolean> sideConfig) {
        CompoundTag sideConfigTag = new CompoundTag();
        sideConfig.forEach((dir, enabled) -> sideConfigTag.putBoolean(dir.getName(), enabled.booleanValue()));
        return sideConfigTag;
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.sideConfig = LaserBlockBlockEntity.loadSideConfig(tag.getCompound("sideConfig"));
        for (int i = 0; i < this.lenses.getContainerSize(); ++i) {
            this.lenses.setItemExclusively(i, ItemStack.of((CompoundTag)tag.getCompound("lens" + i)));
        }
        this.lenses.setChanged();
    }

    public static Map<Direction, Boolean> loadSideConfig(CompoundTag sideConfigTag) {
        EnumMap<Direction, Boolean> sideConfig = new EnumMap<Direction, Boolean>(Direction.class);
        for (Direction dir : Direction.values()) {
            if (sideConfigTag.contains(dir.getName(), 1)) {
                sideConfig.put(dir, sideConfigTag.getBoolean(dir.getName()));
                continue;
            }
            sideConfig.put(dir, true);
        }
        return sideConfig;
    }

    public void writeClientSideData(AbstractContainerMenu menu, FriendlyByteBuf buffer) {
        super.writeClientSideData(menu, buffer);
        buffer.writeBlockPos(this.worldPosition);
        buffer.writeNbt((Tag)LaserBlockBlockEntity.saveSideConfig(this.sideConfig));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void onLinkedBlockAction(ILinkedAction action, List<LinkableBlockEntity> excludedBEs) {
        if (action instanceof ILinkedAction.OptionChanged) {
            ILinkedAction.OptionChanged optionChanged = (ILinkedAction.OptionChanged)action;
            Option option = optionChanged.option();
            if (option.getName().equals(this.disabled.getName())) {
                this.disabled.copy(option);
                this.setLasersAccordingToDisabledOption();
            } else if (option.getName().equals(this.ignoreOwner.getName())) {
                this.ignoreOwner.copy(option);
            } else if (option.getName().equals(this.signalLength.getName())) {
                this.signalLength.copy(option);
                this.turnOffRedstoneOutput();
            } else {
                if (!option.getName().equals(this.respectInvisibility.getName())) throw new UnsupportedOperationException("Unhandled option synchronization in laser block! " + option.getName());
                this.respectInvisibility.copy(option);
            }
        } else if (action instanceof ILinkedAction.ModuleInserted) {
            ILinkedAction.ModuleInserted moduleInserted = (ILinkedAction.ModuleInserted)action;
            this.insertModule(moduleInserted.stack(), moduleInserted.wasModuleToggled());
        } else if (action instanceof ILinkedAction.ModuleRemoved) {
            ILinkedAction.ModuleRemoved moduleRemoved = (ILinkedAction.ModuleRemoved)action;
            this.removeModule(moduleRemoved.moduleType(), moduleRemoved.wasModuleToggled());
        } else if (action instanceof ILinkedAction.OwnerChanged) {
            ILinkedAction.OwnerChanged ownerChanged = (ILinkedAction.OwnerChanged)action;
            Owner owner = ownerChanged.newOwner();
            this.setOwner(owner.getUUID(), owner.getName());
        } else if (action instanceof ILinkedAction.StateChanged) {
            ILinkedAction.StateChanged stateChanged = (ILinkedAction.StateChanged)action;
            BlockState state = this.getBlockState();
            if (stateChanged.property() == LaserBlock.POWERED) {
                if (this.timeSinceLastToggle() < 500L) {
                    this.setLastToggleTime(System.currentTimeMillis());
                } else {
                    int signalLength = this.getSignalLength();
                    this.setLastToggleTime(System.currentTimeMillis());
                    this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.cycle((Property)LaserBlock.POWERED));
                    BlockUtils.updateIndirectNeighbors(this.level, this.worldPosition, (Block)SCContent.LASER_BLOCK.get());
                    if (signalLength > 0) {
                        this.level.scheduleTick(this.worldPosition, (Block)SCContent.LASER_BLOCK.get(), signalLength);
                    }
                }
            }
        }
        excludedBEs.add(this);
        this.propagate(action, excludedBEs);
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (option == this.signalLength) {
            this.turnOffRedstoneOutput();
        }
        super.onOptionChanged(option);
    }

    private void turnOffRedstoneOutput() {
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)LaserBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        BlockUtils.updateIndirectNeighbors(this.level, this.worldPosition, this.getBlockState().getBlock());
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onDisguiseModuleInserted(this, stack, toggled);
        } else if (module == ModuleType.SMART) {
            this.applyExistingSideConfig();
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onDisguiseModuleRemoved(this, stack, toggled);
        } else if (module == ModuleType.REDSTONE) {
            if (((Boolean)this.getBlockState().getValue((Property)LaserBlock.POWERED)).booleanValue()) {
                this.turnOffRedstoneOutput();
            }
        } else if (module == ModuleType.SMART) {
            this.applyExistingSideConfig();
        }
    }

    public void containerChanged(Container container) {
        if (this.level == null) {
            return;
        }
        for (Direction direction : Direction.values()) {
            int i = 1;
            BlockPos pos = this.getBlockPos();
            BlockPos modifiedPos = pos.relative(direction, i);
            BlockState stateAtModifiedPos = this.level.getBlockState(modifiedPos);
            ArrayList<BlockPos> positionsToUpdate = new ArrayList<BlockPos>();
            while (i < (Integer)ConfigHandler.SERVER.laserBlockRange.get() && stateAtModifiedPos.getBlock() != SCContent.LASER_BLOCK.get()) {
                modifiedPos = pos.relative(direction, ++i);
                stateAtModifiedPos = this.level.getBlockState(modifiedPos);
                positionsToUpdate.add(modifiedPos);
            }
            BlockEntity blockEntity = this.level.getBlockEntity(modifiedPos);
            if (!(blockEntity instanceof LaserBlockBlockEntity)) continue;
            LaserBlockBlockEntity otherLaser = (LaserBlockBlockEntity)blockEntity;
            otherLaser.getLensContainer().setItemExclusively(direction.getOpposite().ordinal(), this.lenses.getItem(direction.ordinal()));
            if (!this.level.isClientSide) {
                PacketDistributor.DIMENSION.with((Object)this.level.dimension()).send(new CustomPacketPayload[]{new UpdateLaserColors(positionsToUpdate)});
            }
            this.level.sendBlockUpdated(modifiedPos, stateAtModifiedPos, stateAtModifiedPos, 2);
        }
        this.setChanged();
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        super.onDataPacket(net, packet);
        DisguisableBlockEntity.onHandleUpdateTag(this);
    }

    public void onLoad() {
        super.onLoad();
        DisguisableBlockEntity.onHandleUpdateTag(this);
    }

    @Override
    public void readOptions(CompoundTag tag) {
        if (tag.contains("enabled")) {
            tag.putBoolean("disabled", !tag.getBoolean("enabled"));
        }
        for (Option<?> option : this.customOptions()) {
            option.load(tag);
        }
    }

    public static IItemHandler getCapability(LaserBlockBlockEntity be, Direction side) {
        return BlockUtils.isAllowedToExtractFromProtectedObject(side, be) ? new InvWrapper((Container)be.lenses) : new InsertOnlyInvWrapper((Container)be.lenses);
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new LaserBlockMenu(id, this.level, this.worldPosition, this.sideConfig, inventory);
    }

    public Component getDisplayName() {
        return super.getDisplayName();
    }

    public LensContainer getLensContainer() {
        return this.lenses;
    }

    public void setRemoved() {
        super.setRemoved();
        DisguisableBlockEntity.onSetRemoved(this);
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.HARMING, ModuleType.ALLOWLIST, ModuleType.DISGUISE, ModuleType.REDSTONE, ModuleType.SMART};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.disabled, this.ignoreOwner, this.signalLength, this.respectInvisibility};
    }

    public ModelData getModelData() {
        return DisguisableBlockEntity.getModelData(this);
    }

    public boolean isEnabled() {
        return (Boolean)this.disabled.get() == false;
    }

    @Override
    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public boolean isConsideredInvisible(LivingEntity entity) {
        return this.respectInvisibility.isConsideredInvisible(entity);
    }

    public void setLastToggleTime(long lastToggleTime) {
        this.lastToggleTime = lastToggleTime;
    }

    public long getLastToggleTime() {
        return this.lastToggleTime;
    }

    public long timeSinceLastToggle() {
        return System.currentTimeMillis() - this.getLastToggleTime();
    }

    public void applyNewSideConfig(Map<Direction, Boolean> sideConfig, Player player) {
        sideConfig.forEach((direction, enabled) -> this.setSideEnabled((Direction)direction, (boolean)enabled, player));
    }

    public void applyExistingSideConfig() {
        for (Direction direction : Direction.values()) {
            this.toggleLaserOnSide(direction, this.isSideEnabled(direction), null, false);
        }
    }

    public void setSideEnabled(Direction direction, boolean enabled, Player player) {
        this.sideConfig.put(direction, enabled);
        if (this.isModuleEnabled(ModuleType.SMART)) {
            this.toggleLaserOnSide(direction, enabled, player, true);
        }
    }

    public void toggleLaserOnSide(Direction direction, boolean enabled, Player player, boolean modifyOtherLaser) {
        BlockEntity blockEntity;
        int i = 1;
        BlockPos pos = this.getBlockPos();
        BlockPos modifiedPos = pos.relative(direction, i);
        BlockState stateAtModifiedPos = this.level.getBlockState(modifiedPos);
        while (i < (Integer)ConfigHandler.SERVER.laserBlockRange.get() && stateAtModifiedPos.getBlock() != SCContent.LASER_BLOCK.get()) {
            modifiedPos = pos.relative(direction, ++i);
            stateAtModifiedPos = this.level.getBlockState(modifiedPos);
        }
        if (modifyOtherLaser && (blockEntity = this.level.getBlockEntity(modifiedPos)) instanceof LaserBlockBlockEntity) {
            LaserBlockBlockEntity otherLaser = (LaserBlockBlockEntity)blockEntity;
            otherLaser.sideConfig.put(direction.getOpposite(), enabled);
        }
        if (enabled && (blockEntity = this.getBlockState().getBlock()) instanceof LaserBlock) {
            LaserBlock block = (LaserBlock)blockEntity;
            block.setLaser(this.level, pos, direction, player);
        } else if (!enabled) {
            int boundType = LaserFieldBlock.getBoundType(direction);
            BlockUtils.removeInSequence((directionToCheck, stateToCheck) -> stateToCheck.is((Block)SCContent.LASER_FIELD.get()) && (Integer)stateToCheck.getValue((Property)LaserFieldBlock.BOUNDTYPE) == boundType, (LevelAccessor)this.level, this.worldPosition, direction);
        }
    }

    public Map<Direction, Boolean> getSideConfig() {
        return this.sideConfig;
    }

    public boolean isSideEnabled(Direction dir) {
        return !this.isModuleEnabled(ModuleType.SMART) || this.sideConfig.getOrDefault(dir, true) != false;
    }

    private void setLasersAccordingToDisabledOption() {
        if (this.isEnabled()) {
            ((LaserBlock)this.getBlockState().getBlock()).setLaser(this.level, this.worldPosition, null);
        } else {
            LaserBlock.destroyAdjacentLasers((LevelAccessor)this.level, this.worldPosition);
        }
    }

    public ModuleType synchronizeWith(LaserBlockBlockEntity that) {
        if (!LinkableBlockEntity.isLinkedWith(this, that)) {
            Object2BooleanArrayMap bothInsertedModules = new Object2BooleanArrayMap();
            List thisInsertedModules = this.getInsertedModules();
            List thatInsertedModules = that.getInsertedModules();
            for (ModuleType moduleType : thisInsertedModules) {
                ItemStack thisModule = this.getModule(moduleType);
                if (thatInsertedModules.contains((Object)moduleType) && !Objects.equals(thisModule.getTag(), that.getModule(moduleType).getTag())) {
                    return moduleType;
                }
                bothInsertedModules.put(thisModule.copy(), this.isModuleEnabled(moduleType));
                this.removeModule(moduleType, false);
            }
            for (ModuleType moduleType : thatInsertedModules) {
                bothInsertedModules.put(that.getModule(moduleType).copy(), that.isModuleEnabled(moduleType));
                that.removeModule(moduleType, false);
                this.propagate((ILinkedAction)new ILinkedAction.ModuleRemoved(moduleType, false), that);
            }
            this.readOptions(that.writeOptions(new CompoundTag()));
            LinkableBlockEntity.link(this, that);
            for (Map.Entry entry : bothInsertedModules.entrySet()) {
                ItemStack module = (ItemStack)entry.getKey();
                ModuleItem item = (ModuleItem)module.getItem();
                ModuleType type = item.getModuleType();
                this.insertModule((ItemStack)entry.getKey(), false);
                this.propagate((ILinkedAction)new ILinkedAction.ModuleInserted(module, item, false), this);
                this.toggleModuleState(type, (Boolean)entry.getValue());
                this.propagate((ILinkedAction)new ILinkedAction.ModuleInserted(module, item, true), this);
            }
        }
        return null;
    }
}

