/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.EnumMap;
import java.util.Map;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class ReinforcedChiseledBookshelfBlockEntity
extends ChiseledBookShelfBlockEntity
implements IOwnable,
IModuleInventory {
    private NonNullList<ItemStack> modules = NonNullList.withSize((int)this.getMaxNumberOfModules(), (Object)ItemStack.EMPTY);
    private Owner owner = new Owner();
    private Map<ModuleType, Boolean> moduleStates = new EnumMap<ModuleType, Boolean>(ModuleType.class);

    public ReinforcedChiseledBookshelfBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public static IItemHandler getCapability(ReinforcedChiseledBookshelfBlockEntity be, Direction side) {
        if (BlockUtils.isAllowedToExtractFromProtectedObject(side, be)) {
            return new InvWrapper((Container)be);
        }
        return new InsertOnlyInvWrapper((Container)be);
    }

    public BlockEntityType<?> getType() {
        return (BlockEntityType)SCContent.REINFORCED_CHISELED_BOOKSHELF_BLOCK_ENTITY.get();
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        this.owner.load(tag);
        this.modules = this.readModuleInventory(tag);
        this.moduleStates = this.readModuleStates(tag);
    }

    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        if (this.owner != null) {
            this.owner.save(tag, this.needsValidation());
        }
        this.writeModuleInventory(tag);
        this.writeModuleStates(tag);
    }

    public CompoundTag getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        super.onDataPacket(net, packet);
        this.handleUpdateTag(packet.getTag());
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.load(tag);
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
        this.setChanged();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST};
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public boolean isModuleEnabled(ModuleType module) {
        return this.hasModule(module) && this.moduleStates.get((Object)module) == Boolean.TRUE;
    }

    @Override
    public void toggleModuleState(ModuleType module, boolean shouldBeEnabled) {
        this.moduleStates.put(module, shouldBeEnabled);
    }

    @Override
    public Level myLevel() {
        return this.level;
    }

    @Override
    public BlockPos myPos() {
        return this.worldPosition;
    }
}

