/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IViewActivated;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.RetinalScannerBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class RetinalScannerBlockEntity
extends DisguisableBlockEntity
implements IViewActivated,
ITickingBlockEntity,
ILockable {
    private static Executor mainThreadExecutor;
    private Option.BooleanOption activatedByEntities = new Option.BooleanOption("activatedByEntities", false);
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private Option.IntOption signalLength = new Option.SignalLengthOption(60);
    private Option.DoubleOption maximumDistance = new Option.DoubleOption("maximumDistance", 5.0, 0.1, 25.0, 0.1){

        @Override
        public String getKey(String denotation) {
            return "option.generic.viewActivated.maximumDistance";
        }
    };
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.RespectInvisibilityOption respectInvisibility = new Option.RespectInvisibilityOption();
    private GameProfile ownerProfile;
    private int viewCooldown = 0;

    public RetinalScannerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.RETINAL_SCANNER_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        this.checkView(level, pos);
    }

    @Override
    public boolean onEntityViewed(LivingEntity entity, BlockHitResult hitResult) {
        if (!this.isLocked() && !this.isDisabled()) {
            BlockState state = this.getBlockState();
            if (state.getValue((Property)RetinalScannerBlock.FACING) != hitResult.getDirection()) {
                return false;
            }
            int signalLength = this.getSignalLength();
            if (!(((Boolean)state.getValue((Property)RetinalScannerBlock.POWERED)).booleanValue() && signalLength != 0 || this.isConsideredInvisible(entity))) {
                if (entity instanceof Player) {
                    Owner viewingPlayer;
                    Player player = (Player)entity;
                    if (((Boolean)ConfigHandler.SERVER.trickScannersWithPlayerHeads.get()).booleanValue() && player.getItemBySlot(EquipmentSlot.HEAD).getItem() == Items.PLAYER_HEAD) {
                        viewingPlayer = PlayerUtils.getSkullOwner(player);
                    } else {
                        Owner owner = viewingPlayer = this.isOwnedBy(player, true) ? PlayerUtils.getOwnerFromPlayerOrMask(player) : new Owner(player);
                    }
                    if (!this.isOwnedBy(viewingPlayer) && !this.isAllowed(viewingPlayer.getName())) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(((RetinalScannerBlock)SCContent.RETINAL_SCANNER.get()).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:retinalScanner.notOwner", PlayerUtils.getOwnerComponent(this.getOwner())), ChatFormatting.RED);
                        return true;
                    }
                    if (((Boolean)this.sendMessage.get()).booleanValue()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(((RetinalScannerBlock)SCContent.RETINAL_SCANNER.get()).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:retinalScanner.hello", viewingPlayer.getName()), ChatFormatting.GREEN);
                    }
                } else if (this.activatedOnlyByPlayer()) {
                    return false;
                }
                this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.cycle((Property)RetinalScannerBlock.POWERED));
                BlockUtils.updateIndirectNeighbors(this.level, this.worldPosition, (Block)SCContent.RETINAL_SCANNER.get());
                if (signalLength > 0) {
                    this.level.scheduleTick(new BlockPos((Vec3i)this.worldPosition), (Block)SCContent.RETINAL_SCANNER.get(), signalLength);
                }
                return true;
            }
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.isLocked() && ((Boolean)this.sendMessage.get()).booleanValue()) {
                MutableComponent blockName = Utils.localize(((RetinalScannerBlock)SCContent.RETINAL_SCANNER.get()).getDescriptionId(), new Object[0]);
                PlayerUtils.sendMessageToPlayer(player, blockName, Utils.localize("messages.securitycraft:sonic_security_system.locked", blockName), ChatFormatting.DARK_RED, false);
            } else if (this.isDisabled()) {
                player.displayClientMessage((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            }
            return true;
        }
        return false;
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (option == this.signalLength) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)RetinalScannerBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors(this.level, this.worldPosition, this.getBlockState().getBlock());
        }
        super.onOptionChanged(option);
    }

    @Override
    public int getDefaultViewCooldown() {
        return this.getSignalLength() + 30;
    }

    @Override
    public int getViewCooldown() {
        return this.viewCooldown;
    }

    @Override
    public void setViewCooldown(int viewCooldown) {
        this.viewCooldown = viewCooldown;
        this.setChanged();
    }

    @Override
    public boolean activatedOnlyByPlayer() {
        return (Boolean)this.activatedByEntities.get() == false;
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    @Override
    public double getMaximumDistance() {
        return (Double)this.maximumDistance.get();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.activatedByEntities, this.sendMessage, this.signalLength, this.disabled, this.maximumDistance, this.respectInvisibility};
    }

    public static void setMainThreadExecutor(Executor mainThreadExecutor) {
        RetinalScannerBlockEntity.mainThreadExecutor = mainThreadExecutor;
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        if (!StringUtil.isNullOrEmpty((String)this.getOwner().getName()) && !this.getOwner().getName().equals("owner") && this.ownerProfile != null) {
            CompoundTag ownerProfileTag = new CompoundTag();
            NbtUtils.writeGameProfile((CompoundTag)ownerProfileTag, (GameProfile)this.ownerProfile);
            tag.put("ownerProfile", (Tag)ownerProfileTag);
        }
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        if (tag.contains("ownerProfile", 10)) {
            this.setPlayerProfile(NbtUtils.readGameProfile((CompoundTag)tag.getCompound("ownerProfile")));
        }
    }

    @Override
    public void onOwnerChanged(BlockState state, Level world, BlockPos pos, Player player, Owner oldOwner, Owner newOwner) {
        this.setPlayerProfile(new GameProfile(Util.NIL_UUID, this.getOwner().getName()));
        super.onOwnerChanged(state, world, pos, player, oldOwner, newOwner);
    }

    @Nullable
    public GameProfile getPlayerProfile() {
        return this.ownerProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayerProfile(@Nullable GameProfile profile) {
        RetinalScannerBlockEntity retinalScannerBlockEntity = this;
        synchronized (retinalScannerBlockEntity) {
            this.ownerProfile = profile;
        }
        this.updatePlayerProfile();
    }

    public void updatePlayerProfile() {
        if (ServerLifecycleHooks.getCurrentServer() != null && mainThreadExecutor == null) {
            RetinalScannerBlockEntity.setMainThreadExecutor((Executor)ServerLifecycleHooks.getCurrentServer());
        }
        this.updateGameProfile(this.ownerProfile, profile -> {
            this.ownerProfile = profile.orElse(this.ownerProfile);
            this.setChanged();
        });
    }

    private void updateGameProfile(GameProfile input, Consumer<Optional<GameProfile>> onChanged) {
        if (((Boolean)ConfigHandler.SERVER.retinalScannerFace.get()).booleanValue() && input != null && !StringUtil.isNullOrEmpty((String)input.getName()) && !input.getProperties().containsKey((Object)"textures") && mainThreadExecutor != null) {
            SkullBlockEntity.fetchGameProfile((String)input.getName()).thenAcceptAsync(onChanged, mainThreadExecutor);
        }
    }

    @Override
    public boolean isConsideredInvisible(LivingEntity entity) {
        return this.respectInvisibility.isConsideredInvisible(entity);
    }
}

