/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IEMPAffectedBE;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.SonicSecuritySystemBlock;
import net.geforcemods.securitycraft.items.SonicSecuritySystemItem;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;

public class SonicSecuritySystemBlockEntity
extends DisguisableBlockEntity
implements ITickingBlockEntity,
IEMPAffectedBE {
    private static final int PING_DELAY = 100;
    private static final int LISTEN_DELAY = 60;
    public static final int MAX_RANGE = 30;
    public static final int MAX_LINKED_BLOCKS = 30;
    private boolean emitsPings = true;
    private int pingCooldown = 100;
    private Option.IntOption signalLength = new Option.IntOption("signalLength", 60, 5, 400, 5);
    private int powerCooldown = 0;
    private float radarRotationDegrees = 0.0f;
    private float oRadarRotationDegrees = 0.0f;
    private Set<BlockPos> linkedBlocks = new HashSet<BlockPos>();
    private boolean isActive = true;
    private boolean isRecording = false;
    private ArrayList<NoteWrapper> recordedNotes = new ArrayList();
    private boolean wasCorrectTunePlayed = false;
    private boolean isListening = false;
    private int listeningTimer = 60;
    private int listenPos = 0;
    private boolean tracked = false;
    private boolean shutDown = false;
    private boolean disableBlocksWhenTuneIsPlayed = false;

    public SonicSecuritySystemBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.SONIC_SECURITY_SYSTEM_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!this.tracked) {
            BlockEntityTracker.SONIC_SECURITY_SYSTEM.track(this);
            this.tracked = true;
        }
        if (!level.isClientSide) {
            if (!this.isActive()) {
                return;
            }
            if (this.wasCorrectTunePlayed) {
                if (this.powerCooldown > 0) {
                    --this.powerCooldown;
                } else {
                    this.wasCorrectTunePlayed = false;
                    level.setBlockAndUpdate(this.worldPosition, (BlockState)level.getBlockState(this.worldPosition).setValue((Property)SonicSecuritySystemBlock.POWERED, (Comparable)Boolean.valueOf(false)));
                    BlockUtils.updateIndirectNeighbors(level, this.worldPosition, (Block)SCContent.SONIC_SECURITY_SYSTEM.get(), Direction.DOWN);
                }
            }
            if (this.isListening) {
                if (this.listeningTimer > 0) {
                    --this.listeningTimer;
                    return;
                }
                this.stopListening();
            }
            if (!this.isLinkedToBlock()) {
                return;
            }
            if (this.pingCooldown > 0) {
                --this.pingCooldown;
            } else {
                ArrayList<BlockPos> blocksToRemove = new ArrayList<BlockPos>();
                for (BlockPos blockPos : this.linkedBlocks) {
                    if (level.getBlockEntity(blockPos) instanceof ILockable) continue;
                    blocksToRemove.add(blockPos);
                }
                for (BlockPos posToRemove : blocksToRemove) {
                    this.delink(posToRemove, false);
                    this.sync();
                }
                if (this.emitsPings && !this.isRecording) {
                    level.playSound(null, this.worldPosition, SCSounds.PING.event, SoundSource.BLOCKS, 0.3f, 1.0f);
                }
                this.pingCooldown = 100;
            }
        } else {
            this.oRadarRotationDegrees = this.getRadarRotationDegrees();
            if (this.isActive() || this.isRecording()) {
                this.radarRotationDegrees = this.getRadarRotationDegrees() + 0.15f;
                if (this.getRadarRotationDegrees() >= 360.0f) {
                    this.radarRotationDegrees = 0.0f;
                }
            }
        }
    }

    @Override
    public void setRemoved() {
        super.setRemoved();
        BlockEntityTracker.SONIC_SECURITY_SYSTEM.stopTracking(this);
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        if (module == ModuleType.REDSTONE) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)SonicSecuritySystemBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors(this.level, this.worldPosition, (Block)SCContent.SONIC_SECURITY_SYSTEM.get(), Direction.DOWN);
        }
        super.onModuleRemoved(stack, module, toggled);
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        if (!this.linkedBlocks.isEmpty() && !tag.contains("LinkedBlocks")) {
            tag.put("LinkedBlocks", (Tag)new ListTag());
        }
        for (BlockPos blockToSave : this.linkedBlocks) {
            CompoundTag nbt = NbtUtils.writeBlockPos((BlockPos)blockToSave);
            tag.getList("LinkedBlocks", 10).add((Object)nbt);
            if (this.linkedBlocks.contains(blockToSave)) continue;
            this.linkedBlocks.add(blockToSave);
        }
        this.saveNotes(tag);
        tag.putBoolean("emitsPings", this.emitsPings);
        tag.putBoolean("isActive", this.isActive);
        tag.putBoolean("isRecording", this.isRecording);
        tag.putBoolean("isListening", this.isListening);
        tag.putInt("listenPos", this.listenPos);
        tag.putBoolean("correctTuneWasPlayed", this.wasCorrectTunePlayed);
        tag.putInt("powerCooldown", this.powerCooldown);
        tag.putBoolean("shutDown", this.shutDown);
        tag.putBoolean("disableBlocksWhenTuneIsPlayed", this.disableBlocksWhenTuneIsPlayed);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        if (tag.contains("LinkedBlocks")) {
            ListTag list = tag.getList("LinkedBlocks", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag linkedBlock = list.getCompound(i);
                BlockPos linkedBlockPos = NbtUtils.readBlockPos((CompoundTag)linkedBlock);
                this.linkedBlocks.add(linkedBlockPos);
            }
        }
        this.recordedNotes.clear();
        SonicSecuritySystemBlockEntity.loadNotes(tag, this.recordedNotes);
        if (tag.contains("emitsPings")) {
            this.emitsPings = tag.getBoolean("emitsPings");
        }
        if (tag.contains("isActive")) {
            this.isActive = tag.getBoolean("isActive");
        }
        this.isRecording = tag.getBoolean("isRecording");
        this.isListening = tag.getBoolean("isListening");
        this.listenPos = tag.getInt("listenPos");
        this.wasCorrectTunePlayed = tag.getBoolean("correctTuneWasPlayed");
        this.powerCooldown = tag.getInt("powerCooldown");
        this.shutDown = tag.getBoolean("shutDown");
        this.disableBlocksWhenTuneIsPlayed = tag.getBoolean("disableBlocksWhenTuneIsPlayed");
    }

    public void saveNotes(CompoundTag tag) {
        ListTag notes = new ListTag();
        for (NoteWrapper note : this.recordedNotes) {
            CompoundTag noteNbt = new CompoundTag();
            noteNbt.putInt("noteID", note.noteID);
            noteNbt.putString("instrument", note.instrumentName);
            noteNbt.putString("customSoundId", note.customSoundId);
            notes.add((Object)noteNbt);
        }
        tag.put("Notes", (Tag)notes);
    }

    public static <T extends Collection<NoteWrapper>> void loadNotes(CompoundTag tag, T recordedNotes) {
        if (tag.contains("Notes")) {
            ListTag list = tag.getList("Notes", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag note = list.getCompound(i);
                recordedNotes.add((NoteWrapper)new NoteWrapper(note.getInt("noteID"), note.getString("instrument"), note.getString("customSoundId")));
            }
        }
    }

    public boolean transferPositionsFromItem(CompoundTag itemTag) {
        Set<BlockPos> positions = SonicSecuritySystemItem.stackTagToBlockPosSet(itemTag);
        positions.removeIf(this::isLinkedToBlock);
        this.linkedBlocks.addAll(positions);
        if (!this.linkedBlocks.isEmpty()) {
            this.sync();
        }
        return true;
    }

    public boolean isLinkedToBlock() {
        return !this.linkedBlocks.isEmpty();
    }

    public boolean isLinkedToBlock(BlockPos linkedBlockPos) {
        if (this.linkedBlocks.isEmpty()) {
            return false;
        }
        return this.linkedBlocks.contains(linkedBlockPos);
    }

    public void delink(BlockPos linkedBlockPos, boolean shouldSync) {
        if (this.linkedBlocks.isEmpty()) {
            return;
        }
        this.linkedBlocks.remove(linkedBlockPos);
        if (shouldSync) {
            this.sync();
        }
    }

    public void delinkAll() {
        this.linkedBlocks.clear();
        this.sync();
    }

    public int getNumberOfLinkedBlocks() {
        return this.linkedBlocks.size();
    }

    public Set<BlockPos> getLinkedBlocks() {
        return this.linkedBlocks;
    }

    public boolean pings() {
        return this.emitsPings;
    }

    public void setPings(boolean pings) {
        this.emitsPings = pings;
    }

    public boolean isActive() {
        return this.isActive && !this.isShutDown();
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public void setRecording(boolean recording) {
        this.isRecording = recording;
    }

    public boolean isListening() {
        return this.isListening;
    }

    public void startListening() {
        this.isListening = true;
    }

    public void stopListening() {
        this.resetListeningTimer();
        this.listenPos = 0;
        this.isListening = false;
        this.level.blockUpdated(this.worldPosition, (Block)SCContent.SONIC_SECURITY_SYSTEM.get());
        if (!this.level.isClientSide) {
            this.sync();
        }
    }

    public void resetListeningTimer() {
        this.listeningTimer = 60;
    }

    public void recordNote(int noteID, NoteBlockInstrument instrument, String customSoundId) {
        this.recordedNotes.add(new NoteWrapper(noteID, instrument.getSerializedName(), customSoundId));
        if (!this.level.isClientSide) {
            this.sync();
        }
    }

    public void listenToNote(int noteID, NoteBlockInstrument instrument, String customSoundId) {
        if (this.getNumberOfNotes() == 0 || this.listenPos >= this.getNumberOfNotes()) {
            return;
        }
        if (!this.isListening) {
            this.isListening = true;
            this.sync();
        }
        if (this.recordedNotes.get(this.listenPos++).isSameNote(noteID, instrument, customSoundId)) {
            this.resetListeningTimer();
            if (this.listenPos >= this.recordedNotes.size()) {
                this.wasCorrectTunePlayed = true;
                this.powerCooldown = (Integer)this.signalLength.get();
                if (this.isModuleEnabled(ModuleType.REDSTONE)) {
                    this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getLevel().getBlockState(this.getBlockPos()).setValue((Property)SonicSecuritySystemBlock.POWERED, (Comparable)Boolean.valueOf(true)));
                    BlockUtils.updateIndirectNeighbors(this.getLevel(), this.getBlockPos(), (Block)SCContent.SONIC_SECURITY_SYSTEM.get(), Direction.DOWN);
                }
            }
        }
    }

    public List<NoteWrapper> getRecordedNotes() {
        return this.recordedNotes;
    }

    public int getNumberOfNotes() {
        return this.recordedNotes.size();
    }

    public void clearNotes() {
        this.recordedNotes.clear();
    }

    private void sync() {
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    @Override
    public boolean isShutDown() {
        return this.shutDown;
    }

    @Override
    public void setShutDown(boolean shutDown) {
        this.shutDown = shutDown;
    }

    public void setDisableBlocksWhenTuneIsPlayed(boolean disableBlocksWhenTuneIsPlayed) {
        this.disableBlocksWhenTuneIsPlayed = disableBlocksWhenTuneIsPlayed;
    }

    public boolean disablesBlocksWhenTuneIsPlayed() {
        return this.disableBlocksWhenTuneIsPlayed;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.REDSTONE, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.signalLength};
    }

    public boolean wasCorrectTunePlayed() {
        return this.wasCorrectTunePlayed;
    }

    public float getOriginalRadarRotationDegrees() {
        return this.oRadarRotationDegrees;
    }

    public float getRadarRotationDegrees() {
        return this.radarRotationDegrees;
    }

    public record NoteWrapper(int noteID, String instrumentName, String customSoundId) {
        public boolean isSameNote(int note, NoteBlockInstrument instrument, String customSoundId) {
            return !(!this.instrumentName.equals(instrument.getSerializedName()) || instrument.isTunable() && this.noteID != note || !this.customSoundId.isEmpty() && !this.customSoundId.equals(customSoundId));
        }
    }
}

