/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.UpdateLogger;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.network.PacketDistributor;

public class UsernameLoggerBlockEntity
extends DisguisableBlockEntity
implements ITickingBlockEntity,
ILockable {
    private static final int TICKS_BETWEEN_ATTACKS = 80;
    private Option.IntOption searchRadius = new Option.IntOption("searchRadius", 3, 1, 20, 1);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private Option.RespectInvisibilityOption respectInvisibility = new Option.RespectInvisibilityOption();
    private Option.IntOption repeatedLogInterval = new Option.IntOption("repeatedLogInterval", 1, 1, 120, 1);
    private String[] players = new String[100];
    private String[] uuids = new String[100];
    private long[] timestamps = new long[100];
    private int cooldown = 80;

    public UsernameLoggerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.USERNAME_LOGGER_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (this.isDisabled()) {
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        } else if (level.getBestNeighborSignal(pos) > 0) {
            long timestamp = System.currentTimeMillis();
            List nearbyPlayers = level.getEntitiesOfClass(Player.class, new AABB(pos).inflate((double)((Integer)this.searchRadius.get()).intValue()), e -> e.canBeSeenByAnyone() && (!this.isOwnedBy((Entity)e) || !this.ignoresOwner()) && !this.isAllowed((Entity)e) && !this.respectInvisibility.isConsideredInvisible((LivingEntity)e) && !this.wasPlayerRecentlyAdded(e.getName().getString(), timestamp));
            if (!nearbyPlayers.isEmpty()) {
                boolean changed = false;
                int playerIndex = 0;
                for (int i = 0; i < this.getPlayers().length && playerIndex < nearbyPlayers.size(); ++i) {
                    if (this.getPlayers()[i] != null && !this.getPlayers()[i].equals("")) continue;
                    Player player = (Player)nearbyPlayers.get(playerIndex++);
                    this.getPlayers()[i] = player.getName().getString();
                    this.getUuids()[i] = player.getGameProfile().getId().toString();
                    this.getTimestamps()[i] = timestamp;
                    changed = true;
                }
                if (changed) {
                    this.setChanged();
                    this.syncLoggedPlayersToClient();
                }
            }
            this.cooldown = 80;
        }
    }

    private boolean wasPlayerRecentlyAdded(String username, long timestamp) {
        long timeout = (long)((Integer)this.repeatedLogInterval.get()).intValue() * 1000L;
        for (int i = 0; i < this.getPlayers().length; ++i) {
            if (this.getPlayers()[i] == null || !this.getPlayers()[i].equals(username) || this.getTimestamps()[i] + timeout <= timestamp) continue;
            return true;
        }
        return false;
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        for (int i = 0; i < this.getPlayers().length; ++i) {
            tag.putString("player" + i, this.getPlayers()[i] == null ? "" : this.getPlayers()[i]);
            tag.putString("uuid" + i, this.getUuids()[i] == null ? "" : this.getUuids()[i]);
            tag.putLong("timestamp" + i, this.getTimestamps()[i]);
        }
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        for (int i = 0; i < this.getPlayers().length; ++i) {
            this.getPlayers()[i] = tag.getString("player" + i);
            this.getUuids()[i] = tag.getString("uuid" + i);
            this.getTimestamps()[i] = tag.getLong("timestamp" + i);
        }
    }

    public void syncLoggedPlayersToClient() {
        for (int i = 0; i < this.getPlayers().length; ++i) {
            if (this.getPlayers()[i] == null) continue;
            PacketDistributor.TRACKING_CHUNK.with((Object)this.level.getChunkAt(this.worldPosition)).send(new CustomPacketPayload[]{new UpdateLogger(this.worldPosition, i, this.getPlayers()[i], this.getUuids()[i], this.getTimestamps()[i])});
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE, ModuleType.ALLOWLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.searchRadius, this.disabled, this.ignoreOwner, this.respectInvisibility, this.repeatedLogInterval};
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    @Override
    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    public String[] getPlayers() {
        return this.players;
    }

    public void setPlayers(String[] players) {
        this.players = players;
    }

    public String[] getUuids() {
        return this.uuids;
    }

    public long[] getTimestamps() {
        return this.timestamps;
    }
}

