/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.BlockPocketBlockEntity;
import net.geforcemods.securitycraft.blockentities.BlockPocketManagerBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.util.IBlockPocket;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockPocketWallBlock
extends OwnableBlock
implements IBlockPocket {
    public static final BooleanProperty SEE_THROUGH = BooleanProperty.create((String)"see_through");
    public static final BooleanProperty SOLID = BooleanProperty.create((String)"solid");

    public BlockPocketWallBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SEE_THROUGH, (Comparable)Boolean.valueOf(true))).setValue((Property)SOLID, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean causesSuffocation(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)SOLID);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext collisionContext) {
        EntityCollisionContext ctx;
        Entity entity;
        if (!((Boolean)state.getValue((Property)SOLID)).booleanValue() && collisionContext instanceof EntityCollisionContext && (entity = (ctx = (EntityCollisionContext)collisionContext).getEntity()) instanceof Player) {
            BlockPocketBlockEntity be;
            Player player = (Player)entity;
            entity = level.getBlockEntity(pos);
            if (entity instanceof BlockPocketBlockEntity && ((be = (BlockPocketBlockEntity)entity).isOwnedBy((Entity)player) || be.getManager() == null || be.getManager().isAllowed((Entity)player))) {
                return Shapes.empty();
            }
        }
        return Shapes.block();
    }

    public boolean isValidSpawn(BlockState state, BlockGetter level, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return false;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockPocketBlockEntity be;
        BlockPocketManagerBlockEntity manager;
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof BlockPocketBlockEntity && (manager = (be = (BlockPocketBlockEntity)blockEntity).getManager()) != null) {
            manager.disableMultiblock();
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        return (Boolean)state.getValue((Property)SEE_THROUGH) != false && adjacentBlockState.getBlock() == SCContent.BLOCK_POCKET_WALL.get();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)SEE_THROUGH, (Comparable)Boolean.valueOf(true));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SEE_THROUGH, SOLID});
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BlockPocketBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockPocketWallBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)SCContent.BLOCK_POCKET_BLOCK_ENTITY.get()), LevelUtils::blockEntityTicker);
    }
}

