/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Map;
import net.geforcemods.securitycraft.blockentities.ElectrifiedFenceAndGateBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ElectrifiedIronFenceBlock
extends OwnableBlock {
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    protected static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)PipeBlock.PROPERTY_BY_DIRECTION.entrySet().stream().filter(entry -> ((Direction)entry.getKey()).getAxis().isHorizontal()).collect(Util.toMap());
    protected final VoxelShape[] collisionShapes;
    protected final VoxelShape[] shapes;
    private final VoxelShape[] renderShapes;

    public ElectrifiedIronFenceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
        this.renderShapes = this.makeShapes(2.0f, 1.0f, 16.0f, 6.0f, 15.0f);
        this.collisionShapes = this.makeShapes(2.0f, 2.0f, 24.0f, 0.0f, 24.0f);
        this.shapes = this.makeShapes(2.0f, 2.0f, 16.0f, 0.0f, 16.0f);
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return this.renderShapes[this.getIndex(state)];
    }

    protected VoxelShape[] makeShapes(float nodeWith, float extensionWidth, float nodeHeight, float extensionBottom, float extensionHeight) {
        float f = 8.0f - nodeWith;
        float f1 = 8.0f + nodeWith;
        float f2 = 8.0f - extensionWidth;
        float f3 = 8.0f + extensionWidth;
        VoxelShape voxelshape = Block.box((double)f, (double)0.0, (double)f, (double)f1, (double)nodeHeight, (double)f1);
        VoxelShape voxelshape1 = Block.box((double)f2, (double)extensionBottom, (double)0.0, (double)f3, (double)extensionHeight, (double)f3);
        VoxelShape voxelshape2 = Block.box((double)f2, (double)extensionBottom, (double)f2, (double)f3, (double)extensionHeight, (double)16.0);
        VoxelShape voxelshape3 = Block.box((double)0.0, (double)extensionBottom, (double)f2, (double)f3, (double)extensionHeight, (double)f3);
        VoxelShape voxelshape4 = Block.box((double)f2, (double)extensionBottom, (double)f2, (double)16.0, (double)extensionHeight, (double)f3);
        VoxelShape voxelshape5 = Shapes.or((VoxelShape)voxelshape1, (VoxelShape)voxelshape4);
        VoxelShape voxelshape6 = Shapes.or((VoxelShape)voxelshape2, (VoxelShape)voxelshape3);
        VoxelShape[] returnValue = new VoxelShape[]{Shapes.empty(), voxelshape2, voxelshape3, voxelshape6, voxelshape1, Shapes.or((VoxelShape)voxelshape2, (VoxelShape)voxelshape1), Shapes.or((VoxelShape)voxelshape3, (VoxelShape)voxelshape1), Shapes.or((VoxelShape)voxelshape6, (VoxelShape)voxelshape1), voxelshape4, Shapes.or((VoxelShape)voxelshape2, (VoxelShape)voxelshape4), Shapes.or((VoxelShape)voxelshape3, (VoxelShape)voxelshape4), Shapes.or((VoxelShape)voxelshape6, (VoxelShape)voxelshape4), voxelshape5, Shapes.or((VoxelShape)voxelshape2, (VoxelShape)voxelshape5), Shapes.or((VoxelShape)voxelshape3, (VoxelShape)voxelshape5), Shapes.or((VoxelShape)voxelshape6, (VoxelShape)voxelshape5)};
        for (int i = 0; i < 16; ++i) {
            returnValue[i] = Shapes.or((VoxelShape)voxelshape, (VoxelShape)returnValue[i]);
        }
        return returnValue;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.shapes[this.getIndex(state)];
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.collisionShapes[this.getIndex(state)];
    }

    public boolean connectsTo(BlockState state, boolean isFaceSturdy, Direction direction) {
        Block block = state.getBlock();
        boolean isFence = state.is(BlockTags.FENCES) && !state.is(BlockTags.WOODEN_FENCES);
        boolean isFenceGate = block instanceof FenceGateBlock && FenceGateBlock.connectsToDirection((BlockState)state, (Direction)direction);
        return !ElectrifiedIronFenceBlock.isExceptionForConnection((BlockState)state) && isFaceSturdy || isFence || isFenceGate;
    }

    private static int getMask(Direction facing) {
        return 1 << facing.get2DDataValue();
    }

    protected int getIndex(BlockState state) {
        int i = 0;
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            i |= ElectrifiedIronFenceBlock.getMask(Direction.NORTH);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            i |= ElectrifiedIronFenceBlock.getMask(Direction.EAST);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            i |= ElectrifiedIronFenceBlock.getMask(Direction.SOUTH);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            i |= ElectrifiedIronFenceBlock.getMask(Direction.WEST);
        }
        return i;
    }

    public boolean isPathfindable(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return switch (rot) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)NORTH)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)SOUTH)));
            default -> state;
        };
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)EAST)));
            default -> super.mirror(state, mirror);
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level level = ctx.getLevel();
        BlockPos clickedPos = ctx.getClickedPos();
        BlockPos northPos = clickedPos.north();
        BlockPos eastPos = clickedPos.east();
        BlockPos southPos = clickedPos.south();
        BlockPos westPos = clickedPos.west();
        BlockState northState = level.getBlockState(northPos);
        BlockState eastState = level.getBlockState(eastPos);
        BlockState southState = level.getBlockState(southPos);
        BlockState westState = level.getBlockState(westPos);
        return (BlockState)((BlockState)((BlockState)((BlockState)super.getStateForPlacement(ctx).setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.connectsTo(northState, northState.isFaceSturdy((BlockGetter)level, northPos, Direction.SOUTH), Direction.SOUTH)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.connectsTo(eastState, eastState.isFaceSturdy((BlockGetter)level, eastPos, Direction.WEST), Direction.WEST)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.connectsTo(southState, southState.isFaceSturdy((BlockGetter)level, southPos, Direction.NORTH), Direction.NORTH)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.connectsTo(westState, westState.isFaceSturdy((BlockGetter)level, westPos, Direction.EAST), Direction.EAST)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, WEST, SOUTH});
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing.getAxis().getPlane() == Direction.Plane.HORIZONTAL ? (BlockState)state.setValue((Property)FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(this.connectsTo(facingState, facingState.isFaceSturdy((BlockGetter)level, facingPos, facing.getOpposite()), facing.getOpposite()))) : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return InteractionResult.FAIL;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        ElectrifiedIronFenceBlock.hurtOrConvertEntity((Block)this, state, level, pos, entity);
    }

    public static void hurtOrConvertEntity(Block electrifiedBlock, BlockState state, Level level, BlockPos pos, Entity entity) {
        if (level.getGameTime() % 20L != 0L) {
            return;
        }
        if (entity.isRemoved() || !electrifiedBlock.getShape(state, (BlockGetter)level, pos, CollisionContext.of((Entity)entity)).bounds().move(pos).inflate(0.01).intersects(entity.getBoundingBox())) {
            return;
        }
        if (entity instanceof ItemEntity) {
            return;
        }
        ElectrifiedFenceAndGateBlockEntity be = (ElectrifiedFenceAndGateBlockEntity)level.getBlockEntity(pos);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (be.isOwnedBy((Entity)player) || be.isAllowed((Entity)player)) {
                return;
            }
        } else if (entity instanceof OwnableEntity) {
            OwnableEntity ownableEntity = (OwnableEntity)entity;
            if (be.allowsOwnableEntity(ownableEntity)) {
                return;
            }
        } else if (!level.isClientSide) {
            LightningBolt lightning = LevelUtils.createLightning(level, Vec3.atBottomCenterOf((Vec3i)pos), true);
            entity.thunderHit((ServerLevel)level, lightning);
            entity.clearFire();
            return;
        }
        entity.hurt(CustomDamageSources.electricity(level.registryAccess()), 6.0f);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ElectrifiedFenceAndGateBlockEntity(pos, state);
    }
}

