/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.blockentities.AbstractKeypadFurnaceBlockEntity;
import net.geforcemods.securitycraft.blockentities.KeypadBlastFurnaceBlockEntity;
import net.geforcemods.securitycraft.blocks.AbstractKeypadFurnaceBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class KeypadBlastFurnaceBlock
extends AbstractKeypadFurnaceBlock {
    public KeypadBlastFurnaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue() && IDisguisable.getDisguisedStateOrDefault(state, (BlockGetter)level, pos).getBlock() == this) {
            double x = (double)pos.getX() + 0.5;
            double y = pos.getY();
            double z = (double)pos.getZ() + 0.5;
            if (random.nextDouble() < 0.1) {
                level.playLocalSound(x, y, z, SoundEvents.BLASTFURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
                Direction direction = (Direction)state.getValue((Property)FACING);
                Direction.Axis axis = direction.getAxis();
                double randomNumber = random.nextDouble() * 0.6 - 0.3;
                double xOffset = axis == Direction.Axis.X ? (double)direction.getStepX() * 0.32 : randomNumber;
                double yOffset = random.nextDouble() * 9.0 / 16.0;
                double zOffset = axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.32 : randomNumber;
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
            }
        }
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : KeypadBlastFurnaceBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)SCContent.KEYPAD_BLAST_FURNACE_BLOCK_ENTITY.get()), AbstractKeypadFurnaceBlockEntity::serverTick);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new KeypadBlastFurnaceBlockEntity(pos, state);
    }
}

