/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.INameSetter;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;

public abstract class SpecialDoorBlock
extends DoorBlock
implements EntityBlock,
IDisguisable,
IOverlayDisplay {
    private final float destroyTimeForOwner = OwnableBlock.getStoredDestroyTime();

    protected SpecialDoorBlock(BlockBehaviour.Properties properties, BlockSetType blockSetType) {
        super(blockSetType, OwnableBlock.withReinforcedDestroyTime(properties));
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.getDestroyProgress(x$0, x$1, x$2, x$3), this.destroyTimeForOwner, state, player, level, pos);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return (Boolean)ConfigHandler.SERVER.alwaysDrop.get() != false || super.canHarvestBlock(state, level, pos, player);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.getBlock() != this) {
            return disguisedState.getShape(level, pos, ctx);
        }
        return super.getShape(state, level, pos, ctx);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.getBlock() != this) {
            if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
                return Shapes.empty();
            }
            return disguisedState.getShape(level, pos, ctx);
        }
        return super.getShape(state, level, pos, ctx);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IOwnable) {
            IOwnable lowerBe = (IOwnable)blockEntity;
            blockEntity = level.getBlockEntity(pos.above());
            if (blockEntity instanceof IOwnable) {
                IOwnable upperBe = (IOwnable)blockEntity;
                if (placer instanceof Player) {
                    Player player = (Player)placer;
                    lowerBe.setOwner(player.getGameProfile().getId().toString(), player.getName().getString());
                    upperBe.setOwner(player.getGameProfile().getId().toString(), player.getName().getString());
                }
                if (lowerBe instanceof LinkableBlockEntity) {
                    LinkableBlockEntity linkable1 = (LinkableBlockEntity)lowerBe;
                    if (upperBe instanceof LinkableBlockEntity) {
                        LinkableBlockEntity linkable2 = (LinkableBlockEntity)upperBe;
                        LinkableBlockEntity.link(linkable1, linkable2);
                    }
                }
                if (stack.hasCustomHoverName() && lowerBe instanceof INameSetter) {
                    INameSetter nameSetter1 = (INameSetter)((Object)lowerBe);
                    if (upperBe instanceof INameSetter) {
                        INameSetter nameSetter2 = (INameSetter)((Object)upperBe);
                        nameSetter1.setCustomName(stack.getHoverName());
                        nameSetter2.setCustomName(stack.getHoverName());
                    }
                }
            }
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos upperPos, RandomSource rand) {
        BlockState lowerState;
        BlockPos lowerPos;
        BlockState upperState = level.getBlockState(upperPos);
        if (!((Boolean)upperState.getValue((Property)DoorBlock.OPEN)).booleanValue()) {
            return;
        }
        if (upperState.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.LOWER) {
            lowerPos = upperPos;
            lowerState = upperState;
            upperPos = upperPos.above();
            upperState = level.getBlockState(upperPos);
        } else {
            lowerPos = upperPos.below();
            lowerState = level.getBlockState(lowerPos);
        }
        level.setBlockAndUpdate(upperPos, (BlockState)upperState.setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.valueOf(false)));
        level.setBlockAndUpdate(lowerPos, (BlockState)lowerState.setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.valueOf(false)));
        this.playSound(null, (Level)level, upperPos, false);
        level.gameEvent(null, GameEvent.BLOCK_CLOSE, upperPos);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (player.isCreative() && (blockEntity = level.getBlockEntity(pos)) instanceof IModuleInventory) {
            IModuleInventory inv = (IModuleInventory)blockEntity;
            inv.getInventory().clear();
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = super.getStateForPlacement(ctx);
        return state == null ? null : (BlockState)((BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity be = level.getBlockEntity(pos);
            if (!((Boolean)ConfigHandler.SERVER.vanillaToolBlockBreaking.get()).booleanValue() && be instanceof IModuleInventory) {
                IModuleInventory inv = (IModuleInventory)be;
                if (state.getValue((Property)HALF) == DoubleBlockHalf.LOWER) {
                    inv.dropAllModules();
                }
            }
            if (be instanceof IPasscodeProtected) {
                IPasscodeProtected passcodeProtected = (IPasscodeProtected)be;
                SaltData.removeSalt(passcodeProtected.getSaltKey());
            }
            if (be instanceof LinkableBlockEntity) {
                LinkableBlockEntity linkable = (LinkableBlockEntity)be;
                LinkableBlockEntity.unlinkFromAllLinked(linkable);
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public boolean triggerEvent(BlockState state, Level level, BlockPos pos, int id, int param) {
        BlockEntity be = level.getBlockEntity(pos);
        return be != null && be.triggerEvent(id, param);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        if (IDisguisable.shouldPickBlockDisguise((BlockGetter)level, pos, player)) {
            return this.getDisguisedStack((BlockGetter)level, pos);
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    @Override
    public ItemStack getDefaultStack() {
        return new ItemStack((ItemLike)this.getDoorItem());
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        AuxiliaryLightManager lightManager = level.getAuxLightManager(pos);
        int lightValue = 0;
        if (lightManager != null) {
            lightValue = lightManager.getLightAt(pos);
        }
        return lightValue > 0 ? lightValue : super.getLightEmission(state, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, (BlockGetter)level, pos);
        if (disguisedState.getBlock() != this) {
            return disguisedState.getSoundType(level, pos, entity);
        }
        return super.getSoundType(state, level, pos, entity);
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.getBlock() != this) {
            return disguisedState.getShadeBrightness(level, pos);
        }
        return super.getShadeBrightness(state, level, pos);
    }

    public int getLightBlock(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.getBlock() != this) {
            return disguisedState.getLightBlock(level, pos);
        }
        return super.getLightBlock(state, level, pos);
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, BlockState queryState, BlockPos queryPos) {
        return IDisguisable.getDisguisedStateOrDefault(state, (BlockGetter)level, pos);
    }

    @Override
    public ItemStack getDisplayStack(Level level, BlockState state, BlockPos pos) {
        return this.getDisguisedStack((BlockGetter)level, pos);
    }

    @Override
    public boolean shouldShowSCInfo(Level level, BlockState state, BlockPos pos) {
        return this.getDisguisedStack((BlockGetter)level, pos).getItem() == this.asItem();
    }

    public boolean hasDynamicLightEmission(BlockState state) {
        return true;
    }

    public abstract Item getDoorItem();
}

