/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.blockentities.BrushableMineBlockEntity;
import net.geforcemods.securitycraft.blocks.mines.FallingBlockMineBlock;
import net.geforcemods.securitycraft.util.IBlockMine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class BrushableMineBlock
extends FallingBlockMineBlock
implements IBlockMine {
    public static final IntegerProperty DUSTED = BlockStateProperties.DUSTED;
    public static final BooleanProperty SAFE = BooleanProperty.create((String)"safe");

    public BrushableMineBlock(BlockBehaviour.Properties properties, Block disguisedBlock) {
        super(properties, disguisedBlock);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DUSTED, (Comparable)Integer.valueOf(0))).setValue((Property)SAFE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean isDefusable() {
        return true;
    }

    @Override
    public boolean isActive(Level level, BlockPos pos) {
        return (Boolean)level.getBlockState(pos).getValue((Property)SAFE) == false;
    }

    @Override
    public boolean defuseMine(Level level, BlockPos pos) {
        level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)SAFE, (Comparable)Boolean.valueOf(true)));
        return true;
    }

    @Override
    public boolean activateMine(Level level, BlockPos pos) {
        level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)SAFE, (Comparable)Boolean.valueOf(false)));
        return true;
    }

    @Override
    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BrushableMineBlockEntity) {
            BrushableMineBlockEntity be = (BrushableMineBlockEntity)blockEntity;
            be.checkReset();
        }
        if (FallingBlock.isFree((BlockState)level.getBlockState(pos.below())) && pos.getY() >= level.getMinBuildHeight()) {
            FallingBlockEntity.fall((Level)level, (BlockPos)pos, (BlockState)state).disableDrop();
        }
    }

    public void onBrokenAfterFall(Level level, BlockPos pos, FallingBlockEntity be) {
        Vec3 vec3 = be.getBoundingBox().getCenter();
        level.levelEvent(2001, BlockPos.containing((Position)vec3), Block.getId((BlockState)be.getBlockState()));
        level.gameEvent((Entity)be, GameEvent.BLOCK_DESTROY, vec3);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BrushableMineBlockEntity(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DUSTED, SAFE});
    }

    @Override
    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, BlockState queryState, BlockPos queryPos) {
        return (BlockState)this.getBlockDisguisedAs().defaultBlockState().setValue((Property)DUSTED, (Comparable)((Integer)state.getValue((Property)DUSTED)));
    }

    public Block getTurnsInto() {
        return ((BrushableBlock)this.getBlockDisguisedAs()).getTurnsInto();
    }
}

