/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Predicate;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.blockentities.ReinforcedCauldronBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedLavaCauldronBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedLayeredCauldronBlock;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class ReinforcedCauldronBlock
extends AbstractCauldronBlock
implements IReinforcedBlock,
EntityBlock {
    public static final MapCodec<ReinforcedCauldronBlock> CODEC = ReinforcedCauldronBlock.simpleCodec(ReinforcedCauldronBlock::new);
    private final float destroyTimeForOwner = OwnableBlock.getStoredDestroyTime();

    public ReinforcedCauldronBlock(BlockBehaviour.Properties properties) {
        this(properties, IReinforcedCauldronInteraction.EMPTY);
    }

    public ReinforcedCauldronBlock(BlockBehaviour.Properties properties, CauldronInteraction.InteractionMap interactions) {
        super(OwnableBlock.withReinforcedDestroyTime(properties), interactions);
    }

    protected MapCodec<? extends AbstractCauldronBlock> codec() {
        return CODEC;
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.getDestroyProgress(x$0, x$1, x$2, x$3), this.destroyTimeForOwner, state, player, level, pos);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return (Boolean)ConfigHandler.SERVER.alwaysDrop.get() != false || super.canHarvestBlock(state, level, pos, player);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext collisionContext) {
        Entity entity;
        EntityCollisionContext ctx;
        if (collisionContext instanceof EntityCollisionContext && (ctx = (EntityCollisionContext)collisionContext).getEntity() != null && (entity = ctx.getEntity()) instanceof Player) {
            ReinforcedCauldronBlockEntity be;
            Player player = (Player)entity;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof ReinforcedCauldronBlockEntity && (be = (ReinforcedCauldronBlockEntity)blockEntity).isAllowedToInteract(player)) {
                return SHAPE;
            }
            return Shapes.block();
        }
        return SHAPE;
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ReinforcedCauldronBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ReinforcedCauldronBlockEntity && (be = (ReinforcedCauldronBlockEntity)blockEntity).isAllowedToInteract(player)) {
            return super.use(state, level, pos, player, hand, hit);
        }
        return InteractionResult.PASS;
    }

    public boolean isFull(BlockState state) {
        return false;
    }

    protected static boolean shouldHandlePrecipitation(Level level, Biome.Precipitation precipitation) {
        return switch (precipitation) {
            case Biome.Precipitation.RAIN -> {
                if (level.getRandom().nextFloat() < 0.05f) {
                    yield true;
                }
                yield false;
            }
            case Biome.Precipitation.SNOW -> {
                if (level.getRandom().nextFloat() < 0.1f) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public void handlePrecipitation(BlockState state, Level level, BlockPos pos, Biome.Precipitation precipitation) {
        if (ReinforcedCauldronBlock.shouldHandlePrecipitation(level, precipitation)) {
            BlockState newCauldronState = null;
            if (precipitation == Biome.Precipitation.RAIN) {
                newCauldronState = ((ReinforcedLayeredCauldronBlock)SCContent.REINFORCED_WATER_CAULDRON.get()).defaultBlockState();
            } else if (precipitation == Biome.Precipitation.SNOW) {
                newCauldronState = ((ReinforcedLayeredCauldronBlock)SCContent.REINFORCED_POWDER_SNOW_CAULDRON.get()).defaultBlockState();
            }
            if (newCauldronState != null) {
                ReinforcedCauldronBlock.updateBlockState(level, pos, newCauldronState);
                level.gameEvent(null, GameEvent.BLOCK_CHANGE, pos);
            }
        }
    }

    protected boolean canReceiveStalactiteDrip(Fluid fluid) {
        return true;
    }

    protected void receiveStalactiteDrip(BlockState state, Level level, BlockPos pos, Fluid fluid) {
        BlockState newCauldronState = null;
        int levelEvent = 0;
        if (fluid == Fluids.WATER) {
            newCauldronState = ((ReinforcedLayeredCauldronBlock)SCContent.REINFORCED_WATER_CAULDRON.get()).defaultBlockState();
            levelEvent = 1047;
        } else if (fluid == Fluids.LAVA) {
            newCauldronState = ((ReinforcedLavaCauldronBlock)SCContent.REINFORCED_LAVA_CAULDRON.get()).defaultBlockState();
            levelEvent = 1046;
        }
        if (newCauldronState != null) {
            ReinforcedCauldronBlock.updateBlockState(level, pos, newCauldronState);
            level.levelEvent(levelEvent, pos, 0);
            level.gameEvent(GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)newCauldronState));
        }
    }

    @Override
    public Block getVanillaBlock() {
        return Blocks.CAULDRON;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            NeoForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ReinforcedCauldronBlockEntity(pos, state);
    }

    public static void updateBlockState(Level level, BlockPos pos, BlockState newState) {
        ReinforcedCauldronBlock.updateBlockState(level, pos, newState, level.getBlockEntity(pos));
    }

    public static void updateBlockState(Level level, BlockPos pos, BlockState newState, BlockEntity be) {
        CompoundTag tag = null;
        if (be != null) {
            tag = be.saveWithoutMetadata();
        }
        level.setBlockAndUpdate(pos, newState);
        if (tag != null) {
            level.getBlockEntity(pos).load(tag);
        }
    }

    public static interface IReinforcedCauldronInteraction
    extends CauldronInteraction {
        public static final CauldronInteraction.InteractionMap EMPTY = CauldronInteraction.newInteractionMap((String)"reinforced_empty");
        public static final CauldronInteraction.InteractionMap WATER = CauldronInteraction.newInteractionMap((String)"reinforced_water");
        public static final CauldronInteraction.InteractionMap LAVA = CauldronInteraction.newInteractionMap((String)"reinforced_lava");
        public static final CauldronInteraction.InteractionMap POWDER_SNOW = CauldronInteraction.newInteractionMap((String)"reinforced_powder_snow");
        public static final CauldronInteraction FILL_WATER = (state, level, pos, player, hand, stack) -> IReinforcedCauldronInteraction.emptyBucket(level, pos, player, hand, stack, (BlockState)((ReinforcedLayeredCauldronBlock)SCContent.REINFORCED_WATER_CAULDRON.get()).defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3)), SoundEvents.BUCKET_EMPTY);
        public static final CauldronInteraction FILL_LAVA = (state, level, pos, player, hand, stack) -> IReinforcedCauldronInteraction.emptyBucket(level, pos, player, hand, stack, ((ReinforcedLavaCauldronBlock)SCContent.REINFORCED_LAVA_CAULDRON.get()).defaultBlockState(), SoundEvents.BUCKET_EMPTY_LAVA);
        public static final CauldronInteraction FILL_POWDER_SNOW = (state, level, pos, player, hand, stack) -> IReinforcedCauldronInteraction.emptyBucket(level, pos, player, hand, stack, (BlockState)((ReinforcedLayeredCauldronBlock)SCContent.REINFORCED_POWDER_SNOW_CAULDRON.get()).defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3)), SoundEvents.BUCKET_EMPTY_POWDER_SNOW);
        public static final CauldronInteraction SHULKER_BOX = (state, level, pos, player, hand, stack) -> {
            Block block = Block.byItem((Item)stack.getItem());
            if (!(block instanceof ShulkerBoxBlock)) {
                return InteractionResult.PASS;
            }
            if (!level.isClientSide) {
                ItemStack shulker = new ItemStack((ItemLike)Blocks.SHULKER_BOX);
                if (stack.hasTag()) {
                    shulker.setTag(stack.getTag().copy());
                }
                player.setItemInHand(hand, shulker);
                player.awardStat(Stats.CLEAN_SHULKER_BOX);
                ReinforcedLayeredCauldronBlock.lowerFillLevel(state, level, pos);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        };
        public static final CauldronInteraction BANNER = (state, level, pos, player, hand, stack) -> {
            if (BannerBlockEntity.getPatternCount((ItemStack)stack) <= 0) {
                return InteractionResult.PASS;
            }
            if (!level.isClientSide) {
                ItemStack banner = stack.copy();
                banner.setCount(1);
                BannerBlockEntity.removeLastPattern((ItemStack)banner);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                if (stack.isEmpty()) {
                    player.setItemInHand(hand, banner);
                } else if (player.getInventory().add(banner)) {
                    player.inventoryMenu.sendAllDataToRemote();
                } else {
                    player.drop(banner, false);
                }
                player.awardStat(Stats.CLEAN_BANNER);
                ReinforcedLayeredCauldronBlock.lowerFillLevel(state, level, pos);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        };
        public static final CauldronInteraction DYED_ITEM = (state, level, pos, player, hand, stack) -> {
            Item item = stack.getItem();
            if (!(item instanceof DyeableLeatherItem)) {
                return InteractionResult.PASS;
            }
            DyeableLeatherItem leatherItem = (DyeableLeatherItem)item;
            if (!leatherItem.hasCustomColor(stack)) {
                return InteractionResult.PASS;
            }
            if (!level.isClientSide) {
                leatherItem.clearColor(stack);
                player.awardStat(Stats.CLEAN_ARMOR);
                ReinforcedLayeredCauldronBlock.lowerFillLevel(state, level, pos);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        };

        public static void bootStrap() {
            Map emptyMap = EMPTY.map();
            Map waterMap = WATER.map();
            Map lavaMap = LAVA.map();
            Map powderSnowMap = POWDER_SNOW.map();
            Map vanillaWaterMap = CauldronInteraction.WATER.map();
            IReinforcedCauldronInteraction.addDefaultInteractions(emptyMap);
            emptyMap.put(Items.POTION, (state, level, pos, player, hand, stack) -> {
                if (PotionUtils.getPotion((ItemStack)stack) != Potions.WATER) {
                    return InteractionResult.PASS;
                }
                if (!level.isClientSide) {
                    Item item = stack.getItem();
                    player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE)));
                    player.awardStat(Stats.USE_CAULDRON);
                    player.awardStat(Stats.ITEM_USED.get((Object)item));
                    ReinforcedCauldronBlock.updateBlockState(level, pos, ((ReinforcedLayeredCauldronBlock)SCContent.REINFORCED_WATER_CAULDRON.get()).defaultBlockState());
                    level.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.gameEvent(null, GameEvent.FLUID_PLACE, pos);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            });
            IReinforcedCauldronInteraction.addDefaultInteractions(waterMap);
            waterMap.put(Items.BUCKET, (state, level, pos, player, hand, stack) -> IReinforcedCauldronInteraction.fillBucket(state, level, pos, player, hand, stack, new ItemStack((ItemLike)Items.WATER_BUCKET), s -> (Integer)s.getValue((Property)LayeredCauldronBlock.LEVEL) == 3, SoundEvents.BUCKET_FILL));
            waterMap.put(Items.GLASS_BOTTLE, (state, level, pos, player, hand, stack) -> {
                if (!level.isClientSide) {
                    Item item = stack.getItem();
                    player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)PotionUtils.setPotion((ItemStack)new ItemStack((ItemLike)Items.POTION), (Potion)Potions.WATER)));
                    player.awardStat(Stats.USE_CAULDRON);
                    player.awardStat(Stats.ITEM_USED.get((Object)item));
                    ReinforcedLayeredCauldronBlock.lowerFillLevel(state, level, pos);
                    level.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.gameEvent(null, GameEvent.FLUID_PICKUP, pos);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            });
            waterMap.put(Items.POTION, (state, level, pos, player, hand, stack) -> {
                if ((Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL) != 3 && PotionUtils.getPotion((ItemStack)stack) == Potions.WATER) {
                    if (!level.isClientSide) {
                        player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE)));
                        player.awardStat(Stats.USE_CAULDRON);
                        player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                        ReinforcedCauldronBlock.updateBlockState(level, pos, (BlockState)state.cycle((Property)LayeredCauldronBlock.LEVEL), null);
                        level.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.gameEvent(null, GameEvent.FLUID_PLACE, pos);
                    }
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
                return InteractionResult.PASS;
            });
            waterMap.put(Items.LEATHER_BOOTS, DYED_ITEM);
            waterMap.put(Items.LEATHER_LEGGINGS, DYED_ITEM);
            waterMap.put(Items.LEATHER_CHESTPLATE, DYED_ITEM);
            waterMap.put(Items.LEATHER_HELMET, DYED_ITEM);
            waterMap.put(Items.LEATHER_HORSE_ARMOR, DYED_ITEM);
            waterMap.put(Items.WHITE_BANNER, BANNER);
            waterMap.put(Items.GRAY_BANNER, BANNER);
            waterMap.put(Items.BLACK_BANNER, BANNER);
            waterMap.put(Items.BLUE_BANNER, BANNER);
            waterMap.put(Items.BROWN_BANNER, BANNER);
            waterMap.put(Items.CYAN_BANNER, BANNER);
            waterMap.put(Items.GREEN_BANNER, BANNER);
            waterMap.put(Items.LIGHT_BLUE_BANNER, BANNER);
            waterMap.put(Items.LIGHT_GRAY_BANNER, BANNER);
            waterMap.put(Items.LIME_BANNER, BANNER);
            waterMap.put(Items.MAGENTA_BANNER, BANNER);
            waterMap.put(Items.ORANGE_BANNER, BANNER);
            waterMap.put(Items.PINK_BANNER, BANNER);
            waterMap.put(Items.PURPLE_BANNER, BANNER);
            waterMap.put(Items.RED_BANNER, BANNER);
            waterMap.put(Items.YELLOW_BANNER, BANNER);
            waterMap.put(Items.WHITE_SHULKER_BOX, SHULKER_BOX);
            waterMap.put(Items.GRAY_SHULKER_BOX, SHULKER_BOX);
            waterMap.put(Items.BLACK_SHULKER_BOX, SHULKER_BOX);
            waterMap.put(Items.BLUE_SHULKER_BOX, SHULKER_BOX);
            waterMap.put(Items.BROWN_SHULKER_BOX, SHULKER_BOX);
            waterMap.put(Items.CYAN_SHULKER_BOX, SHULKER_BOX);
            waterMap.put(Items.GREEN_SHULKER_BOX, SHULKER_BOX);
            waterMap.put(Items.LIGHT_BLUE_SHULKER_BOX, SHULKER_BOX);
            waterMap.put(Items.LIGHT_GRAY_SHULKER_BOX, SHULKER_BOX);
            waterMap.put(Items.LIME_SHULKER_BOX, SHULKER_BOX);
            waterMap.put(Items.MAGENTA_SHULKER_BOX, SHULKER_BOX);
            waterMap.put(Items.ORANGE_SHULKER_BOX, SHULKER_BOX);
            waterMap.put(Items.PINK_SHULKER_BOX, SHULKER_BOX);
            waterMap.put(Items.PURPLE_SHULKER_BOX, SHULKER_BOX);
            waterMap.put(Items.RED_SHULKER_BOX, SHULKER_BOX);
            waterMap.put(Items.YELLOW_SHULKER_BOX, SHULKER_BOX);
            lavaMap.put(Items.BUCKET, (state, level, pos, player, hand, stack) -> IReinforcedCauldronInteraction.fillBucket(state, level, pos, player, hand, stack, new ItemStack((ItemLike)Items.LAVA_BUCKET), s -> true, SoundEvents.BUCKET_FILL_LAVA));
            IReinforcedCauldronInteraction.addDefaultInteractions(lavaMap);
            powderSnowMap.put(Items.BUCKET, (state, level, pos, player, hand, stack) -> IReinforcedCauldronInteraction.fillBucket(state, level, pos, player, hand, stack, new ItemStack((ItemLike)Items.POWDER_SNOW_BUCKET), l -> (Integer)l.getValue((Property)LayeredCauldronBlock.LEVEL) == 3, SoundEvents.BUCKET_FILL_POWDER_SNOW));
            IReinforcedCauldronInteraction.addDefaultInteractions(powderSnowMap);
            vanillaWaterMap.put((Item)SCContent.BRIEFCASE.get(), CauldronInteraction.DYED_ITEM);
            waterMap.put((Item)SCContent.BRIEFCASE.get(), DYED_ITEM);
            vanillaWaterMap.put((Item)SCContent.LENS.get(), CauldronInteraction.DYED_ITEM);
            waterMap.put((Item)SCContent.LENS.get(), DYED_ITEM);
        }

        public static void addDefaultInteractions(Map<Item, CauldronInteraction> interactions) {
            interactions.put(Items.LAVA_BUCKET, FILL_LAVA);
            interactions.put(Items.WATER_BUCKET, FILL_WATER);
            interactions.put(Items.POWDER_SNOW_BUCKET, FILL_POWDER_SNOW);
        }

        public static InteractionResult fillBucket(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack, ItemStack bucket, Predicate<BlockState> fillPredicate, SoundEvent sound) {
            if (!fillPredicate.test(state)) {
                return InteractionResult.PASS;
            }
            if (!level.isClientSide) {
                Item item = stack.getItem();
                player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)bucket));
                player.awardStat(Stats.USE_CAULDRON);
                player.awardStat(Stats.ITEM_USED.get((Object)item));
                ReinforcedCauldronBlock.updateBlockState(level, pos, ((ReinforcedCauldronBlock)SCContent.REINFORCED_CAULDRON.get()).defaultBlockState());
                level.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent(null, GameEvent.FLUID_PICKUP, pos);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }

        public static InteractionResult emptyBucket(Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack, BlockState state, SoundEvent sound) {
            if (!level.isClientSide) {
                Item item = stack.getItem();
                player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.BUCKET)));
                player.awardStat(Stats.FILL_CAULDRON);
                player.awardStat(Stats.ITEM_USED.get((Object)item));
                ReinforcedCauldronBlock.updateBlockState(level, pos, state);
                level.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent(null, GameEvent.FLUID_PLACE, pos);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
    }
}

