/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.blockentities.ReinforcedDropperBlockEntity;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedDispenserBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.VanillaInventoryCodeHooks;

public class ReinforcedDropperBlock
extends ReinforcedDispenserBlock {
    private static final DispenseItemBehavior DISPENSE_BEHAVIOUR = new DefaultDispenseItemBehavior();

    public ReinforcedDropperBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return (Boolean)ConfigHandler.SERVER.alwaysDrop.get() != false || super.canHarvestBlock(state, level, pos, player);
    }

    public DispenseItemBehavior getDispenseMethod(ItemStack stack) {
        return DISPENSE_BEHAVIOUR;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ReinforcedDropperBlockEntity(pos, state);
    }

    @Override
    protected void dispenseFrom(ServerLevel level, BlockState state, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ReinforcedDropperBlockEntity) {
            ReinforcedDropperBlockEntity be = (ReinforcedDropperBlockEntity)blockEntity;
            BlockSource source = new BlockSource(level, pos, state, (DispenserBlockEntity)be);
            int randomSlot = be.getRandomSlot(level.random);
            if (randomSlot < 0) {
                level.levelEvent(1001, pos, 0);
            } else {
                ItemStack dispenseStack = be.getItem(randomSlot);
                if (!dispenseStack.isEmpty() && VanillaInventoryCodeHooks.dropperInsertHook((Level)level, (BlockPos)pos, (DispenserBlockEntity)be, (int)randomSlot, (ItemStack)dispenseStack)) {
                    ItemStack afterDispenseStack;
                    Direction direction = (Direction)level.getBlockState(pos).getValue((Property)FACING);
                    Container container = HopperBlockEntity.getContainerAt((Level)level, (BlockPos)pos.relative(direction));
                    if (container == null) {
                        afterDispenseStack = DISPENSE_BEHAVIOUR.dispense(source, dispenseStack);
                    } else {
                        afterDispenseStack = HopperBlockEntity.addItem((Container)be, (Container)container, (ItemStack)dispenseStack.copy().split(1), (Direction)direction.getOpposite());
                        if (afterDispenseStack.isEmpty()) {
                            afterDispenseStack = dispenseStack.copy();
                            afterDispenseStack.shrink(1);
                        } else {
                            afterDispenseStack = dispenseStack.copy();
                        }
                    }
                    be.setItem(randomSlot, afterDispenseStack);
                }
            }
        }
    }

    @Override
    public Block getVanillaBlock() {
        return Blocks.DROPPER;
    }
}

