/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.blockentities.AllowlistOnlyBlockEntity;
import net.geforcemods.securitycraft.blockentities.ReinforcedFenceGateBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableFenceGateBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class ReinforcedFenceGateBlock
extends OwnableFenceGateBlock
implements IReinforcedBlock {
    private final Block vanillaBlock;

    public ReinforcedFenceGateBlock(BlockBehaviour.Properties properties, WoodType woodType, Block vanillaBlock) {
        super(properties, woodType);
        this.vanillaBlock = vanillaBlock;
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        AllowlistOnlyBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AllowlistOnlyBlockEntity && ((be = (AllowlistOnlyBlockEntity)blockEntity).isOwnedBy((Entity)player) || be.isAllowed((Entity)player))) {
            if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
                state = (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false));
                level.setBlock(pos, state, 10);
            } else {
                Direction direction = player.getDirection();
                if (state.getValue((Property)FACING) == direction.getOpposite()) {
                    state = (BlockState)state.setValue((Property)FACING, (Comparable)direction);
                }
                state = (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true));
                level.setBlock(pos, state, 10);
            }
            boolean isOpen = (Boolean)state.getValue((Property)OPEN);
            level.playSound(null, pos, isOpen ? this.openSound : this.closeSound, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
            level.gameEvent((Entity)player, isOpen ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, pos);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public boolean triggerEvent(BlockState state, Level level, BlockPos pos, int id, int param) {
        BlockEntity be = level.getBlockEntity(pos);
        return be != null && be.triggerEvent(id, param);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ReinforcedFenceGateBlockEntity(pos, state);
    }

    @Override
    public Block getVanillaBlock() {
        return this.vanillaBlock;
    }
}

