/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.blockentities.ReinforcedCauldronBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedCauldronBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ReinforcedLayeredCauldronBlock
extends LayeredCauldronBlock
implements IReinforcedBlock,
EntityBlock {
    private final Block vanillaBlock;
    private final float destroyTimeForOwner;

    public ReinforcedLayeredCauldronBlock(Biome.Precipitation precipitation, CauldronInteraction.InteractionMap interactions, BlockBehaviour.Properties properties, Block vanillaBlock) {
        super(precipitation, interactions, OwnableBlock.withReinforcedDestroyTime(properties));
        this.vanillaBlock = vanillaBlock;
        this.destroyTimeForOwner = OwnableBlock.getStoredDestroyTime();
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.getDestroyProgress(x$0, x$1, x$2, x$3), this.destroyTimeForOwner, state, player, level, pos);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return (Boolean)ConfigHandler.SERVER.alwaysDrop.get() != false || super.canHarvestBlock(state, level, pos, player);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext collisionContext) {
        Entity entity;
        EntityCollisionContext ctx;
        if (collisionContext instanceof EntityCollisionContext && (ctx = (EntityCollisionContext)collisionContext).getEntity() != null && (entity = ctx.getEntity()) instanceof Player) {
            ReinforcedCauldronBlockEntity be;
            Player player = (Player)entity;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof ReinforcedCauldronBlockEntity && (be = (ReinforcedCauldronBlockEntity)blockEntity).isAllowedToInteract(player)) {
                return SHAPE;
            }
            return Shapes.block();
        }
        return SHAPE;
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ReinforcedCauldronBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ReinforcedCauldronBlockEntity && (be = (ReinforcedCauldronBlockEntity)blockEntity).isAllowedToInteract(player)) {
            return super.use(state, level, pos, player, hand, hit);
        }
        return InteractionResult.PASS;
    }

    public static void lowerFillLevel(BlockState state, Level level, BlockPos pos) {
        int fillLevel = (Integer)state.getValue((Property)LEVEL) - 1;
        BlockState newState = fillLevel == 0 ? ((ReinforcedCauldronBlock)SCContent.REINFORCED_CAULDRON.get()).defaultBlockState() : (BlockState)state.setValue((Property)LEVEL, (Comparable)Integer.valueOf(fillLevel));
        ReinforcedCauldronBlock.updateBlockState(level, pos, newState);
        level.gameEvent(GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)newState));
    }

    public void handleEntityOnFireInside(BlockState state, Level level, BlockPos pos) {
        ReinforcedLayeredCauldronBlock.lowerFillLevel(state, level, pos);
    }

    @Override
    public Block getVanillaBlock() {
        return this.vanillaBlock;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ReinforcedCauldronBlockEntity(pos, state);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)SCContent.REINFORCED_CAULDRON.get());
    }
}

