/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.hudmods;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.entity.SecuritySeaBoat;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.IBlockMine;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class HudModHandler {
    protected static final ResourceLocation SHOW_OWNER = new ResourceLocation("securitycraft", "showowner");
    protected static final ResourceLocation SHOW_MODULES = new ResourceLocation("securitycraft", "showmodules");
    protected static final ResourceLocation SHOW_CUSTOM_NAME = new ResourceLocation("securitycraft", "showcustomname");
    protected static final Style MOD_NAME_STYLE = Style.EMPTY.applyFormat(ChatFormatting.BLUE).withItalic(Boolean.valueOf(true));
    protected static final Style ITEM_NAME_STYLE = Style.EMPTY.applyFormat(ChatFormatting.WHITE);
    protected static final MutableComponent EQUIPPED = Utils.localize("waila.securitycraft:equipped", new Object[0]).withStyle(ChatFormatting.GRAY);
    protected static final MutableComponent ALLOWLIST_MODULE = Component.literal((String)"- ").append((Component)Component.translatable((String)ModuleType.ALLOWLIST.getTranslationKey())).withStyle(ChatFormatting.GRAY);
    protected static final MutableComponent DISGUISE_MODULE = Component.literal((String)"- ").append((Component)Component.translatable((String)ModuleType.DISGUISE.getTranslationKey())).withStyle(ChatFormatting.GRAY);
    protected static final MutableComponent SPEED_MODULE = Component.literal((String)"- ").append((Component)Component.translatable((String)ModuleType.SPEED.getTranslationKey())).withStyle(ChatFormatting.GRAY);

    protected HudModHandler() {
    }

    public void addDisguisedOwnerModuleNameInfo(Level level, BlockPos pos, BlockState state, Block block, BlockEntity be, Player player, Consumer<Component> lineAdder, Predicate<ResourceLocation> configGetter) {
        Optional<BlockState> disguisedBlockState;
        if (be == null) {
            return;
        }
        if (block instanceof IDisguisable && (disguisedBlockState = IDisguisable.getDisguisedBlockState(be, (LevelReader)level)).isPresent()) {
            IOverlayDisplay display;
            BlockState disguisedState = disguisedBlockState.get();
            block = disguisedState.getBlock();
            if (block instanceof EntityBlock) {
                EntityBlock entityBlock = (EntityBlock)block;
                if (!(block instanceof IDisguisable) && entityBlock.newBlockEntity(pos, disguisedState) instanceof IOwnable) {
                    this.addOwnerInfo(be, lineAdder, configGetter);
                }
            }
            if (!(block instanceof IOverlayDisplay) || !(display = (IOverlayDisplay)block).shouldShowSCInfo(level, state, pos)) {
                return;
            }
        }
        if (!(block instanceof IBlockMine)) {
            this.addOwnerModuleNameInfo(be, player, lineAdder, configGetter);
        }
    }

    public void addOwnerInfo(Object obj, Consumer<Component> lineAdder, Predicate<ResourceLocation> configGetter) {
        if (configGetter.test(SHOW_OWNER) && obj instanceof IOwnable) {
            IOwnable ownable = (IOwnable)obj;
            lineAdder.accept((Component)Utils.localize("waila.securitycraft:owner", PlayerUtils.getOwnerComponent(ownable.getOwner())).withStyle(ChatFormatting.GRAY));
        }
    }

    public void addOwnerModuleNameInfo(Object obj, Player player, Consumer<Component> lineAdder, Predicate<ResourceLocation> configGetter) {
        Nameable nameable;
        IOwnable ownable;
        IModuleInventory inv;
        this.addOwnerInfo(obj, lineAdder, configGetter);
        if (configGetter.test(SHOW_MODULES) && obj instanceof IModuleInventory && !(inv = (IModuleInventory)obj).getInsertedModules().isEmpty() && (!(obj instanceof IOwnable) || (ownable = (IOwnable)obj).isOwnedBy((Entity)player))) {
            lineAdder.accept((Component)EQUIPPED);
            for (ModuleType module : inv.getInsertedModules()) {
                MutableComponent prefix = inv.isModuleEnabled(module) ? Component.literal((String)"\u2714 ").withStyle(ChatFormatting.GREEN) : Component.literal((String)"\u2715 ").withStyle(ChatFormatting.RED);
                lineAdder.accept((Component)prefix.append((Component)Component.translatable((String)module.getTranslationKey()).withStyle(ChatFormatting.GRAY)));
            }
        }
        if (configGetter.test(SHOW_CUSTOM_NAME) && obj instanceof Nameable && (nameable = (Nameable)obj).hasCustomName()) {
            Component text = nameable.getCustomName();
            MutableComponent name = text == null ? Component.empty() : text;
            lineAdder.accept((Component)Utils.localize("waila.securitycraft:customName", name).withStyle(ChatFormatting.GRAY));
        }
    }

    public void addEntityInfo(Entity entity, Player player, Consumer<Component> lineAdder, Predicate<ResourceLocation> configGetter) {
        if (entity instanceof Sentry) {
            Sentry sentry = (Sentry)entity;
            Sentry.SentryMode mode = sentry.getMode();
            this.addOwnerInfo(sentry, lineAdder, configGetter);
            if (configGetter.test(SHOW_MODULES) && sentry.isOwnedBy((Entity)player) && (!sentry.getAllowlistModule().isEmpty() || !sentry.getDisguiseModule().isEmpty() || sentry.hasSpeedModule())) {
                lineAdder.accept((Component)EQUIPPED);
                if (!sentry.getAllowlistModule().isEmpty()) {
                    lineAdder.accept((Component)ALLOWLIST_MODULE);
                }
                if (!sentry.getDisguiseModule().isEmpty()) {
                    lineAdder.accept((Component)DISGUISE_MODULE);
                }
                if (sentry.hasSpeedModule()) {
                    lineAdder.accept((Component)SPEED_MODULE);
                }
            }
            MutableComponent modeDescription = Utils.localize(mode.getModeKey(), new Object[0]);
            if (mode != Sentry.SentryMode.IDLE) {
                modeDescription.append("- ").append((Component)Utils.localize(mode.getTargetKey(), new Object[0]));
            }
            lineAdder.accept((Component)modeDescription.withStyle(ChatFormatting.GRAY));
        } else if (entity instanceof SecuritySeaBoat) {
            SecuritySeaBoat boat = (SecuritySeaBoat)entity;
            this.addOwnerModuleNameInfo(boat, player, lineAdder, configGetter);
        }
    }
}

