/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.geforcemods.securitycraft.inventory.InventoryScannerMenu;
import net.geforcemods.securitycraft.inventory.OwnerRestrictedSlot;
import net.geforcemods.securitycraft.network.server.SetGhostSlot;
import net.geforcemods.securitycraft.screen.InventoryScannerScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class InventoryScannerGhostIngredientHandler
implements IGhostIngredientHandler<InventoryScannerScreen> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(final InventoryScannerScreen screen, ITypedIngredient<I> ingredient, boolean doStart) {
        if (!screen.be.isOwnedBy((Entity)Minecraft.getInstance().player)) {
            return List.of();
        }
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        for (final Slot slot : ((InventoryScannerMenu)screen.getMenu()).slots) {
            if (!(slot instanceof OwnerRestrictedSlot)) continue;
            final Rect2i area = new Rect2i(screen.getGuiLeft() + slot.x, screen.getGuiTop() + slot.y, 16, 16);
            targets.add(new IGhostIngredientHandler.Target<I>(){

                public Rect2i getArea() {
                    return area;
                }

                public void accept(I ingredient) {
                    screen.be.getContents().set(slot.index, (Object)((ItemStack)ingredient));
                    PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new SetGhostSlot(slot.index, (ItemStack)ingredient)});
                }
            });
        }
        return targets;
    }

    public void onComplete() {
    }
}

