/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;

public class BouncingBetty
extends Entity {
    private int fuse;

    public BouncingBetty(EntityType<BouncingBetty> type, Level level) {
        super((EntityType)SCContent.BOUNCING_BETTY_ENTITY.get(), level);
    }

    public BouncingBetty(Level level, double x, double y, double z) {
        super((EntityType)SCContent.BOUNCING_BETTY_ENTITY.get(), level);
        this.setPos(x, y, z);
        float f = (float)(Math.random() * Math.PI * 2.0);
        this.setDeltaMovement(-((float)Math.sin(f)) * 0.02f, 0.2f, -((float)Math.cos(f)) * 0.02f);
        this.setFuse(80);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    protected void defineSynchedData() {
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    public void tick() {
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)-0.04f, 0.0));
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)0.98f, (double)0.98f, (double)0.98f));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply((double)0.7f, (double)0.7f, -0.5));
        }
        if (this.fuse-- <= 0 && !this.level().isClientSide) {
            this.discard();
            this.explode();
        } else if (this.level().isClientSide) {
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, false, this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    private void explode() {
        this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), (Boolean)ConfigHandler.SERVER.smallerMineExplosion.get() != false ? 3.0f : 6.0f, ((Boolean)ConfigHandler.SERVER.shouldSpawnFire.get()).booleanValue(), BlockUtils.getExplosionInteraction());
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putByte("Fuse", (byte)this.getFuse());
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.setFuse(tag.getByte("Fuse"));
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void setFuse(int fuse) {
        this.fuse = fuse;
    }

    public int getFuse() {
        return this.fuse;
    }
}

