/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.camera;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.entity.camera.CameraNightVisionEffectInstance;
import net.geforcemods.securitycraft.network.client.SetCameraView;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;

public class SecurityCamera
extends Entity {
    public static final EntityDataAccessor<Float> ZOOM_AMOUNT = SynchedEntityData.defineId(SecurityCamera.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final Map<UUID, BlockPos> DISMOUNTED_PLAYERS = new HashMap<UUID, BlockPos>();
    protected boolean zooming = false;
    private ChunkTrackingView cameraChunks = null;
    private boolean hasSentChunks = false;
    private SecurityCameraBlockEntity be;

    public SecurityCamera(EntityType<SecurityCamera> type, Level level) {
        super((EntityType)SCContent.SECURITY_CAMERA_ENTITY.get(), level);
        this.noPhysics = true;
    }

    public SecurityCamera(Level level, BlockPos pos) {
        this((EntityType<SecurityCamera>)((EntityType)SCContent.SECURITY_CAMERA_ENTITY.get()), level);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof SecurityCameraBlockEntity)) {
            this.discard();
            return;
        }
        SecurityCameraBlockEntity cam = (SecurityCameraBlockEntity)blockEntity;
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.5;
        double z = (double)pos.getZ() + 0.5;
        this.be = cam;
        if (this.be.isDown()) {
            y += 0.25;
        }
        this.setPos(x, y, z);
        this.setRot(this.be.getInitialYRotation(), this.be.getInitialXRotation());
        this.setZoomAmount(this.be.getInitialZoom());
    }

    protected boolean repositionEntityAfterLoad() {
        return false;
    }

    public void tick() {
        Level level = this.level();
        if (!level.isClientSide && level.getBlockState(this.blockPosition()).getBlock() != SCContent.SECURITY_CAMERA.get()) {
            this.discard();
        }
    }

    public float getZoomAmount() {
        return ((Float)this.entityData.get(ZOOM_AMOUNT)).floatValue();
    }

    public void setZoomAmount(float zoomAmount) {
        this.entityData.set(ZOOM_AMOUNT, (Object)Float.valueOf(zoomAmount));
    }

    public boolean isCameraDown() {
        return this.getBlockEntity() != null && !this.be.isRemoved() && this.be.isDown();
    }

    public void setRotation(float yaw, float pitch) {
        this.setRot(yaw, pitch);
    }

    public ChunkTrackingView getCameraChunks() {
        return this.cameraChunks;
    }

    public void setChunkLoadingDistance(int chunkLoadingDistance) {
        this.cameraChunks = ChunkTrackingView.of((ChunkPos)this.chunkPosition(), (int)chunkLoadingDistance);
    }

    public boolean hasSentChunks() {
        return this.hasSentChunks;
    }

    public void setHasSentChunks(boolean hasSentChunks) {
        this.hasSentChunks = hasSentChunks;
    }

    public static boolean hasRecentlyDismounted(ServerPlayer player) {
        return DISMOUNTED_PLAYERS.containsKey(player.getUUID());
    }

    public static BlockPos fetchRecentDismountLocation(ServerPlayer player) {
        return DISMOUNTED_PLAYERS.remove(player.getUUID());
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        this.discardCamera();
    }

    public void stopViewing(ServerPlayer player) {
        if (!this.level().isClientSide) {
            this.discard();
            player.camera = player;
            PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{new SetCameraView((Entity)player)});
            DISMOUNTED_PLAYERS.put(player.getUUID(), this.blockPosition());
            if (player.getEffect(MobEffects.NIGHT_VISION) instanceof CameraNightVisionEffectInstance) {
                player.removeEffect(MobEffects.NIGHT_VISION);
            }
        }
    }

    @Deprecated
    public void discardCamera() {
        if (!this.level().isClientSide) {
            int n;
            if (this.getBlockEntity() != null && !this.be.isRemoved()) {
                this.be.stopViewing();
            }
            SectionPos chunkPos = SectionPos.of((BlockPos)this.blockPosition());
            ChunkTrackingView chunkTrackingView = this.cameraChunks;
            if (chunkTrackingView instanceof ChunkTrackingView.Positioned) {
                ChunkTrackingView.Positioned positionedChunks = (ChunkTrackingView.Positioned)chunkTrackingView;
                n = positionedChunks.viewDistance();
            } else {
                n = this.level().getServer().getPlayerList().getViewDistance();
            }
            int chunkLoadingDistance = n;
            for (int x = chunkPos.getX() - chunkLoadingDistance; x <= chunkPos.getX() + chunkLoadingDistance; ++x) {
                for (int z = chunkPos.getZ() - chunkLoadingDistance; z <= chunkPos.getZ() + chunkLoadingDistance; ++z) {
                    SecurityCraft.CAMERA_TICKET_CONTROLLER.forceChunk((ServerLevel)this.level(), (Entity)this, x, z, false, false);
                }
            }
        }
    }

    protected void defineSynchedData() {
        this.entityData.define(ZOOM_AMOUNT, (Object)Float.valueOf(1.0f));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putFloat("zoom_amount", this.getZoomAmount());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        this.entityData.set(ZOOM_AMOUNT, (Object)Float.valueOf(tag.getFloat("zoom_amount")));
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public boolean isAlwaysTicking() {
        return true;
    }

    public SecurityCameraBlockEntity getBlockEntity() {
        if (this.be == null) {
            BlockEntity blockEntity = this.level().getBlockEntity(this.blockPosition());
            if (blockEntity instanceof SecurityCameraBlockEntity) {
                SecurityCameraBlockEntity camera;
                this.be = camera = (SecurityCameraBlockEntity)blockEntity;
            } else {
                SecurityCraft.LOGGER.warn("No security camera block entity was found at {}. Try breaking and replacing the block!", (Object)this.blockPosition());
            }
        }
        return this.be;
    }
}

