/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.sentry;

import com.google.common.collect.Sets;
import java.util.Collection;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class Bullet
extends AbstractArrow {
    private static final EntityDataAccessor<Owner> OWNER = SynchedEntityData.defineId(Bullet.class, Owner.getSerializer());
    private Collection<MobEffectInstance> potionEffects = Sets.newHashSet();

    public Bullet(EntityType<Bullet> type, Level level) {
        super((EntityType)SCContent.BULLET_ENTITY.get(), level, ItemStack.EMPTY);
    }

    public Bullet(Level level, Sentry shooter) {
        super((EntityType)SCContent.BULLET_ENTITY.get(), (LivingEntity)shooter, level, ItemStack.EMPTY);
        Owner owner = shooter.getOwner();
        this.potionEffects = shooter.getActiveEffects();
        this.entityData.set(OWNER, (Object)new Owner(owner.getName(), owner.getUUID()));
    }

    public Owner getSCOwner() {
        return (Owner)this.entityData.get(OWNER);
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(OWNER, (Object)new Owner());
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (!this.potionEffects.isEmpty()) {
            ListTag list = new ListTag();
            for (MobEffectInstance effect : this.potionEffects) {
                list.add((Object)effect.save(new CompoundTag()));
            }
            tag.put("PotionEffects", (Tag)list);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        ListTag potionList;
        super.readAdditionalSaveData(tag);
        if (tag.contains("PotionEffects", 9) && !(potionList = tag.getList("PotionEffects", 10)).isEmpty()) {
            for (int i = 0; i < potionList.size(); ++i) {
                MobEffectInstance effect = MobEffectInstance.load((CompoundTag)potionList.getCompound(i));
                if (effect == null) continue;
                this.potionEffects.add(effect);
            }
        }
    }

    protected void onHitEntity(EntityHitResult raytraceResult) {
        Entity target = raytraceResult.getEntity();
        if (!(target instanceof Sentry) && !(target instanceof ItemFrame)) {
            target.hurt(this.damageSources().arrow((AbstractArrow)this, this.getOwner()), (float)((Integer)ConfigHandler.SERVER.sentryBulletDamage.get()).intValue());
            if (target instanceof LivingEntity) {
                LivingEntity lEntity = (LivingEntity)target;
                if (!this.potionEffects.isEmpty()) {
                    for (MobEffectInstance effect : this.potionEffects) {
                        lEntity.addEffect(effect);
                    }
                }
            }
        }
        this.discard();
    }

    protected void onHitBlock(BlockHitResult raytraceResult) {
        this.discard();
    }

    protected ItemStack getPickupItem() {
        return ItemStack.EMPTY;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

