/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.sentry;

import java.util.List;
import java.util.Optional;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IEMPAffected;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.SometimesVisibleBlock;
import net.geforcemods.securitycraft.entity.sentry.AttackRangedIfEnabledGoal;
import net.geforcemods.securitycraft.entity.sentry.Bullet;
import net.geforcemods.securitycraft.entity.sentry.ISentryBulletContainer;
import net.geforcemods.securitycraft.entity.sentry.TargetNearestPlayerOrMobGoal;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.items.UniversalOwnerChangerItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.TargetingMode;
import net.geforcemods.securitycraft.mixin.reinforced.IAbstractProjectileDispenseBehaviorAccessor;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class Sentry
extends PathfinderMob
implements RangedAttackMob,
IEMPAffected,
IOwnable {
    private static final EntityDataAccessor<Owner> OWNER = SynchedEntityData.defineId(Sentry.class, Owner.getSerializer());
    private static final EntityDataAccessor<CompoundTag> ALLOWLIST = SynchedEntityData.defineId(Sentry.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private static final EntityDataAccessor<Boolean> HAS_SPEED_MODULE = SynchedEntityData.defineId(Sentry.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> MODE = SynchedEntityData.defineId(Sentry.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> HAS_TARGET = SynchedEntityData.defineId(Sentry.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SHUT_DOWN = SynchedEntityData.defineId(Sentry.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Float> HEAD_ROTATION = SynchedEntityData.defineId(Sentry.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final float MAX_TARGET_DISTANCE = 20.0f;
    private static final float ANIMATION_STEP_SIZE = 0.025f;
    private static final float UPWARDS_ANIMATION_LIMIT = 0.025f;
    private static final float DOWNWARDS_ANIMATION_LIMIT = 0.9f;
    private float headYTranslation = 0.9f;
    private float oHeadYTranslation = 0.9f;
    private boolean animateUpwards = false;
    private boolean animate = false;
    private float headRotation;
    private float oHeadRotation;
    private boolean hasReceivedEntityData = false;

    public Sentry(EntityType<Sentry> type, Level level) {
        super((EntityType)SCContent.SENTRY_ENTITY.get(), level);
    }

    public void setUpSentry(Player player) {
        this.entityData.set(OWNER, (Object)new Owner(player.getName().getString(), player.getGameProfile().getId().toString()));
        this.entityData.set(ALLOWLIST, (Object)new CompoundTag());
        this.entityData.set(HAS_SPEED_MODULE, (Object)false);
        this.entityData.set(MODE, (Object)SentryMode.CAMOUFLAGE_HP.ordinal());
        this.entityData.set(HAS_TARGET, (Object)false);
        this.entityData.set(SHUT_DOWN, (Object)false);
        this.entityData.set(HEAD_ROTATION, (Object)Float.valueOf((float)(Mth.atan2((double)(player.getX() - this.getX()), (double)(-(player.getZ() - this.getZ()))) * 57.29577951308232)));
        this.getSentryDisguiseBlockEntity();
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(OWNER, (Object)new Owner());
        this.entityData.define(ALLOWLIST, (Object)new CompoundTag());
        this.entityData.define(HAS_SPEED_MODULE, (Object)false);
        this.entityData.define(MODE, (Object)SentryMode.CAMOUFLAGE_HP.ordinal());
        this.entityData.define(HAS_TARGET, (Object)false);
        this.entityData.define(SHUT_DOWN, (Object)false);
        this.entityData.define(HEAD_ROTATION, (Object)Float.valueOf(0.0f));
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new AttackRangedIfEnabledGoal(this, this::getShootingSpeed, 10.0f));
        this.targetSelector.addGoal(1, (Goal)new TargetNearestPlayerOrMobGoal(this));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            BlockPos downPos = this.getBlockPosBelowThatAffectsMyMovement();
            if (this.level().getBlockState(downPos).isAir() || this.level().noCollision(new AABB(downPos))) {
                this.discard();
            }
        } else {
            this.oHeadRotation = this.getHeadRotation();
            this.headRotation = ((Float)this.entityData.get(HEAD_ROTATION)).floatValue();
            this.oHeadYTranslation = this.headYTranslation;
            if (this.shouldHeadBeUp()) {
                if (this.headYTranslation > 0.025f) {
                    this.setAnimateUpwards(true);
                    this.setAnimate(true);
                }
            } else if (this.headYTranslation < 0.9f) {
                this.setAnimateUpwards(false);
                this.setAnimate(true);
            }
            if (this.isAnimating()) {
                if (this.animatesUpwards() && this.headYTranslation > 0.025f) {
                    this.headYTranslation -= 0.025f;
                    if (this.headYTranslation <= 0.025f) {
                        this.setAnimateUpwards(false);
                        this.setAnimate(false);
                    }
                } else if (!this.animatesUpwards() && this.headYTranslation < 0.9f) {
                    this.headYTranslation += 0.025f;
                    if (this.headYTranslation >= 0.9f) {
                        this.setAnimateUpwards(true);
                        this.setAnimate(false);
                    }
                }
            }
        }
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)SCContent.SENTRY.get());
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        BlockPos pos = this.blockPosition();
        if (this.isOwnedBy((Entity)player) && hand == InteractionHand.MAIN_HAND) {
            Item item = player.getMainHandItem().getItem();
            player.closeContainer();
            if (player.isCrouching()) {
                this.kill();
            } else if (item == Items.REDSTONE && this.isShutDown()) {
                this.reactivate();
                if (!player.isCreative()) {
                    player.getMainHandItem().shrink(1);
                }
            } else if (item == SCContent.UNIVERSAL_BLOCK_REMOVER.get() && !((Boolean)ConfigHandler.SERVER.vanillaToolBlockBreaking.get()).booleanValue()) {
                this.kill();
                if (!player.isCreative()) {
                    player.getMainHandItem().hurtAndBreak(1, (LivingEntity)player, p -> p.broadcastBreakEvent(hand));
                }
            } else if (item == SCContent.DISGUISE_MODULE.get()) {
                ItemStack module = this.getDisguiseModule();
                if (!module.isEmpty()) {
                    Block.popResource((Level)this.level(), (BlockPos)pos, (ItemStack)module);
                }
                this.addDisguiseModule(player.getMainHandItem());
                if (!player.isCreative()) {
                    player.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                }
            } else if (item == SCContent.ALLOWLIST_MODULE.get()) {
                ItemStack module = this.getAllowlistModule();
                if (!module.isEmpty()) {
                    Block.popResource((Level)this.level(), (BlockPos)pos, (ItemStack)module);
                }
                this.setAllowlistModule(player.getMainHandItem());
                if (!player.isCreative()) {
                    player.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                }
            } else if (item == SCContent.SPEED_MODULE.get()) {
                if (!this.hasSpeedModule()) {
                    this.setHasSpeedModule(true);
                    if (!player.isCreative()) {
                        player.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                    }
                }
            } else if (item == SCContent.UNIVERSAL_BLOCK_MODIFIER.get()) {
                Block.popResource((Level)this.level(), (BlockPos)pos, (ItemStack)this.getDisguiseModule());
                Block.popResource((Level)this.level(), (BlockPos)pos, (ItemStack)this.getAllowlistModule());
                if (this.hasSpeedModule()) {
                    Block.popResource((Level)this.level(), (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)SCContent.SPEED_MODULE.get()));
                }
                this.getSentryDisguiseBlockEntity().ifPresent(be -> be.removeModule(ModuleType.DISGUISE, false));
                this.level().setBlockAndUpdate(this.blockPosition(), (BlockState)this.level().getBlockState(this.blockPosition()).setValue((Property)SometimesVisibleBlock.INVISIBLE, (Comparable)Boolean.valueOf(true)));
                this.entityData.set(ALLOWLIST, (Object)new CompoundTag());
                this.entityData.set(HAS_SPEED_MODULE, (Object)false);
            } else if (item == SCContent.SENTRY_REMOTE_ACCESS_TOOL.get()) {
                item.useOn(new UseOnContext(player, hand, new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.NORTH, pos, false)));
            } else if (item == SCContent.UNIVERSAL_OWNER_CHANGER.get()) {
                String newOwner;
                this.entityData.set(OWNER, (Object)new Owner(newOwner, PlayerUtils.isPlayerOnline(newOwner = player.getMainHandItem().getHoverName().getString()) ? PlayerUtils.getPlayerFromName(newOwner).getUUID().toString() : "ownerUUID"));
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((UniversalOwnerChangerItem)((Object)SCContent.UNIVERSAL_OWNER_CHANGER.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:universalOwnerChanger.changed", newOwner), ChatFormatting.GREEN);
            } else {
                this.toggleMode(player);
            }
            player.swing(InteractionHand.MAIN_HAND);
            return InteractionResult.SUCCESS;
        }
        if (!this.isOwnedBy((Entity)player) && hand == InteractionHand.MAIN_HAND && player.isCreative() && (player.isCrouching() || player.getMainHandItem().getItem() == SCContent.UNIVERSAL_BLOCK_REMOVER.get())) {
            this.kill();
        }
        return super.mobInteract(player, hand);
    }

    public void remove(Entity.RemovalReason reason) {
        BlockPos pos = this.blockPosition();
        ItemStack sentryStack = new ItemStack((ItemLike)SCContent.SENTRY.get());
        if (this.hasCustomName()) {
            sentryStack.setHoverName(this.getCustomName());
        }
        super.remove(reason);
        Block.popResource((Level)this.level(), (BlockPos)pos, (ItemStack)sentryStack);
        Block.popResource((Level)this.level(), (BlockPos)pos, (ItemStack)this.getDisguiseModule());
        Block.popResource((Level)this.level(), (BlockPos)pos, (ItemStack)this.getAllowlistModule());
        this.level().setBlockAndUpdate(pos, this.level().getFluidState(pos).createLegacyBlock());
        if (this.hasSpeedModule()) {
            Block.popResource((Level)this.level(), (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)SCContent.SPEED_MODULE.get()));
        }
    }

    public void kill() {
        this.remove(Entity.RemovalReason.KILLED);
        this.gameEvent(GameEvent.ENTITY_DIE);
    }

    public void toggleMode(Player player) {
        this.toggleMode(player, (Integer)this.entityData.get(MODE) + 1, true);
    }

    public void toggleMode(Player player, int mode, boolean sendMessage) {
        if (mode < 0 || mode >= SentryMode.values().length) {
            mode = 0;
        }
        this.entityData.set(MODE, (Object)mode);
        if (sendMessage) {
            player.displayClientMessage((Component)Utils.localize(SentryMode.values()[mode].getModeKey(), new Object[0]).append((Component)Utils.localize(SentryMode.values()[mode].getDescriptionKey(), new Object[0])), true);
        }
    }

    public void setTarget(LivingEntity target) {
        if (this.isShutDown()) {
            super.setTarget(null);
            return;
        }
        this.entityData.set(HAS_TARGET, (Object)(target != null ? 1 : 0));
        super.setTarget(target);
    }

    public boolean hasTarget() {
        return (Boolean)this.entityData.get(HAS_TARGET);
    }

    public float getStandingEyeHeight(Pose pose, EntityDimensions dimensions) {
        return dimensions.height * 1.6f;
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        Player player;
        if (target instanceof Player && ((player = (Player)target).isSpectator() || player.isCreative())) {
            return;
        }
        if (this.distanceToSqr((Entity)target) > 400.0) {
            return;
        }
        if (this.isShutDown()) {
            return;
        }
        Level level = this.level();
        BlockEntity blockEntity = level.getBlockEntity(this.blockPosition().below());
        Bullet throwableEntity = null;
        SoundEvent shootSound = SoundEvents.ARROW_SHOOT;
        AbstractProjectileDispenseBehavior pdb = null;
        IItemHandler handler = null;
        if (blockEntity instanceof ISentryBulletContainer) {
            ISentryBulletContainer be = (ISentryBulletContainer)blockEntity;
            handler = be.getHandlerForSentry(this);
        } else if (blockEntity != null) {
            handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, blockEntity.getBlockPos(), blockEntity.getBlockState(), blockEntity, (Object)Direction.UP);
        }
        if (handler != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                DispenseItemBehavior dispenseBehavior;
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.isEmpty() || !((dispenseBehavior = ((DispenserBlock)Blocks.DISPENSER).getDispenseMethod(stack)) instanceof AbstractProjectileDispenseBehavior)) continue;
                AbstractProjectileDispenseBehavior projectileDispenseBehavior = (AbstractProjectileDispenseBehavior)dispenseBehavior;
                ItemStack extracted = handler.extractItem(i, 1, false);
                pdb = projectileDispenseBehavior;
                throwableEntity = ((IAbstractProjectileDispenseBehaviorAccessor)pdb).securitycraft$callGetProjectile(level, (Position)this.position().add(0.0, 1.6, 0.0), extracted);
                throwableEntity.setOwner((Entity)this);
                shootSound = null;
                break;
            }
        }
        if (throwableEntity == null) {
            throwableEntity = new Bullet(level, this);
        }
        double baseY = target.getY() + (double)target.getEyeHeight() - (double)1.1f;
        double x = target.getX() - this.getX();
        double y = baseY - throwableEntity.getY();
        double z = target.getZ() - this.getZ();
        float yOffset = Mth.sqrt((float)((float)(x * x + z * z))) * 0.2f;
        this.entityData.set(HEAD_ROTATION, (Object)Float.valueOf((float)(Mth.atan2((double)x, (double)(-z)) * 57.29577951308232)));
        throwableEntity.shoot(x, y + (double)yOffset, z, 1.6f, 0.0f);
        if (shootSound == null) {
            if (!level.isClientSide && pdb != null) {
                pdb.playSound(new BlockSource((ServerLevel)level, this.blockPosition(), null, null));
            }
        } else {
            this.playSound(shootSound, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        }
        level.addFreshEntity((Entity)throwableEntity);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.put("TileEntityData", (Tag)this.getOwnerTag());
        tag.put("InstalledWhitelist", (Tag)this.getAllowlistModule().save(new CompoundTag()));
        tag.putBoolean("HasSpeedModule", this.hasSpeedModule());
        tag.putInt("SentryMode", ((Integer)this.entityData.get(MODE)).intValue());
        tag.putBoolean("HasTarget", this.hasTarget());
        tag.putFloat("HeadRotation", ((Float)this.entityData.get(HEAD_ROTATION)).floatValue());
        tag.putBoolean("ShutDown", this.isShutDown());
        super.addAdditionalSaveData(tag);
    }

    private CompoundTag getOwnerTag() {
        CompoundTag tag = new CompoundTag();
        Owner owner = (Owner)this.entityData.get(OWNER);
        owner.save(tag, this.needsValidation());
        return tag;
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        CompoundTag teTag = tag.getCompound("TileEntityData");
        Owner owner = Owner.fromCompound(teTag);
        float savedHeadRotation = tag.getFloat("HeadRotation");
        this.entityData.set(OWNER, (Object)owner);
        this.getSentryDisguiseBlockEntity().ifPresent(be -> {
            ItemStack module;
            if (tag.contains("InstalledModule") && !(module = ItemStack.of((CompoundTag)tag.getCompound("InstalledModule"))).isEmpty() && module.getItem() instanceof ModuleItem && ModuleItem.getBlockAddon(module) != null) {
                be.insertModule(module, false);
                this.level().setBlockAndUpdate(this.blockPosition(), (BlockState)this.level().getBlockState(this.blockPosition()).setValue((Property)SometimesVisibleBlock.INVISIBLE, (Comparable)Boolean.valueOf(false)));
            }
        });
        this.entityData.set(ALLOWLIST, (Object)tag.getCompound("InstalledWhitelist"));
        this.entityData.set(HAS_SPEED_MODULE, (Object)tag.getBoolean("HasSpeedModule"));
        this.entityData.set(MODE, (Object)tag.getInt("SentryMode"));
        this.entityData.set(HAS_TARGET, (Object)tag.getBoolean("HasTarget"));
        this.entityData.set(SHUT_DOWN, (Object)tag.getBoolean("ShutDown"));
        this.entityData.set(HEAD_ROTATION, (Object)Float.valueOf(savedHeadRotation));
        this.oHeadRotation = savedHeadRotation;
        this.headRotation = savedHeadRotation;
        super.readAdditionalSaveData(tag);
    }

    public void onSyncedDataUpdated(List<SynchedEntityData.DataValue<?>> dataList) {
        super.onSyncedDataUpdated(dataList);
        if (this.level().isClientSide && !this.hasReceivedEntityData) {
            if (this.shouldHeadBeUp()) {
                this.headYTranslation = 0.025f;
            }
            this.hasReceivedEntityData = true;
        }
    }

    private boolean shouldHeadBeUp() {
        return !this.isShutDown() && (this.getMode().isAggressive() || this.getMode().isCamouflage() && this.hasTarget());
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.entityData.set(OWNER, (Object)new Owner(name, uuid));
    }

    @Override
    public Owner getOwner() {
        return (Owner)this.entityData.get(OWNER);
    }

    @Override
    public void onOwnerChanged(BlockState state, Level level, BlockPos pos, Player player, Owner oldOwner, Owner newOwner) {
    }

    public void addDisguiseModule(ItemStack module) {
        if (ModuleItem.getBlockAddon(module) != null) {
            this.getSentryDisguiseBlockEntity().ifPresent(be -> {
                be.removeModule(ModuleType.DISGUISE, false);
                be.insertModule(module, false);
                this.level().setBlockAndUpdate(this.blockPosition(), (BlockState)this.level().getBlockState(this.blockPosition()).setValue((Property)SometimesVisibleBlock.INVISIBLE, (Comparable)Boolean.valueOf(false)));
            });
        }
    }

    public void setAllowlistModule(ItemStack module) {
        this.entityData.set(ALLOWLIST, (Object)module.save(new CompoundTag()));
    }

    public void setHasSpeedModule(boolean hasSpeedModule) {
        this.entityData.set(HAS_SPEED_MODULE, (Object)hasSpeedModule);
    }

    public ItemStack getDisguiseModule() {
        Optional<DisguisableBlockEntity> be = this.getSentryDisguiseBlockEntity();
        if (be.isPresent()) {
            return be.get().getModule(ModuleType.DISGUISE);
        }
        return ItemStack.EMPTY;
    }

    public ItemStack getAllowlistModule() {
        CompoundTag tag = (CompoundTag)this.entityData.get(ALLOWLIST);
        if (tag == null || tag.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return ItemStack.of((CompoundTag)tag);
    }

    public boolean hasSpeedModule() {
        return (Boolean)this.entityData.get(HAS_SPEED_MODULE);
    }

    public SentryMode getMode() {
        int mode = (Integer)this.entityData.get(MODE);
        return mode < 0 || mode >= SentryMode.values().length ? SentryMode.CAMOUFLAGE_HP : SentryMode.values()[mode];
    }

    public float getHeadYTranslation(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.oHeadYTranslation, (float)this.headYTranslation);
    }

    public Optional<DisguisableBlockEntity> getSentryDisguiseBlockEntity() {
        BlockEntity be;
        Block blockAtSentryPos = this.level().getBlockState(this.blockPosition()).getBlock();
        if (blockAtSentryPos != SCContent.SENTRY_DISGUISE.get()) {
            this.level().setBlockAndUpdate(this.blockPosition(), (BlockState)((SometimesVisibleBlock)SCContent.SENTRY_DISGUISE.get()).defaultBlockState().setValue((Property)DisguisableBlock.WATERLOGGED, (Comparable)Boolean.valueOf(blockAtSentryPos == Blocks.WATER)));
            be = this.level().getBlockEntity(this.blockPosition());
            if (be instanceof IOwnable) {
                IOwnable ownable = (IOwnable)be;
                Owner owner = this.getOwner();
                ownable.setOwner(owner.getUUID(), owner.getName());
            }
        } else {
            be = this.level().getBlockEntity(this.blockPosition());
        }
        if (be instanceof DisguisableBlockEntity) {
            DisguisableBlockEntity dbe = (DisguisableBlockEntity)be;
            return Optional.of(dbe);
        }
        return Optional.empty();
    }

    public boolean isTargetingAllowedPlayer(LivingEntity potentialTarget) {
        if (potentialTarget != null) {
            ItemStack allowlistModule = this.getAllowlistModule();
            if (allowlistModule.hasTag() && allowlistModule.getTag().getBoolean("affectEveryone")) {
                return true;
            }
            List<String> players = ModuleItem.getPlayersFromModule(allowlistModule);
            for (String s : players) {
                if (!potentialTarget.getName().getString().equalsIgnoreCase(s)) continue;
                return true;
            }
            return ModuleItem.doesModuleHaveTeamOf(allowlistModule, potentialTarget.getName().getString(), this.level());
        }
        return false;
    }

    public int getShootingSpeed() {
        return this.hasSpeedModule() ? 5 : 10;
    }

    @Override
    public void shutDown() {
        IEMPAffected.super.shutDown();
        this.setTarget(null);
    }

    @Override
    public boolean isShutDown() {
        return (Boolean)this.entityData.get(SHUT_DOWN);
    }

    @Override
    public void setShutDown(boolean shutDown) {
        this.entityData.set(SHUT_DOWN, (Object)shutDown);
    }

    public boolean doHurtTarget(Entity entity) {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    public boolean isAttackable() {
        return false;
    }

    public boolean attackable() {
        return false;
    }

    public boolean checkSpawnRules(LevelAccessor level, MobSpawnType reason) {
        return false;
    }

    public void jumpFromGround() {
    }

    public boolean isPathFinding() {
        return false;
    }

    public void checkDespawn() {
    }

    public boolean removeWhenFarAway(double distanceClosestToPlayer) {
        return false;
    }

    public void playerTouch(Player entity) {
    }

    public void move(MoverType type, Vec3 vec) {
    }

    protected void doPush(Entity entity) {
    }

    protected void pushEntities() {
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean isPickable() {
        return true;
    }

    public boolean isPushable() {
        return false;
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    public void tickLeash() {
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void setAnimateUpwards(boolean animateUpwards) {
        this.animateUpwards = animateUpwards;
    }

    public boolean animatesUpwards() {
        return this.animateUpwards;
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
    }

    public boolean isAnimating() {
        return this.animate;
    }

    public float getOriginalHeadRotation() {
        return this.oHeadRotation;
    }

    public float getHeadRotation() {
        return this.headRotation;
    }

    public static enum SentryMode {
        CAMOUFLAGE_HP(1, TargetingMode.PLAYERS_AND_MOBS, 1),
        CAMOUFLAGE_H(1, TargetingMode.MOBS, 3),
        CAMOUFLAGE_P(1, TargetingMode.PLAYERS, 5),
        AGGRESSIVE_HP(0, TargetingMode.PLAYERS_AND_MOBS, 0),
        AGGRESSIVE_H(0, TargetingMode.MOBS, 2),
        AGGRESSIVE_P(0, TargetingMode.PLAYERS, 4),
        IDLE(-1, null, 6);

        private final int type;
        private final TargetingMode targetingMode;
        private final int descriptionKeyIndex;

        private SentryMode(int type, TargetingMode targetingMode, int descriptionKeyIndex) {
            this.type = type;
            this.targetingMode = targetingMode;
            this.descriptionKeyIndex = descriptionKeyIndex;
        }

        public boolean isAggressive() {
            return this.type == 0;
        }

        public boolean isCamouflage() {
            return this.type == 1;
        }

        public boolean attacksHostile() {
            return this.targetingMode != null && this.targetingMode.allowsMobs();
        }

        public boolean attacksPlayers() {
            return this.targetingMode != null && this.targetingMode.allowsPlayers();
        }

        public String getModeKey() {
            String key = "messages.securitycraft:sentry.mode";
            return this.isAggressive() ? key + "0" : (this.isCamouflage() ? key + "1" : key + "2");
        }

        public String getTargetKey() {
            String key = "gui.securitycraft:srat.targets";
            return switch (this.targetingMode) {
                case TargetingMode.PLAYERS_AND_MOBS -> key + "1";
                case TargetingMode.MOBS -> key + "2";
                case TargetingMode.PLAYERS -> key + "3";
                default -> "";
            };
        }

        public String getDescriptionKey() {
            return "messages.securitycraft:sentry.descriptionMode" + this.descriptionKeyIndex;
        }
    }
}

