/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.inventory;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.items.UniversalBlockReinforcerItem;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class BlockReinforcerMenu
extends AbstractContainerMenu {
    private final ItemStack blockReinforcer;
    private final SimpleContainer itemInventory = new SimpleContainer(2);
    public final SlotBlockReinforcer reinforcingSlot;
    public final SlotBlockReinforcer unreinforcingSlot;
    public final boolean isLvl1;
    public final boolean isReinforcing;

    public BlockReinforcerMenu(int windowId, Inventory inventory, boolean isLvl1) {
        super((MenuType)SCContent.BLOCK_REINFORCER_MENU.get(), windowId);
        int i;
        this.blockReinforcer = inventory.getSelected().getItem() instanceof UniversalBlockReinforcerItem ? inventory.getSelected() : (ItemStack)inventory.offhand.get(0);
        this.isLvl1 = isLvl1;
        this.isReinforcing = UniversalBlockReinforcerItem.isReinforcing(this.blockReinforcer);
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, 9 + j + i * 9, 8 + j * 18, 104 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 162));
        }
        this.reinforcingSlot = new SlotBlockReinforcer((Container)this.itemInventory, 0, 26, 20, true);
        this.addSlot(this.reinforcingSlot);
        if (!isLvl1) {
            this.unreinforcingSlot = new SlotBlockReinforcer((Container)this.itemInventory, 1, 26, 45, false);
            this.addSlot(this.unreinforcingSlot);
        } else {
            this.unreinforcingSlot = null;
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void removed(Player player) {
        ItemStack overflowStack;
        ServerPlayer serverPlayer;
        super.removed(player);
        if (!player.isAlive() || player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).hasDisconnected()) {
            for (int slot = 0; slot < this.itemInventory.getContainerSize(); ++slot) {
                player.drop(this.itemInventory.removeItemNoUpdate(slot), false);
            }
            return;
        }
        if (!this.itemInventory.getItem(0).isEmpty()) {
            if (this.itemInventory.getItem(0).getCount() > this.reinforcingSlot.output.getCount()) {
                overflowStack = this.itemInventory.getItem(0).copy();
                overflowStack.setCount(this.itemInventory.getItem(0).getCount() - this.reinforcingSlot.output.getCount());
                player.drop(overflowStack, false);
            }
            player.drop(this.reinforcingSlot.output, false);
            this.blockReinforcer.hurtAndBreak(this.reinforcingSlot.output.getCount(), (LivingEntity)player, p -> p.broadcastBreakEvent(p.getUsedItemHand()));
        }
        if (!this.isLvl1 && !this.itemInventory.getItem(1).isEmpty()) {
            if (this.itemInventory.getItem(1).getCount() > this.unreinforcingSlot.output.getCount()) {
                overflowStack = this.itemInventory.getItem(1).copy();
                overflowStack.setCount(this.itemInventory.getItem(1).getCount() - this.unreinforcingSlot.output.getCount());
                player.drop(overflowStack, false);
            }
            player.drop(this.unreinforcingSlot.output, false);
            this.blockReinforcer.hurtAndBreak(this.unreinforcingSlot.output.getCount(), (LivingEntity)player, p -> p.broadcastBreakEvent(p.getUsedItemHand()));
        }
    }

    public ItemStack quickMoveStack(Player player, int id) {
        ItemStack slotStackCopy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(id);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            slotStackCopy = slotStack.copy();
            if (id >= 36) {
                if (!this.moveItemStackTo(slotStack, 0, 36, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, slotStackCopy);
            } else if (id < 36 && !this.moveItemStackTo(slotStack, 36, this.fixSlot(38), false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == slotStackCopy.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return slotStackCopy;
    }

    private int fixSlot(int slot) {
        return this.isLvl1 ? slot - 1 : slot;
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        ItemStack slotStack;
        Slot slot;
        boolean merged = false;
        int currentIndex = startIndex;
        if (useEndIndex) {
            currentIndex = endIndex - 1;
        }
        if (stack.isStackable()) {
            while (stack.getCount() > 0 && (!useEndIndex && currentIndex < endIndex || useEndIndex && currentIndex >= startIndex)) {
                slot = (Slot)this.slots.get(currentIndex);
                slotStack = slot.getItem();
                if (!slotStack.isEmpty() && ItemStack.isSameItemSameTags((ItemStack)stack, (ItemStack)slotStack) && slot.mayPlace(stack)) {
                    int combinedCount = slotStack.getCount() + stack.getCount();
                    if (combinedCount <= stack.getMaxStackSize()) {
                        stack.setCount(0);
                        slotStack.setCount(combinedCount);
                        slot.setChanged();
                        merged = true;
                    } else if (slotStack.getCount() < stack.getMaxStackSize()) {
                        stack.shrink(stack.getMaxStackSize() - slotStack.getCount());
                        slotStack.setCount(stack.getMaxStackSize());
                        slot.setChanged();
                        merged = true;
                    }
                }
                if (useEndIndex) {
                    --currentIndex;
                    continue;
                }
                ++currentIndex;
            }
        }
        if (stack.getCount() > 0) {
            currentIndex = useEndIndex ? endIndex - 1 : startIndex;
            while (!useEndIndex && currentIndex < endIndex || useEndIndex && currentIndex >= startIndex) {
                slot = (Slot)this.slots.get(currentIndex);
                slotStack = slot.getItem();
                if (slotStack.isEmpty() && slot.mayPlace(stack)) {
                    slot.set(stack.copy());
                    slot.setChanged();
                    stack.setCount(0);
                    merged = true;
                    break;
                }
                if (useEndIndex) {
                    --currentIndex;
                    continue;
                }
                ++currentIndex;
            }
        }
        return merged;
    }

    public void clicked(int slot, int dragType, ClickType clickType, Player player) {
        if (slot < 0 || this.getSlot(slot) == null || !(this.getSlot(slot).getItem().getItem() instanceof UniversalBlockReinforcerItem)) {
            super.clicked(slot, dragType, clickType, player);
        }
    }

    public class SlotBlockReinforcer
    extends Slot {
        private final boolean reinforce;
        private ItemStack output;

        public SlotBlockReinforcer(Container inventory, int index, int x, int y, boolean reinforce) {
            super(inventory, index, x, y);
            this.output = ItemStack.EMPTY;
            this.reinforce = reinforce;
        }

        public boolean mayPlace(ItemStack stack) {
            if (!BlockReinforcerMenu.this.itemInventory.getItem((this.index + 1) % 2).isEmpty()) {
                return false;
            }
            return (this.reinforce ? IReinforcedBlock.VANILLA_TO_SECURITYCRAFT : IReinforcedBlock.SECURITYCRAFT_TO_VANILLA).containsKey(Block.byItem((Item)stack.getItem()));
        }

        public void setChanged() {
            Block block;
            ItemStack stack = BlockReinforcerMenu.this.itemInventory.getItem(this.index % 2);
            if (!stack.isEmpty() && (block = (this.reinforce ? IReinforcedBlock.VANILLA_TO_SECURITYCRAFT : IReinforcedBlock.SECURITYCRAFT_TO_VANILLA).get(Block.byItem((Item)stack.getItem()))) != null) {
                boolean isLvl3 = BlockReinforcerMenu.this.blockReinforcer.getItem() == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_3.get();
                this.output = new ItemStack((ItemLike)block);
                this.output.setCount(isLvl3 ? stack.getCount() : Math.min(stack.getCount(), BlockReinforcerMenu.this.blockReinforcer.getMaxDamage() - BlockReinforcerMenu.this.blockReinforcer.getDamageValue()));
            }
        }

        public ItemStack getOutput() {
            return this.output;
        }
    }
}

