/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.inventory;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class CustomizeBlockMenu
extends AbstractContainerMenu {
    public final IModuleInventory moduleInv;
    private ContainerLevelAccess worldPosCallable;
    private int maxSlots;
    public final int entityId;

    public CustomizeBlockMenu(int windowId, Level level, BlockPos pos, Inventory inventory) {
        super((MenuType)SCContent.CUSTOMIZE_BLOCK_MENU.get(), windowId);
        this.moduleInv = (IModuleInventory)level.getBlockEntity(pos);
        this.worldPosCallable = ContainerLevelAccess.create((Level)level, (BlockPos)pos);
        this.addSlots(inventory);
        this.entityId = -1;
    }

    public CustomizeBlockMenu(int windowId, Level level, BlockPos pos, int entityId, Inventory inventory) {
        super((MenuType)SCContent.CUSTOMIZE_ENTITY_MENU.get(), windowId);
        this.moduleInv = (IModuleInventory)level.getEntity(entityId);
        this.worldPosCallable = ContainerLevelAccess.create((Level)level, (BlockPos)pos);
        this.addSlots(inventory);
        this.entityId = entityId;
    }

    public void addSlots(Inventory inventory) {
        int i;
        int slotId = 0;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 142));
        }
        if (this.moduleInv.enableHack()) {
            slotId = 100;
        }
        if (this.moduleInv.getMaxNumberOfModules() == 1) {
            this.addSlot((Slot)new CustomSlotItemHandler((IItemHandler)this.moduleInv, slotId, 80, 20));
        } else if (this.moduleInv.getMaxNumberOfModules() == 2) {
            this.addSlot((Slot)new CustomSlotItemHandler((IItemHandler)this.moduleInv, slotId++, 70, 20));
            this.addSlot((Slot)new CustomSlotItemHandler((IItemHandler)this.moduleInv, slotId++, 88, 20));
        } else if (this.moduleInv.getMaxNumberOfModules() == 3) {
            this.addSlot((Slot)new CustomSlotItemHandler((IItemHandler)this.moduleInv, slotId++, 62, 20));
            this.addSlot((Slot)new CustomSlotItemHandler((IItemHandler)this.moduleInv, slotId++, 80, 20));
            this.addSlot((Slot)new CustomSlotItemHandler((IItemHandler)this.moduleInv, slotId++, 98, 20));
        } else if (this.moduleInv.getMaxNumberOfModules() == 4) {
            this.addSlot((Slot)new CustomSlotItemHandler((IItemHandler)this.moduleInv, slotId++, 52, 20));
            this.addSlot((Slot)new CustomSlotItemHandler((IItemHandler)this.moduleInv, slotId++, 70, 20));
            this.addSlot((Slot)new CustomSlotItemHandler((IItemHandler)this.moduleInv, slotId++, 88, 20));
            this.addSlot((Slot)new CustomSlotItemHandler((IItemHandler)this.moduleInv, slotId++, 106, 20));
        } else if (this.moduleInv.getMaxNumberOfModules() == 5) {
            this.addSlot((Slot)new CustomSlotItemHandler((IItemHandler)this.moduleInv, slotId++, 34, 20));
            this.addSlot((Slot)new CustomSlotItemHandler((IItemHandler)this.moduleInv, slotId++, 52, 20));
            this.addSlot((Slot)new CustomSlotItemHandler((IItemHandler)this.moduleInv, slotId++, 70, 20));
            this.addSlot((Slot)new CustomSlotItemHandler((IItemHandler)this.moduleInv, slotId++, 88, 20));
            this.addSlot((Slot)new CustomSlotItemHandler((IItemHandler)this.moduleInv, slotId++, 106, 20));
        } else if (this.moduleInv.getMaxNumberOfModules() == 6) {
            this.addSlot((Slot)new CustomSlotItemHandler((IItemHandler)this.moduleInv, slotId++, 16, 20));
            this.addSlot((Slot)new CustomSlotItemHandler((IItemHandler)this.moduleInv, slotId++, 34, 20));
            this.addSlot((Slot)new CustomSlotItemHandler((IItemHandler)this.moduleInv, slotId++, 52, 20));
            this.addSlot((Slot)new CustomSlotItemHandler((IItemHandler)this.moduleInv, slotId++, 70, 20));
            this.addSlot((Slot)new CustomSlotItemHandler((IItemHandler)this.moduleInv, slotId++, 88, 20));
            this.addSlot((Slot)new CustomSlotItemHandler((IItemHandler)this.moduleInv, slotId++, 106, 20));
        }
        this.maxSlots = 36 + this.moduleInv.getMaxNumberOfModules();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack copy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            boolean isModule = slotStack.getItem() instanceof ModuleItem;
            copy = slotStack.copy();
            if (index >= 36 && index <= this.maxSlots) {
                if (!this.moveItemStackTo(slotStack, 0, 36, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (index >= 27 && index <= 35) {
                if (isModule && !this.moveItemStackTo(slotStack, 36, this.maxSlots, false)) {
                    return ItemStack.EMPTY;
                }
                if (!this.moveItemStackTo(slotStack, 0, 27, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (index <= 26) {
                if (isModule && !this.moveItemStackTo(slotStack, 36, this.maxSlots, false)) {
                    return ItemStack.EMPTY;
                }
                if (!this.moveItemStackTo(slotStack, 27, 36, false)) {
                    return ItemStack.EMPTY;
                }
            }
            slot.onQuickCraft(slotStack, copy);
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return copy;
    }

    public boolean stillValid(Player player) {
        return (Boolean)this.worldPosCallable.evaluate((level, pos) -> {
            IModuleInventory patt5318$temp = this.moduleInv;
            if (patt5318$temp instanceof BlockEntity) {
                BlockEntity be = (BlockEntity)patt5318$temp;
                if (!level.getBlockState(pos).is(be.getBlockState().getBlock())) {
                    return false;
                }
            }
            return player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0;
        }, (Object)true);
    }

    public int getMaxSlots() {
        return this.maxSlots;
    }

    private class CustomSlotItemHandler
    extends SlotItemHandler {
        private final int index;

        public CustomSlotItemHandler(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
            this.index = index;
        }

        public void onQuickCraft(ItemStack newStack, ItemStack oldStack) {
            Item item;
            if ((this.index >= 36 || this.index < CustomizeBlockMenu.this.maxSlots) && (item = oldStack.getItem()) instanceof ModuleItem) {
                ModuleItem module = (ModuleItem)item;
                CustomizeBlockMenu.this.moduleInv.onModuleRemoved(oldStack, module.getModuleType(), false);
                IModuleInventory iModuleInventory = CustomizeBlockMenu.this.moduleInv;
                if (iModuleInventory instanceof LinkableBlockEntity) {
                    LinkableBlockEntity lbe = (LinkableBlockEntity)iModuleInventory;
                    lbe.propagate((ILinkedAction)new ILinkedAction.ModuleRemoved(((ModuleItem)oldStack.getItem()).getModuleType(), false), lbe);
                }
                CustomizeBlockMenu.this.broadcastChanges();
            }
        }

        public void initialize(ItemStack stack) {
            this.set(stack);
        }

        public void set(ItemStack stack) {
            super.set(stack);
            CustomizeBlockMenu.this.broadcastChanges();
        }

        public ItemStack remove(int amount) {
            ItemStack stack = super.remove(amount);
            if (!stack.isEmpty()) {
                CustomizeBlockMenu.this.broadcastChanges();
            }
            return stack;
        }
    }
}

