/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.inventory;

import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ItemContainer
implements Container {
    private final ItemStack containerStack;
    private final NonNullList<ItemStack> inventory;
    private final int maxStackSize;

    private ItemContainer(ItemStack containerStack, int inventorySize, int maxStackSize) {
        this.containerStack = containerStack;
        this.maxStackSize = maxStackSize;
        this.inventory = NonNullList.withSize((int)inventorySize, (Object)ItemStack.EMPTY);
        this.load(containerStack.getOrCreateTag());
    }

    public static ItemContainer briefcase(ItemStack briefcase) {
        return new ItemContainer(briefcase, 12, 64);
    }

    public static ItemContainer keycardHolder(ItemStack keycardHolder) {
        return new ItemContainer(keycardHolder, 5, 1);
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public void load(CompoundTag tag) {
        ListTag items = tag.getList("ItemInventory", 10);
        for (int i = 0; i < items.size(); ++i) {
            CompoundTag item = items.getCompound(i);
            int slot = item.getInt("Slot");
            if (slot >= this.getContainerSize()) continue;
            this.inventory.set(slot, (Object)ItemStack.of((CompoundTag)item));
        }
    }

    public void save(CompoundTag tag) {
        ListTag items = new ListTag();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (this.getItem(i).isEmpty()) continue;
            CompoundTag item = new CompoundTag();
            item.putInt("Slot", i);
            this.getItem(i).save(item);
            items.add((Object)item);
        }
        tag.put("ItemInventory", (Tag)items);
    }

    public ItemStack removeItem(int index, int size) {
        ItemStack stack = this.getItem(index);
        if (!stack.isEmpty()) {
            if (stack.getCount() > size) {
                stack = stack.split(size);
                this.setChanged();
            } else {
                this.setItem(index, ItemStack.EMPTY);
            }
        }
        return stack;
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack stack = this.getItem(index);
        this.setItem(index, ItemStack.EMPTY);
        return stack;
    }

    public void setItem(int index, ItemStack itemStack) {
        this.inventory.set(index, (Object)itemStack);
        if (!itemStack.isEmpty() && itemStack.getCount() > this.getMaxStackSize()) {
            itemStack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public void setChanged() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (this.getItem(i).isEmpty() || this.getItem(i).getCount() != 0) continue;
            this.inventory.set(i, (Object)ItemStack.EMPTY);
        }
        this.save(this.containerStack.getOrCreateTag());
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void startOpen(Player player) {
    }

    public void stopOpen(Player player) {
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return true;
    }

    public void clearContent() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            this.inventory.set(i, (Object)ItemStack.EMPTY);
        }
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.inventory) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getContainerStack() {
        return this.containerStack;
    }
}

