/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.inventory;

import net.geforcemods.securitycraft.inventory.DisguiseModuleMenu;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ModuleItemContainer
implements Container {
    private final ItemStack module;
    private NonNullList<ItemStack> moduleInventory;
    private DisguiseModuleMenu menu;

    public ModuleItemContainer(ItemStack moduleStack) {
        this.module = moduleStack;
        if (!(moduleStack.getItem() instanceof ModuleItem)) {
            return;
        }
        this.moduleInventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
        if (!this.module.hasTag()) {
            this.module.setTag(new CompoundTag());
        }
        this.load(this.module.getTag());
    }

    public int getContainerSize() {
        return 1;
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.moduleInventory.get(index);
    }

    public void load(CompoundTag tag) {
        ListTag items = tag.getList("ItemInventory", 10);
        for (int i = 0; i < items.size(); ++i) {
            CompoundTag item = items.getCompound(i);
            int slot = item.getInt("Slot");
            if (slot >= this.getContainerSize()) continue;
            this.moduleInventory.set(slot, (Object)ItemStack.of((CompoundTag)item));
        }
    }

    public void save(CompoundTag tag) {
        ListTag items = new ListTag();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (this.getItem(i).isEmpty()) continue;
            CompoundTag item = new CompoundTag();
            item.putInt("Slot", i);
            this.getItem(i).save(item);
            items.add((Object)item);
        }
        tag.put("ItemInventory", (Tag)items);
    }

    public ItemStack removeItem(int index, int size) {
        ItemStack stack = this.getItem(index);
        if (!stack.isEmpty()) {
            if (stack.getCount() > size) {
                stack = stack.split(size);
            } else {
                this.setItem(index, ItemStack.EMPTY);
            }
            this.setChanged();
        }
        return stack;
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack stack = this.getItem(index);
        this.setItem(index, ItemStack.EMPTY);
        this.setChanged();
        return stack;
    }

    public void setItem(int index, ItemStack stack) {
        this.moduleInventory.set(index, (Object)stack);
        if (!stack.isEmpty() && stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    public int getMaxStackSize() {
        return 64;
    }

    public void setChanged() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (this.getItem(i).isEmpty() || this.getItem(i).getCount() != 0) continue;
            this.moduleInventory.set(i, (Object)ItemStack.EMPTY);
        }
        this.save(this.module.getOrCreateTag());
        if (this.menu != null) {
            this.menu.slotsChanged(this);
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void startOpen(Player player) {
    }

    public void stopOpen(Player player) {
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return true;
    }

    public void clearContent() {
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.moduleInventory) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void setMenu(DisguiseModuleMenu menu) {
        this.menu = menu;
    }

    public ItemStack getModule() {
        return this.module;
    }
}

