/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.network.server.RemoveCameraTag;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;

public class CameraMonitorItem
extends Item {
    public CameraMonitorItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        BlockPos pos;
        Player player = ctx.getPlayer();
        Level level = ctx.getLevel();
        if (level.getBlockState(pos = ctx.getClickedPos()).getBlock() == SCContent.SECURITY_CAMERA.get() && !PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player)) {
            SecurityCameraBlockEntity be = (SecurityCameraBlockEntity)level.getBlockEntity(pos);
            if (!be.isOwnedBy((Entity)player) && !be.isAllowed((Entity)player)) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((CameraMonitorItem)((Object)SCContent.CAMERA_MONITOR.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:cameraMonitor.cannotView", new Object[0]), ChatFormatting.RED);
                return InteractionResult.FAIL;
            }
            ItemStack stack = ctx.getItemInHand();
            if (stack.getTag() == null) {
                stack.setTag(new CompoundTag());
            }
            GlobalPos view = GlobalPos.of((ResourceKey)player.level().dimension(), (BlockPos)pos);
            if (CameraMonitorItem.isCameraAdded(stack.getTag(), view)) {
                stack.getTag().remove(CameraMonitorItem.getTagNameFromPosition(stack.getTag(), view));
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((CameraMonitorItem)((Object)SCContent.CAMERA_MONITOR.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:cameraMonitor.unbound", Utils.getFormattedCoordinates(pos)), ChatFormatting.RED);
                return InteractionResult.SUCCESS;
            }
            for (int i = 1; i <= 30; ++i) {
                if (stack.getTag().contains("Camera" + i)) continue;
                stack.getTag().putString("Camera" + i, LevelUtils.toNBTString(view));
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((CameraMonitorItem)((Object)SCContent.CAMERA_MONITOR.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:cameraMonitor.bound", Utils.getFormattedCoordinates(pos)), ChatFormatting.GREEN);
                break;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!stack.hasTag()) {
            if (!CameraMonitorItem.hasCameraAdded(stack.getTag())) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((CameraMonitorItem)((Object)SCContent.CAMERA_MONITOR.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:cameraMonitor.rightclickToView", new Object[0]), ChatFormatting.RED);
                return InteractionResultHolder.pass((Object)stack);
            }
        } else {
            this.updateTagWithNames(stack, level);
        }
        if (level.isClientSide && stack.getItem() == SCContent.CAMERA_MONITOR.get()) {
            ClientHandler.displayCameraMonitorScreen(stack);
        }
        return InteractionResultHolder.consume((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        if (stack.getTag() == null) {
            return;
        }
        tooltip.add((Component)Utils.localize("tooltip.securitycraft:cameraMonitor", CameraMonitorItem.getNumberOfCamerasBound(stack.getTag()) + "/30").setStyle(Utils.GRAY_STYLE));
    }

    public static String getTagNameFromPosition(CompoundTag tag, GlobalPos view) {
        for (int i = 1; i <= 30; ++i) {
            String[] coords;
            if (!tag.contains("Camera" + i) || !LevelUtils.checkCoordinates(view, coords = tag.getString("Camera" + i).split(" "))) continue;
            return "Camera" + i;
        }
        return "";
    }

    public static boolean hasCameraAdded(CompoundTag tag) {
        if (tag == null) {
            return false;
        }
        for (int i = 1; i <= 30; ++i) {
            if (!tag.contains("Camera" + i)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCameraAdded(CompoundTag tag, GlobalPos view) {
        for (int i = 1; i <= 30; ++i) {
            String[] coords;
            if (!tag.contains("Camera" + i) || !LevelUtils.checkCoordinates(view, coords = tag.getString("Camera" + i).split(" "))) continue;
            return true;
        }
        return false;
    }

    public static void removeCameraOnClient(int camID, CompoundTag stackTag) {
        if (stackTag != null) {
            stackTag.remove(CameraMonitorItem.getTagNameFromPosition(stackTag, (GlobalPos)CameraMonitorItem.getCameraPositions(stackTag).get(camID - 1).getLeft()));
        }
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new RemoveCameraTag(camID)});
    }

    public static List<Pair<GlobalPos, String>> getCameraPositions(CompoundTag tag) {
        ArrayList<Pair<GlobalPos, String>> list = new ArrayList<Pair<GlobalPos, String>>();
        for (int i = 1; i <= 30; ++i) {
            if (tag != null && tag.contains("Camera" + i)) {
                String[] coords = tag.getString("Camera" + i).split(" ");
                BlockPos pos = new BlockPos(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]));
                String nameKey = "camera" + i + "_name";
                String cameraName = null;
                if (tag.contains(nameKey)) {
                    cameraName = tag.getString(nameKey);
                }
                list.add((Pair<GlobalPos, String>)Pair.of((Object)GlobalPos.of((ResourceKey)(coords.length == 4 ? ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)new ResourceLocation(coords[3])) : Level.OVERWORLD), (BlockPos)pos), (Object)cameraName));
                continue;
            }
            list.add((Pair<GlobalPos, String>)Pair.of(null, null));
        }
        return list;
    }

    public static int getNumberOfCamerasBound(CompoundTag tag) {
        if (tag == null) {
            return 0;
        }
        int amount = 0;
        for (int i = 1; i <= 30; ++i) {
            if (!tag.contains("Camera" + i)) continue;
            ++amount;
        }
        return amount;
    }

    private void updateTagWithNames(ItemStack stack, Level level) {
        if (!stack.hasTag()) {
            return;
        }
        CompoundTag tag = stack.getTag();
        for (int i = 1; i <= 30; ++i) {
            SecurityCameraBlockEntity camera;
            BlockPos camPos;
            String cameraString = tag.getString("Camera" + i);
            String[] globalPos = cameraString.split(" ");
            String nameKey = "camera" + i + "_name";
            if (globalPos.length != 3 && (globalPos.length != 4 || !level.dimension().location().toString().equals(globalPos[3])) || !level.isLoaded(camPos = new BlockPos(Integer.parseInt(globalPos[0]), Integer.parseInt(globalPos[1]), Integer.parseInt(globalPos[2])))) continue;
            BlockEntity be = level.getBlockEntity(camPos);
            if (be instanceof SecurityCameraBlockEntity && (camera = (SecurityCameraBlockEntity)be).hasCustomName()) {
                tag.putString(nameKey, camera.getCustomName().getString());
                continue;
            }
            tag.remove(nameKey);
        }
    }
}

