/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.inventory.BriefcaseMenu;
import net.geforcemods.securitycraft.inventory.ItemContainer;
import net.geforcemods.securitycraft.items.BriefcaseItem;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class CodebreakerItem
extends Item {
    public static final ResourceLocation STATE_PROPERTY = new ResourceLocation("securitycraft", "codebreaker_state");
    public static final String WORKING = "working";
    public static final String LAST_USED_TIME = "last_used_time";
    public static final String WAS_SUCCESSFUL = "was_successful";

    public CodebreakerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack briefcase;
        ItemStack codebreaker = player.getItemInHand(hand);
        if (hand == InteractionHand.MAIN_HAND && (briefcase = player.getOffhandItem()).is((Item)SCContent.BRIEFCASE.get())) {
            if (BriefcaseItem.isOwnedBy(briefcase, player) && !player.isCreative()) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((CodebreakerItem)((Object)SCContent.CODEBREAKER.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:codebreaker.owned", new Object[0]), ChatFormatting.RED);
            } else {
                double chance = (Double)ConfigHandler.SERVER.codebreakerChance.get();
                if (chance < 0.0) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((CodebreakerItem)((Object)SCContent.CODEBREAKER.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:codebreakerDisabled", new Object[0]), ChatFormatting.RED);
                } else {
                    codebreaker.hurtAndBreak(1, (LivingEntity)player, p -> p.broadcastBreakEvent(hand));
                    if (!level.isClientSide) {
                        if (!player.isCreative() && CodebreakerItem.wasRecentlyUsed(codebreaker)) {
                            return InteractionResultHolder.pass((Object)codebreaker);
                        }
                        boolean isSuccessful = player.isCreative() || SecurityCraft.RANDOM.nextDouble() < chance;
                        CompoundTag tag = codebreaker.getOrCreateTag();
                        tag.putLong(LAST_USED_TIME, System.currentTimeMillis());
                        tag.putBoolean(WAS_SUCCESSFUL, isSuccessful);
                        if (isSuccessful) {
                            player.openMenu(new MenuProvider(){

                                public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
                                    return new BriefcaseMenu(windowId, inv, ItemContainer.briefcase(briefcase));
                                }

                                public Component getDisplayName() {
                                    return briefcase.getHoverName();
                                }
                            });
                        } else {
                            PlayerUtils.sendMessageToPlayer(player, Component.translatable((String)((CodebreakerItem)((Object)SCContent.CODEBREAKER.get())).getDescriptionId()), Utils.localize("messages.securitycraft:codebreaker.failed", new Object[0]), ChatFormatting.RED);
                        }
                    }
                }
            }
            return InteractionResultHolder.success((Object)codebreaker);
        }
        return InteractionResultHolder.pass((Object)codebreaker);
    }

    public static boolean wasRecentlyUsed(ItemStack stack) {
        long lastUsedTime = stack.getOrCreateTag().getLong(LAST_USED_TIME);
        return lastUsedTime != 0L && System.currentTimeMillis() - lastUsedTime < 3000L;
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public Rarity getRarity(ItemStack stack) {
        return Rarity.RARE;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }
}

