/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;

public class IncognitoMaskItem
extends ArmorItem {
    private static final ArmorMaterial INCOGNITO_MASK_ARMOR_MATERIAL = new IncognitoMaskArmorMaterial();

    public IncognitoMaskItem(Item.Properties properties) {
        super(INCOGNITO_MASK_ARMOR_MATERIAL, ArmorItem.Type.HELMET, properties);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    private static class IncognitoMaskArmorMaterial
    implements ArmorMaterial {
        private IncognitoMaskArmorMaterial() {
        }

        public int getDurabilityForType(ArmorItem.Type type) {
            return 0;
        }

        public int getDefenseForType(ArmorItem.Type type) {
            return 0;
        }

        public int getEnchantmentValue() {
            return 0;
        }

        public SoundEvent getEquipSound() {
            return SoundEvents.ARMOR_EQUIP_GENERIC;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.EMPTY;
        }

        public String getName() {
            return "securitycraft:incognito_mask";
        }

        public float getToughness() {
            return 0.0f;
        }

        public float getKnockbackResistance() {
            return 0.0f;
        }
    }
}

