/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.inventory.ItemContainer;
import net.geforcemods.securitycraft.inventory.KeycardHolderMenu;
import net.geforcemods.securitycraft.items.KeycardItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class KeycardHolderItem
extends Item {
    public static final ResourceLocation COUNT_PROPERTY = new ResourceLocation("securitycraft", "keycard_count");

    public KeycardHolderItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        final ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            player.openMenu(new MenuProvider(){

                public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
                    return new KeycardHolderMenu(id, playerInventory, ItemContainer.keycardHolder(stack));
                }

                public Component getDisplayName() {
                    return stack.getHoverName();
                }
            });
        }
        return InteractionResultHolder.consume((Object)stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.is(newStack.getItem());
    }

    public static int getCardCount(ItemStack stack) {
        int count = 0;
        ListTag items = stack.getOrCreateTag().getList("ItemInventory", 10);
        for (int i = 0; i < items.size(); ++i) {
            CompoundTag item = items.getCompound(i);
            int slot = item.getInt("Slot");
            if (slot >= 5 || !(ItemStack.of((CompoundTag)item).getItem() instanceof KeycardItem)) continue;
            ++count;
        }
        return count;
    }
}

