/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;

public class KeycardItem
extends Item {
    private static final Component LINK_INFO = Component.translatable((String)"tooltip.securitycraft:keycard.link_info").setStyle(Utils.GRAY_STYLE);
    public static final Component LIMITED_INFO = Component.translatable((String)"tooltip.securitycraft:keycard.limited_info").setStyle(Utils.GRAY_STYLE);
    private final int level;

    public KeycardItem(Item.Properties properties, int level) {
        super(properties);
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public void appendHoverText(ItemStack stack, Level level, List<Component> list, TooltipFlag flag) {
        if (this == SCContent.LIMITED_USE_KEYCARD.get()) {
            return;
        }
        CompoundTag tag = stack.getOrCreateTag();
        if (tag.getBoolean("linked")) {
            String usableBy = tag.getString("usable_by");
            list.add((Component)Component.translatable((String)"tooltip.securitycraft:keycard.signature", (Object[])new Object[]{StringUtils.leftPad((String)("" + tag.getInt("signature")), (int)5, (String)"0")}).setStyle(Utils.GRAY_STYLE));
            list.add((Component)Component.translatable((String)"tooltip.securitycraft:keycard.reader_owner", (Object[])new Object[]{tag.getString("ownerName")}).setStyle(Utils.GRAY_STYLE));
            if (!usableBy.isBlank()) {
                list.add((Component)Component.translatable((String)"tooltip.securitycraft:keycard.usable_by", (Object[])new Object[]{Component.literal((String)usableBy)}).setStyle(Utils.GRAY_STYLE));
            } else {
                list.add((Component)Component.translatable((String)"tooltip.securitycraft:keycard.usable_by", (Object[])new Object[]{Component.translatable((String)"tooltip.securitycraft:keycard.everyone")}).setStyle(Utils.GRAY_STYLE));
            }
        } else {
            list.add(LINK_INFO);
        }
        if (tag.getBoolean("limited")) {
            list.add((Component)Component.translatable((String)"tooltip.securitycraft:keycard.uses", (Object[])new Object[]{tag.getInt("uses")}).setStyle(Utils.GRAY_STYLE));
        } else {
            list.add(LIMITED_INFO);
        }
    }
}

