/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.inventory.DisguiseModuleMenu;
import net.geforcemods.securitycraft.inventory.ModuleItemContainer;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.scores.PlayerTeam;

public class ModuleItem
extends Item {
    private static final MutableComponent MODIFIABLE = Component.translatable((String)"tooltip.securitycraft:module.modifiable").setStyle(Utils.GRAY_STYLE);
    private static final MutableComponent NOT_MODIFIABLE = Component.translatable((String)"tooltip.securitycraft:module.notModifiable").setStyle(Utils.GRAY_STYLE);
    public static final int MAX_PLAYERS = 50;
    private final ModuleType module;
    private final boolean containsCustomData;
    private final boolean canBeCustomized;

    public ModuleItem(Item.Properties properties, ModuleType module, boolean containsCustomData) {
        this(properties, module, containsCustomData, false);
    }

    public ModuleItem(Item.Properties properties, ModuleType module, boolean containsCustomData, boolean canBeCustomized) {
        super(properties);
        this.module = module;
        this.containsCustomData = containsCustomData;
        this.canBeCustomized = canBeCustomized;
    }

    public InteractionResult useOn(UseOnContext ctx) {
        BlockEntity blockEntity = ctx.getLevel().getBlockEntity(ctx.getClickedPos());
        if (blockEntity instanceof IModuleInventory) {
            IOwnable ownable;
            IModuleInventory inv = (IModuleInventory)blockEntity;
            ItemStack stack = ctx.getItemInHand();
            ModuleType type = ((ModuleItem)stack.getItem()).getModuleType();
            if (inv instanceof IOwnable && !(ownable = (IOwnable)((Object)inv)).isOwnedBy((Entity)ctx.getPlayer())) {
                return InteractionResult.PASS;
            }
            if (inv.acceptsModule(type) && !inv.hasModule(type)) {
                inv.insertModule(stack, false);
                if (inv instanceof LinkableBlockEntity) {
                    LinkableBlockEntity linkable = (LinkableBlockEntity)inv;
                    linkable.propagate((ILinkedAction)new ILinkedAction.ModuleInserted(stack, (ModuleItem)stack.getItem(), false), linkable);
                }
                if (!ctx.getPlayer().isCreative()) {
                    stack.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, final InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.canBeCustomized()) {
            if (this.module == ModuleType.ALLOWLIST || this.module == ModuleType.DENYLIST) {
                if (level.isClientSide) {
                    ClientHandler.displayEditModuleScreen(stack);
                }
                return InteractionResultHolder.consume((Object)stack);
            }
            if (this.module == ModuleType.DISGUISE) {
                if (!level.isClientSide) {
                    player.openMenu(new MenuProvider(){

                        public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
                            return new DisguiseModuleMenu(windowId, inv, new ModuleItemContainer(player.getItemInHand(hand)));
                        }

                        public Component getDisplayName() {
                            return Component.translatable((String)ModuleItem.this.getDescriptionId());
                        }
                    });
                }
                return InteractionResultHolder.consume((Object)stack);
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Level level, List<Component> list, TooltipFlag flag) {
        Block addon;
        if (this.containsCustomData || this.canBeCustomized()) {
            list.add((Component)MODIFIABLE);
        } else {
            list.add((Component)NOT_MODIFIABLE);
        }
        if (this.canBeCustomized() && (addon = ModuleItem.getBlockAddon(stack)) != null) {
            list.add((Component)Utils.localize("tooltip.securitycraft:module.itemAddons.added", Utils.localize(addon.getDescriptionId(), new Object[0])).setStyle(Utils.GRAY_STYLE));
        }
        if (this.containsCustomData) {
            CompoundTag tag;
            boolean affectsEveryone = false;
            int playerCount = 0;
            int teamCount = 0;
            if (stack.hasTag() && !(affectsEveryone = (tag = stack.getTag()).getBoolean("affectEveryone"))) {
                playerCount = ModuleItem.getPlayersFromModule(stack).size();
                teamCount = tag.getList("ListedTeams", 8).size();
            }
            if (affectsEveryone) {
                list.add((Component)Utils.localize("tooltip.securitycraft.component.list_module_data.affects_everyone", new Object[0]).setStyle(Utils.GRAY_STYLE));
            } else {
                list.add((Component)Utils.localize("tooltip.securitycraft.component.list_module_data.added_players", playerCount).setStyle(Utils.GRAY_STYLE));
                list.add((Component)Utils.localize("tooltip.securitycraft.component.list_module_data.added_teams", teamCount).setStyle(Utils.GRAY_STYLE));
            }
        }
    }

    public ModuleType getModuleType() {
        return this.module;
    }

    public static Block getBlockAddon(ItemStack stack) {
        Item item;
        if (!stack.hasTag()) {
            return null;
        }
        ListTag items = stack.getTag().getList("ItemInventory", 10);
        if (items != null && !items.isEmpty() && (item = ItemStack.of((CompoundTag)items.getCompound(0)).getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return blockItem.getBlock();
        }
        return null;
    }

    public boolean canBeCustomized() {
        return this.canBeCustomized;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean doesModuleHaveTeamOf(ItemStack module, String name, Level level) {
        PlayerTeam team = level.getScoreboard().getPlayersTeam(name);
        if (team == null) return false;
        if (!module.getOrCreateTag().getList("ListedTeams", 8).stream().filter(StringTag.class::isInstance).map(tag -> ((StringTag)tag).getAsString()).anyMatch(team.getName()::equals)) return false;
        return true;
    }

    public static List<String> getPlayersFromModule(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        if (stack.getItem() instanceof ModuleItem && stack.hasTag()) {
            for (int i = 1; i <= 50; ++i) {
                if (stack.getTag().getString("Player" + i) == null || stack.getTag().getString("Player" + i).isEmpty()) continue;
                list.add(stack.getTag().getString("Player" + i).toLowerCase());
            }
        }
        return list;
    }
}

