/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.network.PacketDistributor;

public class SentryRemoteAccessToolItem
extends Item {
    public SentryRemoteAccessToolItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            this.updateTagWithNames(stack, level);
            PacketDistributor.PLAYER.with((Object)((ServerPlayer)player)).send(new CustomPacketPayload[]{new OpenScreen(OpenScreen.DataType.SENTRY_REMOTE_ACCESS_TOOL, stack.getOrCreateTag())});
        }
        return InteractionResultHolder.consume((Object)stack);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        Player player = ctx.getPlayer();
        List sentries = level.getEntitiesOfClass(Sentry.class, new AABB(pos));
        ItemStack stack = ctx.getItemInHand();
        if (!sentries.isEmpty()) {
            Sentry sentry = (Sentry)sentries.get(0);
            BlockPos sentryPos = sentry.blockPosition();
            if (!SentryRemoteAccessToolItem.isSentryAdded(stack, sentryPos)) {
                int nextAvailableSlot = SentryRemoteAccessToolItem.getNextAvailableSlot(stack);
                if (nextAvailableSlot == 0) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((SentryRemoteAccessToolItem)((Object)SCContent.SENTRY_REMOTE_ACCESS_TOOL.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:srat.noSlots", new Object[0]), ChatFormatting.RED);
                    return InteractionResult.FAIL;
                }
                if (!sentry.isOwnedBy((Entity)player)) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((SentryRemoteAccessToolItem)((Object)SCContent.SENTRY_REMOTE_ACCESS_TOOL.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:srat.cantBind", new Object[0]), ChatFormatting.RED);
                    return InteractionResult.FAIL;
                }
                stack.getOrCreateTag().putIntArray("sentry" + nextAvailableSlot, new int[]{sentryPos.getX(), sentryPos.getY(), sentryPos.getZ()});
                if (sentry.hasCustomName()) {
                    stack.getTag().putString("sentry" + nextAvailableSlot + "_name", sentry.getCustomName().getString());
                }
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((SentryRemoteAccessToolItem)((Object)SCContent.SENTRY_REMOTE_ACCESS_TOOL.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:srat.bound", sentryPos), ChatFormatting.GREEN);
            } else {
                this.removeSentry(stack, sentryPos);
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((SentryRemoteAccessToolItem)((Object)SCContent.SENTRY_REMOTE_ACCESS_TOOL.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:srat.unbound", sentryPos), ChatFormatting.RED);
            }
            return InteractionResult.SUCCESS;
        }
        if (!level.isClientSide) {
            this.updateTagWithNames(stack, level);
            PacketDistributor.PLAYER.with((Object)((ServerPlayer)player)).send(new CustomPacketPayload[]{new OpenScreen(OpenScreen.DataType.SENTRY_REMOTE_ACCESS_TOOL, stack.getOrCreateTag())});
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        if (stack.getTag() == null) {
            return;
        }
        for (int i = 1; i <= 12; ++i) {
            List sentries;
            int[] coords = stack.getTag().getIntArray("sentry" + i);
            if (coords.length != 3) {
                tooltip.add((Component)Component.literal((String)(ChatFormatting.GRAY + "---")));
                continue;
            }
            BlockPos pos = new BlockPos(coords[0], coords[1], coords[2]);
            String nameKey = "sentry" + i + "_name";
            String nameToShow = null;
            nameToShow = stack.getTag().contains(nameKey) ? stack.getTag().getString(nameKey) : (!(sentries = Minecraft.getInstance().player.level().getEntitiesOfClass(Sentry.class, new AABB(pos))).isEmpty() && ((Sentry)sentries.get(0)).hasCustomName() ? ((Sentry)sentries.get(0)).getCustomName().getString() : Utils.localize("tooltip.securitycraft:sentry", i).getString());
            tooltip.add((Component)Component.literal((String)(ChatFormatting.GRAY + nameToShow + ": " + Utils.getFormattedCoordinates(pos).getString())));
        }
    }

    private void updateTagWithNames(ItemStack stack, Level level) {
        if (!stack.hasTag()) {
            return;
        }
        CompoundTag tag = stack.getTag();
        for (int i = 1; i <= 12; ++i) {
            int[] coords = tag.getIntArray("sentry" + i);
            String nameKey = "sentry" + i + "_name";
            if (coords.length == 3) {
                Sentry sentry;
                BlockPos sentryPos = new BlockPos(coords[0], coords[1], coords[2]);
                if (!level.isLoaded(sentryPos)) continue;
                List sentries = level.getEntitiesOfClass(Sentry.class, new AABB(sentryPos));
                if (!sentries.isEmpty() && (sentry = (Sentry)sentries.get(0)).hasCustomName()) {
                    tag.putString(nameKey, sentry.getCustomName().getString());
                    continue;
                }
            }
            tag.remove(nameKey);
        }
    }

    private void removeSentry(ItemStack stack, BlockPos pos) {
        if (stack.getTag() == null) {
            return;
        }
        for (int i = 1; i <= 12; ++i) {
            int[] coords = stack.getTag().getIntArray("sentry" + i);
            if (coords.length != 3 || coords[0] != pos.getX() || coords[1] != pos.getY() || coords[2] != pos.getZ()) continue;
            stack.getTag().remove("sentry" + i);
            return;
        }
    }

    public static boolean hasSentryAdded(CompoundTag tag) {
        if (tag == null) {
            return false;
        }
        for (int i = 1; i <= 12; ++i) {
            if (!tag.contains("sentry" + i)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSentryAdded(ItemStack stack, BlockPos pos) {
        if (stack.getTag() == null) {
            return false;
        }
        for (int i = 1; i <= 12; ++i) {
            int[] coords = stack.getTag().getIntArray("sentry" + i);
            if (coords.length != 3 || coords[0] != pos.getX() || coords[1] != pos.getY() || coords[2] != pos.getZ()) continue;
            return true;
        }
        return false;
    }

    public static int getNextAvailableSlot(ItemStack stack) {
        if (stack.getTag() == null) {
            return 1;
        }
        for (int i = 1; i <= 12; ++i) {
            if (stack.getTag().getIntArray("sentry" + i).length == 3) continue;
            return i;
        }
        return 0;
    }
}

