/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.blocks.SonicSecuritySystemBlock;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class SonicSecuritySystemItem
extends BlockItem {
    public SonicSecuritySystemItem(Item.Properties properties) {
        super((Block)SCContent.SONIC_SECURITY_SYSTEM.get(), properties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        BlockPos pos;
        BlockEntity be;
        Level level = ctx.getLevel();
        Player player = ctx.getPlayer();
        if (!level.isClientSide && !player.isShiftKeyDown() && (be = level.getBlockEntity(pos = ctx.getClickedPos())) instanceof ILockable) {
            IOwnable ownable;
            if (be instanceof IOwnable && !(ownable = (IOwnable)be).isOwnedBy((Entity)player)) {
                if (!(be.getBlockState().getBlock() instanceof IDisguisable) || !IDisguisable.getDisguisedBlockState(be, (LevelReader)level).isPresent()) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((SonicSecuritySystemBlock)SCContent.SONIC_SECURITY_SYSTEM.get()).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:notOwned", ownable.getOwner().getName()), ChatFormatting.GREEN);
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (stack.getTag() == null) {
                    stack.setTag(new CompoundTag());
                }
                if (SonicSecuritySystemItem.isAdded(stack.getTag(), pos)) {
                    SonicSecuritySystemItem.removeLinkedBlock(stack.getTag(), pos);
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((SonicSecuritySystemBlock)SCContent.SONIC_SECURITY_SYSTEM.get()).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:sonic_security_system.blockUnlinked", Utils.localize(level.getBlockState(pos).getBlock().getDescriptionId(), new Object[0]), pos), ChatFormatting.GREEN);
                    return InteractionResult.SUCCESS;
                }
                if (SonicSecuritySystemItem.addLinkedBlock(stack.getOrCreateTag(), pos, player)) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((SonicSecuritySystemBlock)SCContent.SONIC_SECURITY_SYSTEM.get()).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:sonic_security_system.blockLinked", Utils.localize(level.getBlockState(pos).getBlock().getDescriptionId(), new Object[0]), pos), ChatFormatting.GREEN);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        if (!stack.hasTag() || !SonicSecuritySystemItem.hasLinkedBlock(stack.getTag())) {
            if (!level.isClientSide) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((SonicSecuritySystemBlock)SCContent.SONIC_SECURITY_SYSTEM.get()).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:sonic_security_system.notLinked", new Object[0]), ChatFormatting.DARK_RED);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (level.isClientSide) {
            ClientHandler.displaySSSItemScreen(player.getItemInHand(hand));
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level level, Player player, ItemStack stack, BlockState state) {
        SonicSecuritySystemBlockEntity sss;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SonicSecuritySystemBlockEntity && (sss = (SonicSecuritySystemBlockEntity)blockEntity).transferPositionsFromItem(stack.getOrCreateTag())) {
            return true;
        }
        return super.updateCustomBlockEntityTag(pos, level, player, stack, state);
    }

    public void appendHoverText(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        if (!stack.hasTag()) {
            return;
        }
        int numOfLinkedBlocks = stack.getTag().getList("LinkedBlocks", 10).size();
        if (numOfLinkedBlocks > 0) {
            tooltip.add((Component)Utils.localize("tooltip.securitycraft:sonicSecuritySystem.linkedTo", numOfLinkedBlocks).withStyle(Utils.GRAY_STYLE));
        }
    }

    public static boolean addLinkedBlock(CompoundTag tag, BlockPos pos, Player player) {
        if (SonicSecuritySystemItem.isAdded(tag, pos)) {
            return false;
        }
        ListTag list = tag.getList("LinkedBlocks", 10);
        if (list.size() >= 30) {
            PlayerUtils.sendMessageToPlayer(player, Utils.localize(((SonicSecuritySystemBlock)SCContent.SONIC_SECURITY_SYSTEM.get()).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:sonic_security_system.linkMaxReached", 30), ChatFormatting.DARK_RED);
            return false;
        }
        CompoundTag nbt = NbtUtils.writeBlockPos((BlockPos)pos);
        list.add((Object)nbt);
        tag.put("LinkedBlocks", (Tag)list);
        return true;
    }

    public static void removeLinkedBlock(CompoundTag tag, BlockPos pos) {
        if (tag == null || !tag.contains("LinkedBlocks")) {
            return;
        }
        ListTag list = tag.getList("LinkedBlocks", 10);
        for (int i = list.size() - 1; i >= 0; --i) {
            BlockPos posRead = NbtUtils.readBlockPos((CompoundTag)list.getCompound(i));
            if (!pos.equals((Object)posRead)) continue;
            list.remove(i);
        }
    }

    public static boolean isAdded(CompoundTag tag, BlockPos pos) {
        if (tag == null || !tag.contains("LinkedBlocks")) {
            return false;
        }
        ListTag list = tag.getList("LinkedBlocks", 10);
        for (int i = 0; i < list.size(); ++i) {
            BlockPos posRead = NbtUtils.readBlockPos((CompoundTag)list.getCompound(i));
            if (!pos.equals((Object)posRead)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLinkedBlock(CompoundTag tag) {
        if (tag == null || !tag.contains("LinkedBlocks")) {
            return false;
        }
        return !tag.getList("LinkedBlocks", 10).isEmpty();
    }

    public static Set<BlockPos> stackTagToBlockPosSet(CompoundTag itemTag) {
        if (itemTag == null || !itemTag.contains("LinkedBlocks")) {
            return Set.of();
        }
        ListTag blocks = itemTag.getList("LinkedBlocks", 10);
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        for (int i = 0; i < blocks.size(); ++i) {
            positions.add(NbtUtils.readBlockPos((CompoundTag)blocks.getCompound(i)));
        }
        return positions;
    }
}

