/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.Map;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.inventory.BlockReinforcerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class UniversalBlockReinforcerItem
extends Item {
    public UniversalBlockReinforcerItem(Item.Properties properties) {
        super(properties);
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            public ItemStack execute(BlockSource source, ItemStack stack) {
                BlockState state = source.state();
                if (state.is(SCContent.REINFORCED_DISPENSER)) {
                    ServerLevel level = source.level();
                    BlockPos modifyPos = source.pos().relative((Direction)state.getValue((Property)DispenserBlock.FACING));
                    BlockState modifyState = level.getBlockState(modifyPos);
                    this.setSuccess(UniversalBlockReinforcerItem.convertBlock(modifyState, (Level)level, stack, modifyPos, null, ((IOwnable)source.blockEntity()).getOwner()));
                    if (this.isSuccess() && !level.isClientSide && stack.hurt(1, level.getRandom(), null)) {
                        stack.setCount(0);
                    }
                    return stack;
                }
                return this.defaultDispenseItemBehavior.dispense(source, stack);
            }
        });
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        final ItemStack heldItem = player.getItemInHand(hand);
        if (!level.isClientSide) {
            UniversalBlockReinforcerItem.maybeRemoveMending(heldItem);
            player.openMenu(new MenuProvider(){

                public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
                    return new BlockReinforcerMenu(windowId, inv, UniversalBlockReinforcerItem.this == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get());
                }

                public Component getDisplayName() {
                    return heldItem.getHoverName();
                }

                public void writeClientSideData(AbstractContainerMenu menu, FriendlyByteBuf buffer) {
                    super.writeClientSideData(menu, buffer);
                    buffer.writeBoolean(UniversalBlockReinforcerItem.this == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get());
                }
            });
        }
        return InteractionResultHolder.consume((Object)heldItem);
    }

    public static boolean convertBlock(BlockState state, Level level, ItemStack stack, BlockPos pos, Player player) {
        if (!player.isCreative() && level.mayInteract(player, pos)) {
            boolean result = UniversalBlockReinforcerItem.convertBlock(state, level, stack, pos, player, new Owner(player));
            if (result && !level.isClientSide) {
                stack.hurtAndBreak(1, (LivingEntity)player, p -> p.broadcastBreakEvent(p.getUsedItemHand()));
            }
            return result;
        }
        return false;
    }

    public static boolean convertBlock(BlockState state, Level level, ItemStack stack, BlockPos pos, Player player, Owner owner) {
        boolean isReinforcing = UniversalBlockReinforcerItem.isReinforcing(stack);
        Block block = state.getBlock();
        Block convertedBlock = (isReinforcing ? IReinforcedBlock.VANILLA_TO_SECURITYCRAFT : IReinforcedBlock.SECURITYCRAFT_TO_VANILLA).get(block);
        BlockState convertedState = null;
        if (isReinforcing && convertedBlock instanceof IReinforcedBlock) {
            IReinforcedBlock rb = (IReinforcedBlock)convertedBlock;
            convertedState = rb.convertToReinforced(level, pos, state);
        } else if (!isReinforcing && block instanceof IReinforcedBlock) {
            IReinforcedBlock rb = (IReinforcedBlock)block;
            convertedState = rb.convertToVanilla(level, pos, state);
        }
        if (convertedState != null) {
            BlockEntity be = level.getBlockEntity(pos);
            CompoundTag tag = null;
            if (be instanceof IOwnable) {
                IOwnable ownable = (IOwnable)be;
                if (player != null && !ownable.isOwnedBy((Entity)player) || !ownable.isOwnedBy(owner)) {
                    return false;
                }
            }
            if (!level.isClientSide) {
                if (be != null) {
                    tag = be.saveWithoutMetadata();
                    if (be instanceof IModuleInventory) {
                        IModuleInventory inv = (IModuleInventory)be;
                        inv.dropAllModules();
                    }
                    if (be instanceof Container) {
                        Container container = (Container)be;
                        container.clearContent();
                    } else if (be instanceof LecternBlockEntity) {
                        LecternBlockEntity lectern = (LecternBlockEntity)be;
                        lectern.clearContent();
                    }
                }
                level.setBlockAndUpdate(pos, convertedState);
                be = level.getBlockEntity(pos);
                if (be != null) {
                    if (tag != null) {
                        be.load(tag);
                    }
                    if (isReinforcing) {
                        ((IOwnable)be).setOwner(owner.getUUID(), owner.getName());
                    }
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isReinforcing(ItemStack stack) {
        return stack.is((Item)SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get()) || !stack.getOrCreateTag().getBoolean("is_unreinforcing");
    }

    public static void maybeRemoveMending(ItemStack stack) {
        Map enchantments = EnchantmentHelper.getEnchantments((ItemStack)stack);
        if (enchantments.containsKey(Enchantments.MENDING)) {
            enchantments.remove(Enchantments.MENDING);
            EnchantmentHelper.setEnchantments((Map)enchantments, (ItemStack)stack);
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return !EnchantmentHelper.getEnchantments((ItemStack)book).containsKey(Enchantments.MENDING);
    }
}

