/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.blockentities.DisplayCaseBlockEntity;
import net.geforcemods.securitycraft.items.BriefcaseItem;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;

public class UniversalKeyChangerItem
extends Item {
    public UniversalKeyChangerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        DisplayCaseBlockEntity displayCase;
        Player player = ctx.getPlayer();
        InteractionHand hand = ctx.getHand();
        Level level = ctx.getLevel();
        InteractionResult briefcaseResult = this.handleBriefcase(level, player, hand).getResult();
        if (briefcaseResult != InteractionResult.PASS) {
            return briefcaseResult;
        }
        BlockPos pos = ctx.getClickedPos();
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof DisplayCaseBlockEntity && (displayCase = (DisplayCaseBlockEntity)be).isOpen() && displayCase.getDisplayedStack().isEmpty()) {
            return InteractionResult.PASS;
        }
        if (be instanceof IPasscodeProtected) {
            IDisguisable db;
            if (((IOwnable)be).isOwnedBy((Entity)player) || player.isCreative()) {
                if (!level.isClientSide) {
                    PacketDistributor.PLAYER.with((Object)((ServerPlayer)player)).send(new CustomPacketPayload[]{new OpenScreen(OpenScreen.DataType.CHANGE_PASSCODE, pos)});
                }
                return InteractionResult.SUCCESS;
            }
            Block block = be.getBlockState().getBlock();
            if (!(block instanceof IDisguisable) || ((BlockItem)(db = (IDisguisable)block).getDisguisedStack((BlockGetter)level, pos).getItem()).getBlock() instanceof IDisguisable) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((UniversalKeyChangerItem)((Object)SCContent.UNIVERSAL_KEY_CHANGER.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:notOwned", PlayerUtils.getOwnerComponent(((IOwnable)be).getOwner())), ChatFormatting.RED);
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        return this.handleBriefcase(level, player, hand);
    }

    private InteractionResultHolder<ItemStack> handleBriefcase(Level level, Player player, InteractionHand hand) {
        ItemStack keyChanger = player.getItemInHand(hand);
        if (hand == InteractionHand.MAIN_HAND && player.getOffhandItem().getItem() == SCContent.BRIEFCASE.get()) {
            ItemStack briefcase = player.getOffhandItem();
            if (BriefcaseItem.isOwnedBy(briefcase, player) || player.isCreative()) {
                CompoundTag tag = briefcase.getTag();
                if (tag != null && tag.contains("passcode")) {
                    if (tag.contains("saltKey") && !level.isClientSide) {
                        SaltData.removeSalt(tag.getUUID("saltKey"));
                    }
                    PasscodeUtils.filterPasscodeAndSaltFromTag(tag);
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((UniversalKeyChangerItem)((Object)SCContent.UNIVERSAL_KEY_CHANGER.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:universalKeyChanger.briefcase.passcodeReset", new Object[0]), ChatFormatting.GREEN);
                    return InteractionResultHolder.success((Object)keyChanger);
                }
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((UniversalKeyChangerItem)((Object)SCContent.UNIVERSAL_KEY_CHANGER.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:universalKeyChanger.briefcase.noPasscode", new Object[0]), ChatFormatting.RED);
            } else {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((UniversalKeyChangerItem)((Object)SCContent.UNIVERSAL_KEY_CHANGER.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:universalKeyChanger.briefcase.notOwned", new Object[0]), ChatFormatting.RED);
            }
            return InteractionResultHolder.consume((Object)keyChanger);
        }
        return InteractionResultHolder.pass((Object)keyChanger);
    }
}

