/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisplayCaseBlockEntity;
import net.geforcemods.securitycraft.items.BriefcaseItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.IBlockMine;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.loading.FMLEnvironment;

public class UniversalOwnerChangerItem
extends Item {
    public UniversalOwnerChangerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        boolean isDefault;
        DisplayCaseBlockEntity displayCase;
        InteractionHand hand = ctx.getHand();
        Player player = ctx.getPlayer();
        if (hand == InteractionHand.MAIN_HAND && player.getOffhandItem().getItem() == SCContent.BRIEFCASE.get()) {
            return this.handleBriefcase(player, stack).getResult();
        }
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        BlockEntity be = level.getBlockEntity(pos);
        String newOwner = stack.getHoverName().getString();
        if (!(be instanceof IOwnable)) {
            PlayerUtils.sendMessageToPlayer(player, Utils.localize(((UniversalOwnerChangerItem)((Object)SCContent.UNIVERSAL_OWNER_CHANGER.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:universalOwnerChanger.cantChange", new Object[0]), ChatFormatting.RED);
            return InteractionResult.FAIL;
        }
        IOwnable ownable = (IOwnable)be;
        if (be instanceof DisplayCaseBlockEntity && (displayCase = (DisplayCaseBlockEntity)be).isOpen()) {
            return InteractionResult.PASS;
        }
        Owner owner = ownable.getOwner();
        boolean bl = isDefault = owner.getName().equals("owner") && owner.getUUID().equals("ownerUUID");
        if (!ownable.isOwnedBy((Entity)player) && !isDefault) {
            IDisguisable db;
            Block block2;
            if (!(block instanceof IBlockMine || (block2 = be.getBlockState().getBlock()) instanceof IDisguisable && !(((BlockItem)(db = (IDisguisable)block2).getDisguisedStack((BlockGetter)level, pos).getItem()).getBlock() instanceof IDisguisable))) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((UniversalOwnerChangerItem)((Object)SCContent.UNIVERSAL_OWNER_CHANGER.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:universalOwnerChanger.notOwned", new Object[0]), ChatFormatting.RED);
                return InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        }
        if (!stack.hasCustomHoverName() && !isDefault) {
            PlayerUtils.sendMessageToPlayer(player, Utils.localize(((UniversalOwnerChangerItem)((Object)SCContent.UNIVERSAL_OWNER_CHANGER.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:universalOwnerChanger.noName", new Object[0]), ChatFormatting.RED);
            return InteractionResult.FAIL;
        }
        if (isDefault) {
            if (((Boolean)ConfigHandler.SERVER.allowBlockClaim.get()).booleanValue()) {
                newOwner = player.getName().getString();
            } else {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((UniversalOwnerChangerItem)((Object)SCContent.UNIVERSAL_OWNER_CHANGER.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:universalOwnerChanger.noBlockClaiming", new Object[0]), ChatFormatting.RED);
                return InteractionResult.FAIL;
            }
        }
        Owner oldOwner = ownable.getOwner().copy();
        ownable.setOwner(PlayerUtils.isPlayerOnline(newOwner) ? PlayerUtils.getPlayerFromName(newOwner).getUUID().toString() : "ownerUUID", newOwner);
        ownable.onOwnerChanged(state, level, pos, player, oldOwner, ownable.getOwner());
        if (!level.isClientSide) {
            level.sendBlockUpdated(pos, state, state, 3);
        }
        if (FMLEnvironment.production && be instanceof IModuleInventory) {
            IModuleInventory inv = (IModuleInventory)be;
            for (ModuleType moduleType : inv.getInsertedModules()) {
                ItemStack moduleStack = inv.getModule(moduleType);
                inv.removeModule(moduleType, false);
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)moduleStack);
            }
        }
        PlayerUtils.sendMessageToPlayer(player, Utils.localize(((UniversalOwnerChangerItem)((Object)SCContent.UNIVERSAL_OWNER_CHANGER.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:universalOwnerChanger.changed", newOwner), ChatFormatting.GREEN);
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack ownerChanger = player.getItemInHand(hand);
        if (!ownerChanger.hasCustomHoverName()) {
            PlayerUtils.sendMessageToPlayer(player, Utils.localize(((UniversalOwnerChangerItem)((Object)SCContent.UNIVERSAL_OWNER_CHANGER.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:universalOwnerChanger.noName", new Object[0]), ChatFormatting.RED);
            return InteractionResultHolder.fail((Object)ownerChanger);
        }
        if (hand == InteractionHand.MAIN_HAND && player.getOffhandItem().getItem() == SCContent.BRIEFCASE.get()) {
            return this.handleBriefcase(player, ownerChanger);
        }
        return InteractionResultHolder.pass((Object)ownerChanger);
    }

    private InteractionResultHolder<ItemStack> handleBriefcase(Player player, ItemStack ownerChanger) {
        ItemStack briefcase = player.getOffhandItem();
        if (BriefcaseItem.isOwnedBy(briefcase, player)) {
            String newOwner = ownerChanger.getHoverName().getString();
            if (!briefcase.hasTag()) {
                briefcase.setTag(new CompoundTag());
            }
            briefcase.getTag().putString("owner", newOwner);
            briefcase.getTag().putString("ownerUUID", PlayerUtils.isPlayerOnline(newOwner) ? PlayerUtils.getPlayerFromName(newOwner).getUUID().toString() : "ownerUUID");
            PlayerUtils.sendMessageToPlayer(player, Utils.localize(((UniversalOwnerChangerItem)((Object)SCContent.UNIVERSAL_OWNER_CHANGER.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:universalOwnerChanger.changed", newOwner), ChatFormatting.GREEN);
            return InteractionResultHolder.success((Object)ownerChanger);
        }
        PlayerUtils.sendMessageToPlayer(player, Utils.localize(((UniversalOwnerChangerItem)((Object)SCContent.UNIVERSAL_OWNER_CHANGER.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:universalOwnerChanger.briefcase.notOwned", new Object[0]), ChatFormatting.RED);
        return InteractionResultHolder.consume((Object)ownerChanger);
    }
}

