/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import java.util.function.Consumer;
import net.geforcemods.securitycraft.entity.camera.CameraController;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.minecraft.client.KeyMapping;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;

@Mod.EventBusSubscriber(modid="securitycraft", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class KeyBindings {
    public static KeyMapping cameraZoomIn;
    public static KeyMapping cameraZoomOut;
    public static TickingKeyMapping<SecurityCamera> cameraEmitRedstone;
    public static TickingKeyMapping<SecurityCamera> cameraActivateNightVision;
    public static TickingKeyMapping<SecurityCamera> setDefaultViewingDirection;

    private KeyBindings() {
    }

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        cameraZoomIn = KeyBindings.register(event, "cameraZoomIn", 61);
        cameraZoomOut = KeyBindings.register(event, "cameraZoomOut", 45);
        cameraEmitRedstone = KeyBindings.registerTicking(event, "cameraEmitRedstone", 82, CameraController::toggleRedstone);
        cameraActivateNightVision = KeyBindings.registerTicking(event, "cameraActivateNightVision", 78, CameraController::toggleNightVision);
        setDefaultViewingDirection = KeyBindings.registerTicking(event, "setDefaultViewingDirection", 85, CameraController::setDefaultViewingDirection);
    }

    private static KeyMapping register(RegisterKeyMappingsEvent event, String name, int defaultKey) {
        SCKeyMapping keyMapping = new SCKeyMapping(name, defaultKey);
        event.register((KeyMapping)keyMapping);
        return keyMapping;
    }

    private static <T> TickingKeyMapping<T> registerTicking(RegisterKeyMappingsEvent event, String name, int defaultKey, Consumer<T> action) {
        TickingKeyMapping<T> keyMapping = new TickingKeyMapping<T>(name, defaultKey, action);
        event.register(keyMapping);
        return keyMapping;
    }

    public static class TickingKeyMapping<T>
    extends SCKeyMapping {
        private static final int MAX_COOLDOWN = 30;
        private int cooldown = 30;
        private Consumer<T> action;

        public TickingKeyMapping(String name, int defaultKey, Consumer<T> action) {
            super(name, defaultKey);
            this.action = action;
        }

        public void tick(T t) {
            --this.cooldown;
            if (this.consumeClick() && this.cooldown <= 0) {
                this.action.accept(t);
                this.cooldown = 30;
            }
        }
    }

    public static class SCKeyMapping
    extends KeyMapping {
        public SCKeyMapping(String name, int defaultKey) {
            super("key.securitycraft." + name, defaultKey, "key.categories.securitycraft");
        }
    }
}

