/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.blockentities.FrameBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class InteractWithFrame
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "interact_with_frame");
    private BlockPos pos;
    private boolean owner;

    public InteractWithFrame() {
    }

    public InteractWithFrame(BlockPos pos, boolean owner) {
        this.pos = pos;
        this.owner = owner;
    }

    public InteractWithFrame(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.owner = buf.readBoolean();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeBoolean(this.owner);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(IPayloadContext ctx) {
        Level level = Minecraft.getInstance().player.level();
        BlockEntity blockEntity = level.getBlockEntity(this.pos);
        if (blockEntity instanceof FrameBlockEntity) {
            FrameBlockEntity be = (FrameBlockEntity)blockEntity;
            if (!be.redstoneSignalDisabled() && !be.hasClientInteracted() && be.getCurrentCamera() != null) {
                be.setCameraOnClientAndUpdate(be.getCurrentCamera());
            } else {
                ClientHandler.displayFrameScreen(be, !this.owner);
            }
        }
    }
}

