/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecureRedstoneInterfaceBlockEntity;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.blockentities.UsernameLoggerBlockEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class OpenScreen
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "open_screen");
    private DataType dataType;
    private BlockPos pos;
    private CompoundTag tag;
    private int entityId;

    public OpenScreen() {
    }

    public OpenScreen(DataType dataType) {
        this.dataType = dataType;
        if (dataType.needsPosition) {
            throw new IllegalArgumentException(String.format("The DataType %s needs a position, but none was supplied.", dataType.name()));
        }
    }

    public OpenScreen(DataType dataType, BlockPos pos) {
        this.dataType = dataType;
        this.pos = pos;
    }

    public OpenScreen(DataType dataType, CompoundTag tag) {
        this.dataType = dataType;
        this.tag = tag;
    }

    public OpenScreen(DataType dataType, int entityId) {
        this.dataType = dataType;
        this.entityId = entityId;
    }

    public OpenScreen(FriendlyByteBuf buf) {
        this.dataType = (DataType)buf.readEnum(DataType.class);
        if (this.dataType.needsPosition) {
            this.pos = buf.readBlockPos();
        } else if (this.dataType == DataType.SENTRY_REMOTE_ACCESS_TOOL) {
            this.tag = buf.readNbt();
        } else if (this.dataType == DataType.CHANGE_PASSCODE_FOR_ENTITY || this.dataType == DataType.CHECK_PASSCODE_FOR_ENTITY || this.dataType == DataType.SET_PASSCODE_FOR_ENTITY) {
            this.entityId = buf.readVarInt();
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeEnum((Enum)this.dataType);
        if (this.dataType.needsPosition) {
            buf.writeBlockPos(this.pos);
        } else if (this.dataType == DataType.SENTRY_REMOTE_ACCESS_TOOL) {
            buf.writeNbt((Tag)this.tag);
        } else if (this.dataType == DataType.CHANGE_PASSCODE_FOR_ENTITY || this.dataType == DataType.CHECK_PASSCODE_FOR_ENTITY || this.dataType == DataType.SET_PASSCODE_FOR_ENTITY) {
            buf.writeVarInt(this.entityId);
        }
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        Level level = ((Player)ctx.player().get()).level();
        switch (this.dataType) {
            case ALARM: {
                BlockEntity blockEntity = level.getBlockEntity(this.pos);
                if (!(blockEntity instanceof AlarmBlockEntity)) break;
                AlarmBlockEntity be = (AlarmBlockEntity)blockEntity;
                ClientHandler.displayAlarmScreen(be);
                break;
            }
            case CHANGE_PASSCODE: {
                BlockEntity blockEntity = level.getBlockEntity(this.pos);
                if (!(blockEntity instanceof IPasscodeProtected)) break;
                IPasscodeProtected be = (IPasscodeProtected)blockEntity;
                ClientHandler.displayUniversalKeyChangerScreen((BlockEntity)be);
                break;
            }
            case CHANGE_PASSCODE_FOR_ENTITY: {
                Entity entity = level.getEntity(this.entityId);
                if (!(entity instanceof IPasscodeProtected)) break;
                IPasscodeProtected entity2 = (IPasscodeProtected)entity;
                ClientHandler.displayUniversalKeyChangerScreen((Entity)entity2);
                break;
            }
            case CHECK_PASSCODE: {
                BlockEntity blockEntity = level.getBlockEntity(this.pos);
                if (!(blockEntity instanceof IPasscodeProtected)) break;
                IPasscodeProtected be = (IPasscodeProtected)blockEntity;
                ClientHandler.displayCheckPasscodeScreen((BlockEntity)be);
                break;
            }
            case CHECK_PASSCODE_FOR_BRIEFCASE: {
                ItemStack briefcaseStack = PlayerUtils.getItemStackFromAnyHand(ClientHandler.getClientPlayer(), (Item)SCContent.BRIEFCASE.get());
                if (briefcaseStack.isEmpty()) break;
                ClientHandler.displayBriefcasePasscodeScreen(briefcaseStack.getHoverName());
                break;
            }
            case CHECK_PASSCODE_FOR_ENTITY: {
                Entity entity = level.getEntity(this.entityId);
                if (!(entity instanceof IPasscodeProtected)) break;
                IPasscodeProtected entity3 = (IPasscodeProtected)entity;
                ClientHandler.displayCheckPasscodeScreen((Entity)entity3);
                break;
            }
            case RIFT_STABILIZER: {
                BlockEntity blockEntity = level.getBlockEntity(this.pos);
                if (!(blockEntity instanceof RiftStabilizerBlockEntity)) break;
                RiftStabilizerBlockEntity riftStabilizer = (RiftStabilizerBlockEntity)blockEntity;
                ClientHandler.displayRiftStabilizerScreen(riftStabilizer);
                break;
            }
            case SECURE_REDSTONE_INTERFACE: {
                BlockEntity blockEntity = level.getBlockEntity(this.pos);
                if (!(blockEntity instanceof SecureRedstoneInterfaceBlockEntity)) break;
                SecureRedstoneInterfaceBlockEntity secureRedstoneInterface = (SecureRedstoneInterfaceBlockEntity)blockEntity;
                ClientHandler.displaySecureRedstoneInterfaceScreen(secureRedstoneInterface);
                break;
            }
            case SENTRY_REMOTE_ACCESS_TOOL: {
                ItemStack srat = PlayerUtils.getItemStackFromAnyHand(ClientHandler.getClientPlayer(), (Item)SCContent.SENTRY_REMOTE_ACCESS_TOOL.get());
                if (srat.isEmpty()) break;
                srat.setTag(this.tag);
                ClientHandler.displaySRATScreen(srat);
                break;
            }
            case SET_PASSCODE: {
                BlockEntity blockEntity = level.getBlockEntity(this.pos);
                if (!(blockEntity instanceof IPasscodeProtected)) break;
                IPasscodeProtected be = (IPasscodeProtected)blockEntity;
                ClientHandler.displaySetPasscodeScreen((BlockEntity)be);
                break;
            }
            case SET_PASSCODE_FOR_BRIEFCASE: {
                ItemStack briefcase = PlayerUtils.getItemStackFromAnyHand(ClientHandler.getClientPlayer(), (Item)SCContent.BRIEFCASE.get());
                if (briefcase.isEmpty()) break;
                ClientHandler.displayBriefcaseSetupScreen((Component)briefcase.getHoverName().plainCopy().append((Component)Component.literal((String)" ")).append((Component)Utils.localize("gui.securitycraft:passcode.setup", new Object[0])));
                break;
            }
            case SET_PASSCODE_FOR_ENTITY: {
                Entity entity = level.getEntity(this.entityId);
                if (!(entity instanceof IPasscodeProtected)) break;
                IPasscodeProtected entity4 = (IPasscodeProtected)entity;
                ClientHandler.displaySetPasscodeScreen((Entity)entity4);
                break;
            }
            case SONIC_SECURITY_SYSTEM: {
                BlockEntity blockEntity = level.getBlockEntity(this.pos);
                if (!(blockEntity instanceof SonicSecuritySystemBlockEntity)) break;
                SonicSecuritySystemBlockEntity sss = (SonicSecuritySystemBlockEntity)blockEntity;
                ClientHandler.displaySonicSecuritySystemScreen(sss);
                break;
            }
            case USERNAME_LOGGER: {
                BlockEntity blockEntity = level.getBlockEntity(this.pos);
                if (!(blockEntity instanceof UsernameLoggerBlockEntity)) break;
                UsernameLoggerBlockEntity logger = (UsernameLoggerBlockEntity)blockEntity;
                ClientHandler.displayUsernameLoggerScreen(logger);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled data type: " + this.dataType.name());
            }
        }
    }

    public static enum DataType {
        ALARM(true),
        CHANGE_PASSCODE(true),
        CHANGE_PASSCODE_FOR_ENTITY(false),
        CHECK_PASSCODE(true),
        CHECK_PASSCODE_FOR_BRIEFCASE(false),
        CHECK_PASSCODE_FOR_ENTITY(false),
        RIFT_STABILIZER(true),
        SENTRY_REMOTE_ACCESS_TOOL(false),
        SECURE_REDSTONE_INTERFACE(true),
        SET_PASSCODE(true),
        SET_PASSCODE_FOR_BRIEFCASE(false),
        SET_PASSCODE_FOR_ENTITY(false),
        SONIC_SECURITY_SYSTEM(true),
        USERNAME_LOGGER(true);

        public final boolean needsPosition;

        private DataType(boolean needsPosition) {
            this.needsPosition = needsPosition;
        }
    }
}

