/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class PlayAlarmSound
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "play_alarm_sound");
    private BlockPos bePos;
    private Holder<SoundEvent> sound;
    private int soundX;
    private int soundY;
    private int soundZ;
    private float volume;
    private float pitch;
    private long seed;

    public PlayAlarmSound() {
    }

    public PlayAlarmSound(BlockPos bePos, Holder<SoundEvent> sound, float volume, float pitch, long seed) {
        this.bePos = bePos;
        this.sound = sound;
        this.soundX = (int)((float)bePos.getX() * 8.0f);
        this.soundY = (int)((float)bePos.getY() * 8.0f);
        this.soundZ = (int)((float)bePos.getZ() * 8.0f);
        this.volume = volume;
        this.pitch = pitch;
        this.seed = seed;
    }

    public PlayAlarmSound(FriendlyByteBuf buf) {
        this.bePos = buf.readBlockPos();
        this.sound = buf.readById(BuiltInRegistries.SOUND_EVENT.asHolderIdMap(), SoundEvent::readFromNetwork);
        this.soundX = buf.readInt();
        this.soundY = buf.readInt();
        this.soundZ = buf.readInt();
        this.volume = buf.readFloat();
        this.pitch = buf.readFloat();
        this.seed = buf.readLong();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.bePos);
        buf.writeId(BuiltInRegistries.SOUND_EVENT.asHolderIdMap(), this.sound, (buffer, soundEvent) -> soundEvent.writeToNetwork(buffer));
        buf.writeInt(this.soundX);
        buf.writeInt(this.soundY);
        buf.writeInt(this.soundZ);
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
        buf.writeLong(this.seed);
    }

    public ResourceLocation id() {
        return ID;
    }

    public double getX() {
        return (float)this.soundX / 8.0f;
    }

    public double getY() {
        return (float)this.soundY / 8.0f;
    }

    public double getZ() {
        return (float)this.soundZ / 8.0f;
    }

    public void handle(PlayPayloadContext ctx) {
        Level level = ClientHandler.getClientLevel();
        BlockEntity blockEntity = level.getBlockEntity(this.bePos);
        if (blockEntity instanceof AlarmBlockEntity) {
            AlarmBlockEntity be = (AlarmBlockEntity)blockEntity;
            be.playSound(level, this.getX(), this.getY(), this.getZ(), this.sound, this.volume, this.pitch, this.seed);
        }
    }
}

