/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class RefreshDisguisableModel
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "refresh_disguisable_model");
    private BlockPos pos;
    private boolean insert;
    private ItemStack stack;
    private boolean toggled;

    public RefreshDisguisableModel() {
    }

    public RefreshDisguisableModel(BlockPos pos, boolean insert, ItemStack stack, boolean toggled) {
        this.pos = pos;
        this.insert = insert;
        this.stack = stack;
        this.toggled = toggled;
    }

    public RefreshDisguisableModel(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.insert = buf.readBoolean();
        this.stack = buf.readItem();
        this.toggled = buf.readBoolean();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeBoolean(this.insert);
        buf.writeItem(this.stack);
        buf.writeBoolean(this.toggled);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        BlockEntity be = Minecraft.getInstance().level.getBlockEntity(this.pos);
        if (be instanceof IModuleInventory) {
            IModuleInventory moduleInv = (IModuleInventory)be;
            if (this.insert) {
                moduleInv.insertModule(this.stack, this.toggled);
            } else {
                moduleInv.removeModule(ModuleType.DISGUISE, this.toggled);
            }
            ClientHandler.refreshModelData(be);
        }
    }
}

