/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import net.geforcemods.securitycraft.blockentities.TrophySystemBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class SetTrophySystemTarget
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "set_trophy_system_target");
    private BlockPos trophyPos;
    private int targetID;

    public SetTrophySystemTarget() {
    }

    public SetTrophySystemTarget(BlockPos trophyPos, int targetID) {
        this.trophyPos = trophyPos;
        this.targetID = targetID;
    }

    public SetTrophySystemTarget(FriendlyByteBuf buf) {
        this.trophyPos = buf.readBlockPos();
        this.targetID = buf.readInt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.trophyPos);
        buf.writeInt(this.targetID);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        BlockEntity blockEntity = Minecraft.getInstance().level.getBlockEntity(this.trophyPos);
        if (blockEntity instanceof TrophySystemBlockEntity) {
            TrophySystemBlockEntity be = (TrophySystemBlockEntity)blockEntity;
            Entity entity = Minecraft.getInstance().level.getEntity(this.targetID);
            if (entity instanceof Projectile) {
                Projectile projectile = (Projectile)entity;
                be.setTarget(projectile);
            }
        }
    }
}

